#ifndef ISTKsds_mdep_h     
#define ISTKsds_mdep_h     

/* $Header: sds_mdep.h,v 1.9 93/01/13 16:36:02 vern Exp $ */

/**************************************************************************
 *                 ****** ISTK Release 1.2 *****                          *
 *                                                                        *
 *                                                                        *
 * This code has been produced by numerous authors at the CERN centre for *
 * high energy physics, Geneve, Switzerland, at the SSC laboratory in     *
 * Dallas, Texas, USA and at the Lawrence Berekeley Laboratory in         *
 * California, USA.                                                       *
 * The latter two institutions perform work under US Government contract. *
 * The intent of the work is to provide useful code for people who need   *
 * it, with an emphasis on free and collaborative exchange of ideas,      *
 * techniques and implementations.                                        *
 * Please read the disclaimer and copyright notices contained in the ISTK *
 * distribution and in distributed applications.                          *
 *                                                                        *
 **************************************************************************/


/* Reference release  Aug 10 1991 - C G Saltmarsh */
/* Has the basics used at CDG & SSC 1988-1991, plus vxworks
   support
*/
/************************************************************************
 *            Copyright (C) Frogsoft Corporation,  1987                 *
 *
 *  SSC VERSION 2.0001  April 29 1988
 *
 *  Modification history:
 *
 *  1.0000 Still playing....
 *
 ***********************************************************************/
     

     
/*  PADDING BYTE INFORMATION  */
/************************************************************************
   These numbers tell you what broad architecture type you are using; 
   one of these is chosen at compile time to indicate how to pad data
   what sizes data primitives are and what floating point representations
   are used. The choice is made by testing for the standard #defines.
   Adding a new machine may be simple if the correct architecture is 
   already here. Two defined blocks must be added below: one tests for
   the machine type and defines SDS_ARC; in this block you also note if
   shared memory and/or file mapping is available on the system by
   defining SHMEM and/or MEMMAP. In the second block you define
   some of the more generic primitives - for instance whether an int
   is two or four bytes. Byte ordering is picked up automatically.

   If the architecture is not yet available, several things must be done
   before the above stuff can be entered:

   1. NARCS (number of architecture types) increases.
   2. A new architecture is defined as SDS_SUN3ARC,SDS_SPARC etc have
	been below.
   3. A new series of entries need to be made in the static array sds_arcs,
	which appears in the header dtypes.h in this directory. An array of
	NPRIMITIVES integers represent the byte boundary of each primitive
	type as defined in this file (SDS_WORD, SDS_LONG etc) and named in
	dnames.h. Also, the most restrictive boundary (eg 1 for Vax, 2 for
	680x0, 8 for sparc risc) is put in the sds_arcs array in dtypes.h.
   4. System-dependant header differences can be ironed out in the file
	sdsgen.h
   5. Proceed as above when the architecture was already in place.

	Be careful - in some cases differences happen on the same machine - eg
	VMS and ultrix vaxen - and even with different compilers.

   If you need to add a new primitive type, increase the value of NTYPES
     defined in this file and add entries to the type_name array (dnames.h),
     the sds_sizes array (dtypes.h) and the sds_arcs array (dtypes.h) for
     ALL CURRENT ARCHITECTURES.Add the define for the new type, and
     recompile everything.

****************************************************************************/
#define SDS_SUN3ARC  0
#define SDS_MASSARC  0
#define SDS_ATARIARC  0
#define SDS_MACARC  0
#define SDS_SPARC     1
#define SDS_VAXARC    2
#define SDS_HCUBESARC 4

#define  NARCS  5

#if defined(mv147) || defined(__mv147__)
#define SDS_ARC SDS_SUN3ARC
#endif

#if defined(i386)
#define SHMEM
#define SDS_ARC SDS_HCUBESARC
#endif

#if defined(mips) || defined(__mips__)
#if !defined(sgi) && !defined(__sgi__)
#define MIPS_SWAPPED
#endif 
#define SHMEM
#define MEMMAP
#define SDS_ARC SDS_SPARC
#endif 

#if defined(sparc) || defined(__sparc__)
#define SHMEM
#define MEMMAP
#define SDS_ARC SDS_SPARC
#endif 

#if defined(sun3) || defined(__sun3__)
#define SHMEM
#define MEMMAP
#define SDS_ARC SDS_SUN3ARC
#endif

#if defined(mac) || defined(__mac__)
#define SDS_ARC SDS_SUN3ARC
#endif

#if defined(masscomp) || defined(__masscomp__)
#define SHMEM
#define SDS_ARC SDS_MASSARC 
#endif 

#if defined(vax) || defined(__vax__)
#define SDS_ARC SDS_VAXARC
#endif

#ifdef atari
#define SDS_ARC SDS_ATARIARC 
#endif 

#if defined(hp9000s800) || defined(__hp9000s800__)
#define SHMEM
#define SDS_ARC SDS_SPARC
#endif

#if defined(hp9000s300) || defined(__hp9000s300__)
#define SHMEM
#define SDS_ARC SDS_SUN3ARC
#endif

#if defined(NeXT) || defined(__NeXT__)
#define SDS_ARC SDS_SUN3ARC
#endif

#ifdef __DGUX__
#define SHMEM
#define SDS_ARC SDS_SPARC
#endif

#ifdef SHMEM
/* I have Unix shared memory      */
char  *shm_make();
struct  direc *shm_attr();
struct  direc *shm_attw();
#else
#endif

#define RBYTE  (char)sds_rbytes[SDS_ARC - 1]

#define SDS_SIGNED 0
#define SDS_UNSIGNED 1

/*    element type codes */
#define  NTYPES  30
#define  NPRIMITIVES NTYPES

#define SDS_WEIRD		(unsigned long)0x00
#define SDS_PADB		(unsigned long)0x01
#define SDS_BYTE		(unsigned long)0x02
#define SDS_UNS_BYTE		(unsigned long)0x03
#define SDS_WORD		(unsigned long)0x04
#define SDS_UNS_WORD		(unsigned long)0x05
#define SDS_LONG		(unsigned long)0x06
#define SDS_UNS_LONG		(unsigned long)0x07
#define SDS_IFLOAT		(unsigned long)0x08
#define SDS_IDOUBLE		(unsigned long)0x09
#define SDS_VFLOAT		(unsigned long)0x0a

#define SDS_DVDOUBLE		(unsigned long)0x0b
#define SDS_GVDOUBLE		(unsigned long)0x0c
#define SDS_STRING		(unsigned long)0x0d
#define SDS_DIRECTORY_STRUCTURE	(unsigned long)0x0e
#define SDS_ICOMPLEX		(unsigned long)0x0f
#define SDS_IDOUBLE_COMPLEX	(unsigned long)0x10
#define SDS_VCOMPLEX		(unsigned long)0x11
#define SDS_DVDOUBLE_COMPLEX	(unsigned long)0x12
#define SDS_GVDOUBLE_COMPLEX	(unsigned long)0x13
#define SDS_LOGICAL_1		(unsigned long)0x14
#define SDS_LOGICAL_2		(unsigned long)0x15
#define SDS_LOGICAL_4		(unsigned long)0x16
#define SDS_POINTER		(unsigned long)0x17
#define SDS_TIME		(unsigned long)0x18
#define SDS_SDS			(unsigned long)0x19
#define SDS_FSTRING		(unsigned long)0x1a
#define SDS_SIZE_MODIFIER	(unsigned long)0x1b
#define SDS_GLISH_VALUE		(unsigned long)0x1c
#define SDS_UNIX_TIME		(unsigned long)0x1d



#ifdef vms
#define VAXFP
#define SDS_CHAR SDS_BYTE
#define SDS_INT SDS_LONG
#define SDS_SHORT SDS_WORD
#define SDS_UNS_CHAR SDS_UNS_BYTE
#define SDS_UNS_INT SDS_UNS_LONG
#define SDS_UNS_SHORT SDS_UNS_WORD
#define SDS_FLOAT SDS_VFLOAT
#define SDS_DOUBLE SDS_DVDOUBLE
#define SDS_COMPLEX SDS_VCOMPLEX
#define SDS_DOUBLE_COMPLEX SDS_DVDOUBLE_COMPLEX
#endif
     
#ifdef atari
#define VAXFP
#define SDS_CHAR SDS_BYTE
#define SDS_INT SDS_WORD
#define SDS_SHORT SDS_WORD
#define SDS_UNS_CHAR SDS_UNS_BYTE
#define SDS_UNS_INT SDS_UNS_WORD
#define SDS_UNS_SHORT SDS_UNS_WORD
#define SDS_FLOAT SDS_VFLOAT
#define SDS_DOUBLE SDS_DVDOUBLE
#define SDS_COMPLEX SDS_VCOMPLEX
#define SDS_DOUBLE_COMPLEX SDS_DVDOUBLE_COMPLEX
#endif

#if defined(hpux) || defined(__hpux__)
#define IEEEFP
#define SDS_FLOAT SDS_IFLOAT
#define SDS_DOUBLE SDS_IDOUBLE
#define SDS_COMPLEX SDS_ICOMPLEX
#define SDS_DOUBLE_COMPLEX SDS_IDOUBLE_COMPLEX
#define SDS_CHAR SDS_BYTE
#define SDS_INT SDS_LONG
#define SDS_SHORT SDS_WORD
#define SDS_UNS_CHAR SDS_UNS_BYTE
#define SDS_UNS_INT SDS_UNS_LONG
#define SDS_UNS_SHORT SDS_UNS_WORD
#endif

#if defined(NeXT) || defined(__NeXT__)
#define IEEEFP
#define SDS_FLOAT SDS_IFLOAT
#define SDS_DOUBLE SDS_IDOUBLE
#define SDS_COMPLEX SDS_ICOMPLEX
#define SDS_DOUBLE_COMPLEX SDS_IDOUBLE_COMPLEX
#define SDS_CHAR SDS_BYTE
#define SDS_INT SDS_LONG
#define SDS_SHORT SDS_WORD
#define SDS_UNS_CHAR SDS_UNS_BYTE
#define SDS_UNS_INT SDS_UNS_LONG
#define SDS_UNS_SHORT SDS_UNS_WORD
#endif

#if defined(sun) || defined(__sun__)
#define IEEEFP
#define SDS_FLOAT SDS_IFLOAT
#define SDS_DOUBLE SDS_IDOUBLE
#define SDS_COMPLEX SDS_ICOMPLEX
#define SDS_DOUBLE_COMPLEX SDS_IDOUBLE_COMPLEX
#define SDS_CHAR SDS_BYTE
#define SDS_INT SDS_LONG
#define SDS_SHORT SDS_WORD
#define SDS_UNS_CHAR SDS_UNS_BYTE
#define SDS_UNS_INT SDS_UNS_LONG
#define SDS_UNS_SHORT SDS_UNS_WORD
#endif

#if defined(mac) || defined(__mac__)
#define IEEEFP
#define SDS_FLOAT SDS_IFLOAT
#define SDS_DOUBLE SDS_IDOUBLE
#define SDS_COMPLEX SDS_ICOMPLEX
#define SDS_DOUBLE_COMPLEX SDS_IDOUBLE_COMPLEX
#define SDS_CHAR SDS_BYTE
#define SDS_INT SDS_LONG
#define SDS_SHORT SDS_WORD
#define SDS_UNS_CHAR SDS_UNS_BYTE
#define SDS_UNS_INT SDS_UNS_LONG
#define SDS_UNS_SHORT SDS_UNS_WORD
#endif

#ifdef __DGUX__
#define IEEEFP
#define SDS_FLOAT SDS_IFLOAT
#define SDS_DOUBLE SDS_IDOUBLE
#define SDS_COMPLEX SDS_ICOMPLEX
#define SDS_DOUBLE_COMPLEX SDS_IDOUBLE_COMPLEX
#define SDS_CHAR SDS_BYTE
#define SDS_INT SDS_LONG
#define SDS_SHORT SDS_WORD
#define SDS_UNS_CHAR SDS_UNS_BYTE
#define SDS_UNS_INT SDS_UNS_LONG
#define SDS_UNS_SHORT SDS_UNS_WORD
#endif

#if defined(mv147) || defined(__mv147__)
#define IEEEFP
#define SDS_FLOAT SDS_IFLOAT
#define SDS_DOUBLE SDS_IDOUBLE
#define SDS_COMPLEX SDS_ICOMPLEX
#define SDS_DOUBLE_COMPLEX SDS_IDOUBLE_COMPLEX
#define SDS_CHAR SDS_BYTE
#define SDS_INT SDS_LONG
#define SDS_SHORT SDS_WORD
#define SDS_UNS_CHAR SDS_UNS_BYTE
#define SDS_UNS_INT SDS_UNS_LONG
#define SDS_UNS_SHORT SDS_UNS_WORD
#endif

#if defined(i386)
#define IEEEFP
#define SDS_FLOAT SDS_IFLOAT
#define SDS_DOUBLE SDS_IDOUBLE
#define SDS_COMPLEX SDS_ICOMPLEX
#define SDS_DOUBLE_COMPLEX SDS_IDOUBLE_COMPLEX
#define SDS_CHAR SDS_BYTE
#define SDS_INT SDS_LONG
#define SDS_SHORT SDS_WORD
#define SDS_UNS_CHAR SDS_UNS_BYTE
#define SDS_UNS_INT SDS_UNS_LONG
#define SDS_UNS_SHORT SDS_UNS_WORD
#endif

#if defined(mips) || defined(__mips__)
#define IEEEFP
#define SDS_FLOAT SDS_IFLOAT
#define SDS_DOUBLE SDS_IDOUBLE
#define SDS_COMPLEX SDS_ICOMPLEX
#define SDS_DOUBLE_COMPLEX SDS_IDOUBLE_COMPLEX
#define SDS_CHAR SDS_BYTE
#define SDS_INT SDS_LONG
#define SDS_SHORT SDS_WORD
#define SDS_UNS_CHAR SDS_UNS_BYTE
#define SDS_UNS_INT SDS_UNS_LONG
#define SDS_UNS_SHORT SDS_UNS_WORD
#endif

#if defined(masscomp) || defined(__masscomp__)
#define IEEEFP
#define SDS_FLOAT SDS_IFLOAT
#define SDS_DOUBLE SDS_IDOUBLE
#define SDS_COMPLEX SDS_ICOMPLEX
#define SDS_DOUBLE_COMPLEX SDS_IDOUBLE_COMPLEX
#define SDS_CHAR SDS_BYTE
#define SDS_INT SDS_LONG
#define SDS_SHORT SDS_WORD
#define SDS_UNS_CHAR SDS_UNS_BYTE
#define SDS_UNS_INT SDS_UNS_LONG
#define SDS_UNS_SHORT SDS_UNS_WORD
#endif

#ifdef MSDOS
#define IEEEFP
#define SDS_CHAR SDS_BYTE
#define SDS_INT SDS_WORD
#define SDS_SHORT SDS_WORD
#define SDS_UNS_CHAR SDS_UNS_BYTE
#define SDS_UNS_INT SDS_UNS_WORD
#define SDS_UNS_SHORT SDS_UNS_WORD
#define SDS_FLOAT SDS_IFLOAT
#define SDS_DOUBLE SDS_IDOUBLE
#define SDS_COMPLEX SDS_COMPLEX
#define SDS_DOUBLE_COMPLEX SDS_IDOUBLE_COMPLEX
#endif
#endif
