/* $Header: sds.c,v 1.10 92/09/23 09:13:32 salty Exp $ */

/**************************************************************************
 *                 ****** ISTK Release 1.2 *****                          *
 *                                                                        *
 *                                                                        *
 * This code has been produced by numerous authors at the CERN centre for *
 * high energy physics, Geneve, Switzerland, at the SSC laboratory in     *
 * Dallas, Texas, USA and at the Lawrence Berekeley Laboratory in         *
 * California, USA.                                                       *
 * The latter two institutions perform work under US Government contract. *
 * The intent of the work is to provide useful code for people who need   *
 * it, with an emphasis on free and collaborative exchange of ideas,      *
 * techniques and implementations.                                        *
 * Please read the disclaimer and copyright notices contained in the ISTK *
 * distribution and in distributed applications.                          *
 *                                                                        *
 **************************************************************************/


/*s**********************************************************************
 *                                                                      *
 *              Copyright (C)                                           *
 *     Epsilon Eridani 3 Megasoft Corporation, 1986                     *
 *                                                                      *
 *      This library contains Proprietary Information of Frogsoft       *
 *      Corporation and should not be treated as Confidential.          *
 *                                                                      *
 *      Authors: WFH, CGS, Verklim Fartislart                           *
 *                                                                      */
/*e**********************************************************************/

/* Reference release  Aug 10 1991 - C G Saltmarsh */
/* Has the basics used at CDG & SSC 1988-1991, plus vxworks
   support
*/


#include <stdlib.h>
#include <string.h>

#ifndef vms
#include <unistd.h>
#endif

#ifndef vms
#include "Sds/sdsgen.h"
#include "Sds/dnames.h"
#include "Sds/sds_externs.h"
#else
#include "sdsgen.h"
#include "dnames.h"
#include "sds_externs.h"
#endif

extern  char      *sds_align;

/***** forward declarations ******/
void pindent();
sds_handle sds_tofile();

    
/* the last error found by the sds library */
int sds_error;

/* corresponding error strings */

char *sds_error_string[29] = 
    {
    "all ok",
    "No such SDS",
    "No space for directory",
    "Cannot open file",
    "Cannot write to file",
    "No such object",
    "Cannot read file",
    "File is not SDS",
    "File is old SDS version",
    "No open file",
    "Byte swapped SDS",
    "SDS is not assembled",
    "SDS is not initialised",
    "Type not defined",
    "SDS is not definable",
    "SDS of this name exists",
    "Transfer type unknown",
    "Element type not as requested",
    "Wrong padding type",
    "Not enough memory",
    "No db - process assigned",
    "Database access error",
    "Not a complex object",
    "Resolution lists confused",
    "Zero length object",
    "Data format is for native processor",
    "Cannot resize this object",
    "End of resolution stack",
		"Cannot find map file"
    };
     
#if !defined(psos)
char      *ctime();
#endif

/***********************************************************************/
void
nexpand(fullname,name)
/*s**********************************************************************
 *                                                                      *
 *      Expands input name to full pathname for standard sd directory   *
 *      if first character = '@', will take name literally              *
 *                                                                      *
 *              Author: CGS, WFH                                        *
 *                                                                      */
/*e**********************************************************************/
char    *fullname;
char    *name;
/***********************************************************************/
{
  char *temp;
  char *getenv();
#ifdef vxworks
  char *user;
#endif
     
  if (*name == '@' ) 
  {
    name++;
    strcpy(fullname,name);
  }
  else 
  {
#ifdef vxworks
    remCurIdGet(user, NULL);
    strcpy(fullname,"/home/");
    strcat(fullname,user);
#elif defined(psos)
    strcpy(fullname,"/home/doofus/psos");

#else
    temp = getenv("HOME");
    strcpy(fullname,temp);
#endif
    strcat(fullname,"/shardat/");
    strcat(fullname,name);
  }  
}
     
/***********************************************************************/
void    *
sds_obind2ptr(sds_index,object_index)
/*s**********************************************************************
 *                                                                      
 *      1. Return pointer to object "ielem" in  data area         
 *         with sds handle sds_index
 *      2. Return 0 if it is out-of-bounds or no entry ...              
 *                                                                      
 *      Author: CGS                                                     
 *                                                                      */
/*e**********************************************************************/
sds_code object_index;
sds_handle  sds_index;
/***********************************************************************/
{
  struct direc    *dptr = sds_direc_ptr(sds_index);

  if (dptr == DNULL) 
  {
    sds_error = SDS_NO_SUCH_SDS;
    return(NULL);
  }
  return(sds_getp(dptr,object_index));
}

/***********************************************************************/
void    *
sds_getp(dptr,ielem)
sds_code    ielem;
struct  direc*  dptr;
/***********************************************************************/
{

  unsigned long    jelem;
  char    *cptr;

  if (ielem == (unsigned long)0) 
    return((char *)dptr);

  jelem = dptr[0].nelems;
  if ( ielem > jelem ) 
  {
    sds_error = SDS_NO_SUCH_OBJ;
    return(SNULL);
  }
  if (dptr[0].offst == SDS_NOT_ASSEMBLED)
  {
    cptr = (char *)dptr[ielem].offst;
  }
  else if (dptr[ielem].offst == SDS_IMPOSSIBLE_ADDRESS)
  {
    cptr = NULL;
  }
	else
  {
    cptr = (char *)dptr + dptr[ielem].offst - dptr[0].offst;
  }
  return(cptr);
}
/***********************************************************************/
sds_handle
sds_get_checked(sds_index,object_name,type_code)
sds_handle sds_index;
char *object_name;
sds_code type_code;
/***********************************************************************/
{
  sds_handle ind;
  struct direc    *dptr = sds_direc_ptr(sds_index);

  if (dptr == DNULL) 
    return(sds_error = SDS_NO_SUCH_SDS);

  if ((ind = sds_obname2ind(sds_index,object_name)) < 0)
    return(ind);

  if (dptr[ind].elemcod != type_code)
    return(sds_error = SDS_WRONG_TYPE);

  return(ind);
}
/***********************************************************************/
sds_handle 
sds_obname2ind(sds_index,name)
sds_handle  sds_index;
char  *name;
/***********************************************************************/
{
  sds_handle nobj;
  sds_code j;
  struct direc    *dptr = sds_direc_ptr(sds_index);

  if (dptr == DNULL) 
    return(sds_error = SDS_NO_SUCH_SDS);

  nobj = dptr[0].nelems;
  for (j=0;j<nobj;j++) 
    if (!strcmp(sds_obind2name(sds_index,j),name))
      return(j);

  return(sds_error = SDS_NO_SUCH_OBJ);
}
/***********************************************************************/
sds_handle 
sds_oblike2ind(sds_index,name,start)
sds_handle  sds_index,start;
char  *name;
/***********************************************************************/
{
  sds_handle nobj;
  sds_code j;
  struct direc    *dptr = sds_direc_ptr(sds_index);

  if (dptr == DNULL) 
    return(sds_error = SDS_NO_SUCH_SDS);

  nobj = dptr[0].nelems;
  for (j=start;j<nobj;j++) 
    if (strstr(sds_obind2name(sds_index,j),name) != 0)
      return(j);

  return(sds_error = SDS_NO_SUCH_OBJ);
}
/***********************************************************************/
sds_handle 
sds_array_size(sds_index,object_index)
sds_handle sds_index;
sds_code object_index;
/***********************************************************************/
{

  struct direc    *dptr = sds_direc_ptr(sds_index);

  if (dptr == DNULL) 
    return(sds_error = SDS_NO_SUCH_SDS);

  if (object_index < dptr[0].nelems && object_index >= 0)
    return(dptr[object_index].nelems); 
  else
    return(sds_error = SDS_NO_SUCH_OBJ); 
}
/***********************************************************************/
void  *
sds_obname2ptr(sds_index,name)
sds_handle  sds_index;
char  *name;
/***********************************************************************/
{

  sds_code object_number;
  struct direc    *dptr = sds_direc_ptr(sds_index);

  if (dptr == DNULL) 
  {
    sds_error = SDS_NO_SUCH_SDS;
    return(NULL);
  }

  if ((object_number = sds_obname2ind(sds_index,name)) >= 0) 
    return(sds_getp(dptr,object_number)); 
  else
    return(NULL); 
}

/*s************************************************** 
* 
*       Stick timestamp on object obj within directory 
* 
*       The directory timestamp - dptr[0].wtime - 
*       holds Unix time (seconds since Jan 1, 1970)
*       while individual objects hold delta time 
*       since directory time (in millisecinds? - to 
*       be determined. As of now, no time info is there.) 
*****************************************************/
/***********************************************************************/
sds_handle
sds_tstamp(sds_index,obj) 
sds_handle    sds_index; 
sds_code obj;
/***********************************************************************/
{
  struct direc *dptr; 
  if ((dptr = sds_direc_ptr(sds_index)) == DNULL)
    return(sds_error = SDS_NO_SUCH_SDS); 
  if ((obj == SDS_TIMESTAMP_ALL) || (obj == (unsigned long)0)) 
  {
    dptr[0].wtime = (unsigned long)time(0); 
    if (obj != (unsigned long)0) 
    {
      unsigned long     i; 
      for (i=1;i<dptr[0].nelems;i++)
        dptr[i].wtime = i;
    } 
  } 
  else 
  {
    dptr[obj].wtime = obj; 
  }
    return(0); 
}
/***********************************************************************/
long *
sds_get_tstamp(sds_index,obj)
sds_handle sds_index;
sds_code obj;
/***********************************************************************/
{
  struct direc *dptr; 
  if ((dptr = sds_direc_ptr(sds_index)) == DNULL)
  {
    sds_error = SDS_NO_SUCH_SDS; 
    return NULL;
  }
  if (obj < 0 || obj > dptr[0].nelems)
  {
    sds_error = SDS_NO_SUCH_OBJ; 
    return NULL;
  }
  return (long *)&dptr[obj].wtime;
}


/***********************************************************************/
char  *
load_sds_file(fd,nbytes)
int        fd;
unsigned long   nbytes;
/***********************************************************************/
{
  char    *sdptr;

  sdptr = malloc((unsigned int)nbytes + BASE_OFFSET);

  if (sdptr == (char ) 0)
  {
     sds_perror("malloc failure, load_sds_file");
    exit(1);
  }
  if (sds_vread(fd,sdptr,(int)nbytes) != nbytes) 
  {
    free(sdptr);
    sds_error = SDS_FILE_RD;
    return(SNULL);
  }
  else 
  {
    return(sdptr);
  }
}
/***********************************************************************/
struct direc  *
f2mem(ffname)
char    *ffname;
/*  Heave the whole of a file into memory        */
/***********************************************************************/
{
  int     fd;
  char  *sdptr;
  struct sds_header *sdsh;
     
    if ((fd = open(ffname,O_RDONLY,0x644)) == -1) 
  {
    sds_error = SDS_FILE_OP;
    return(DNULL);
  }
  sdptr = load_sds_file(fd,fsiz(ffname));
  close(fd);

  if  (sdptr == SNULL) 
    return(DNULL);
  sdsh = (struct sds_header*)sdptr;
  if (sdsh->magic_number != SDS_MAGIC) 
  {
    if ((sdsh->magic_number & 0xffff00ff) == SDS_BASE_MAGIC)
      sds_error = SDS_WRONG_PADS;
    else if ((sdsh->magic_number & 0xff00ffff) == SDS_MAGIC_BYTESWAP)
      sds_error = SDS_SWAPPED_BYTES;
    else 
      sds_error = SDS_NOT_SDS;
    free(sdptr);
    return(DNULL);
  }
  sdptr += BASE_OFFSET + (int)sdsh->list_size + (int)sdsh->heap_size;
  return((struct direc *)sdptr);
}
/***********************************************************************/
sds_handle
sds_tofile(sds,ffname)
char    *ffname;
sds_handle  sds;
/***********************************************************************/
{
  struct direc *dptr; 
  if ((dptr = sds_direc_ptr(sds)) == DNULL)
    return(sds_error = SDS_NO_SUCH_SDS); 
  return(sds_back(dptr,ffname));
}

/***********************************************************************/
sds_handle
sds_back(dptr,ffname)
char    *ffname;
struct direc *dptr;
/***********************************************************************/
{
  unsigned long     nbytes;
  int  fd;
  char   *sdptr;
     
  nbytes = sds_sz(dptr);
  sdptr = (char *)dptr - dptr[0].offst;
  if ((fd = sds_open_file(ffname, O_WRONLY | O_CREAT, 0666)) == -1) 
  {
    return(sds_error = SDS_FILE_OP);
  }
  sds_write_data(fd,sdptr,(int)nbytes);
  close(fd);
  return(0);
}
/*********************************************************************/
sds_handle
bad_sds_header(sdsh)
struct sds_header *sdsh;
/*********************************************************************/
{
  if (sdsh->magic_number != SDS_MAGIC) 
  {
    if ((sdsh->magic_number & 0xffff00ff) == SDS_BASE_MAGIC)
    {
      return(SDS_WRONG_PADS);
    }
    else
    {
      if ((sdsh->magic_number  & 0xff00ffff) == SDS_MAGIC_BYTESWAP)
      {
        return(SDS_SWAPPED_BYTES);
      }
    return(SDS_NOT_SDS);
    }
  }
  if ((sdsh->version & 0xffff) != (SDS_VERSION & 0xffff)) 
  {
    return(sds_error = SDS_BAD_VERSION);
  }
  return(0); 
}
/*********************************************************************/
unsigned long
tlist_size(tlist)
struct type_list *tlist;
/*********************************************************************/
{
  
  unsigned long list_size = (unsigned long)0;
  if (tlist == TNULL) return(list_size);
  while((tlist++)->elemcod != SDS_ENDLIST) 
  {
    list_size++;
  }
  list_size++;
  return list_size*(unsigned long)sizeof(struct type_list);
}
/*********************************************************************/
struct direc*
header_to_direc(sds_header)
struct sds_header* sds_header;
/*********************************************************************/
{
  char *cptr = (char *)sds_header;
  return((struct direc *)(cptr + (int)sds_header->list_size + 
    (int)sds_header->heap_size + BASE_OFFSET));
}
/*********************************************************************/
void
sds_perror(comment)
char *comment;
/*********************************************************************/
{
  if (sds_error) 
    fprintf(stderr,"%s:%s\n",comment,sds_error_string[-sds_error]);
  else
    fprintf(stderr,"%s\n",comment);
  perror("From system");
}
/***********************************************************************/
int
sds_praw_directory(sds)
sds_handle  sds;
/***********************************************************************/
{
  struct  sds_odesc  *thing;
  int  indent,ts = -1,hs;
  struct direc *dptr = sds_direc_ptr(sds);
  unsigned long  i,nobj = dptr[0].nelems;
  char  *cptr,*type_ptr;
  struct  type_list  *tptr;


  hs = (int)get_heap_size(sds);
  if (get_header(sds) != NULL) 
  {
    ts = (int)(get_header(sds)->list_size);
    printf("\
      magic 0x%lx\n\
      version 0x%lx\n\
      tlist size %d bytes\n\
      heap size %d bytes\n",
      get_header(sds)->magic_number,
      get_header(sds)->version,
      ts,
      hs);
  }
  else
    printf("Not assembled: no header\n");
  tptr = get_tlist(sds);
  if ((tptr != TNULL) && (ts != 0))
  {
    int i = 0;
    while (tptr->elemcod != SDS_ENDLIST) 
    {
      printf("%x: %lx code %lx\n",i,tptr->nelems,tptr->elemcod);
      tptr++;
      i++;
    }
  }
  else
    printf("NULL tlist\n");
  printf("***********************\n");
  cptr = get_heap(sds);
  if (cptr != NULL)
    sds_printit(SDS_BYTE,(long)hs,cptr);
  else
    printf("NULL heap\n");
  printf("***********************\n");
  for (i=0;i<nobj;i++) 
  {
    printf("****************\n\
      name offset %ld\n\
      data offset 0x%lx \n\
      timestamp 0x%lx \n\
      code 0x%lx \n\
      number of elements %ld \n\
      size of element %ld \n\
      reallocation flag %x \n\
      structure type %x \n\
      align %d\n",
        dptr[i].obj_name,
        dptr[i].offst,
        dptr[i].wtime,
        dptr[i].elemcod,
        dptr[i].nelems,
        dptr[i].elemsz,
        (int)dptr[i].illoca & 0xff,
        (int)dptr[i].structype,
        (int)dptr[i].align_type & 0xff);
    if (SDS_INDLIST & dptr[i].elemcod) 
    {

      while ((indent = sds_describe(sds,i,&thing)) >= 0) 
      {
        if (thing[indent].elemcod & SDS_INDLIST)
          type_ptr = type_name[0];
        else
          type_ptr = type_name[thing[indent].elemcod];
        pindent(indent);
        printf("%s %ld (%lx %lx %x)\n",
          thing[indent].name,
          thing[indent].nelems,  
          thing[indent].address,  
          thing[indent].size,
          (int)(thing[indent].align & 0xff));
      }
    }
  }
  return(1);
}

/***********************************************************************/
sds_handle 
sds_list(sds_index,object_index,flag)
sds_handle sds_index;
sds_code   object_index,flag;
/***********************************************************************/
{

  int      indent,ik;
  struct  sds_odesc  *thing;
  static  int    depth = -1;
  unsigned long     i,nobj;
  char      inbuf[80],opbuff[128];
  char  *nptr,*cptr,*type_ptr;
  struct direc   *dptr = sds_direc_ptr(sds_index);

  depth++;
  *inbuf = (char)0;
  for (i=0;i<depth;i++) strcat(inbuf,"   ");

  if (object_index >= dptr[0].nelems) 
    return (sds_error = SDS_NO_SUCH_OBJ);

  if (object_index == (unsigned long)0) 
  {
  /*  Print out the directory description  */
    if (flag & SDS_LIST_RAW) 
    {
      sds_praw_directory(sds_index);
      return(0);
    }

    nobj = dptr[0].nelems;
    sprintf(opbuff," dataset '%s' %ld user objects created %s",
      sds_obind2name(sds_index,(sds_code)0),
      dptr[0].nelems-(unsigned long)1,  
      ctime((time_t *)&dptr[0].wtime));
    printf("%s",inbuf);
    for (i=0;i<(int)strlen(opbuff);i++) printf("-");
    printf("\n");
    printf("%s%s%s",inbuf,opbuff,inbuf);
    printf("- Sds version %3.2f ",sds_version(sds_index));
    for (i=0;i<(int)strlen(opbuff)- 19;i++) printf("-");
    printf("\n");

    for (i=1;i<nobj;i++) 
    {
    if ((SDS_INDLIST & dptr[i].elemcod) || (dptr[i].elemcod < NTYPES)) 
    {
      while ((indent = sds_describe(sds_index,i,&thing)) >= 0) 
      {
        if (thing[indent].elemcod & SDS_INDLIST)
          type_ptr = type_name[0];
        else
          type_ptr = type_name[thing[indent].elemcod];
        pindent(indent+depth);
        nptr = thing[indent].name;
        printf("%s %s",
          nptr,
          type_ptr);
        if (thing[indent].nelems != (unsigned long)1)
        {
          printf("[%ld]\n",(unsigned)thing[indent].nelems);  
          if (thing[indent].nnames == thing[indent].nelems) 
          {
            for (ik=1;ik<thing[indent].nnames;ik++) 
            {
              nptr += (int)strlen(nptr) +1;
              pindent(indent+depth);
              printf("%s\n",nptr);
            }
          }
        }
        else
          printf("\n");
      }
    }
    else 
      if (dptr[i].elemcod == SDS_SDS) 
        cptr = sds_getp(dptr,i);

    else 
      printf("%s%ld :'%s' %ld structure(s) \n",
        inbuf,
             i,
        sds_obind2name(sds_index,(long)i),
        dptr[i].nelems);
    }
  }
  else 
  {
  /*  Print the data object    */
    cptr = sds_getp(dptr,object_index);
		if (cptr == NULL)
			printf("Object template only - no data\n");
    else if (flag & SDS_LIST_RAW) 
      sds_printit(SDS_BYTE,
        dptr[object_index].nelems*dptr[object_index].elemsz,cptr);
    
    else 
    {
      while ((indent = 
        sds_resolve(sds_index,object_index,&thing,SDS_OBJECT)) >= 0) 
        {
        if (flag & SDS_LIST_HEADERS)
          printf("%s %ld %s\n",
            thing[indent].name,
            thing[indent].nelems,
            type_name[(int)thing[indent].elemcod]);
        sds_printit(thing[indent].elemcod,
          thing[indent].nelems,
          thing[indent].address);
      }
    }
  }
  depth--;
  return(0);
}
/***********************************************************************/
void
sds_printit(type_code,total_size,object_pointer)
sds_code type_code,total_size;
char  *object_pointer;
/***********************************************************************/
{

  sds_code    i,k;
  int         kmax,cline;
  char        *bptr;
  long        *iiptr;
  float       *fptr;
  double      *ffptr;
  short       *sptr;

  switch((int)type_code) 
  {
    case  SDS_WORD :
    case  SDS_UNS_WORD :
        cline = 16;
               sptr = (short *)object_pointer;
        for (i = (unsigned long)0;i<total_size;i+=(unsigned long)cline)
        {
          kmax = (total_size-i)>cline?cline:(int)(total_size-i);
          for (k=0;k<kmax;k++) 
            printf("%d ",(int)*(sptr+k));
          sptr+=kmax;
          printf("\n");
        }
        break;
    case  SDS_POINTER:
    case    SDS_LONG  :
    case    SDS_UNS_LONG  :
        cline = 16;
               iiptr = (long *)object_pointer;
        for (i = 0;i<total_size;i+=cline)
        {
          kmax = (total_size-i)>cline?cline:(total_size-i);
          for (k=0;k<kmax;k++) 
            printf("%ld ",*(iiptr+k));
          iiptr+=kmax;
          printf("\n");
        }
        break;
    case    SDS_TIME  :
               iiptr = (long *)object_pointer;
        for (i = 0;i<total_size;i++)
        {
          printf("%lx :",(unsigned)*iiptr++);
          printf(" %lx",(unsigned)*iiptr++);
          printf("\n");
        }
        break;
    case    SDS_FLOAT :
        cline = 8;
               fptr = (float *)object_pointer;
        for (i = 0;i<total_size;i+=cline)
        {
          kmax = (total_size-i)>cline?cline:(total_size-i);
          for (k=0;k<kmax;k++) 
            printf("%e ",*(fptr+k));
          fptr+=kmax;
          printf("\n");
        }
        break;
    case    SDS_DOUBLE:
        cline = 8;
               ffptr = (double *)object_pointer;
        for (i = 0;i<total_size;i+=cline)
        {
          kmax = (total_size-i)>cline?cline:(total_size-i);
          for (k=0;k<kmax;k++) 
            printf("%e ",*(ffptr+k));
          ffptr+=kmax;
          printf("\n");
        }
        break;
    case   SDS_PADB  :
        printf("%ld pad bytes\n",(long)total_size);
        break;
    case  SDS_BYTE  :
        cline = 16;
               bptr = (char *)object_pointer;
        for (i = 0;i<total_size;i+=cline)
        {
          kmax = (total_size-i)>cline?cline:(total_size-i);
          printf("\n%5x| ",(unsigned int)i);
          for (k=0;k<kmax;k++) 
            printf("%2x ",((unsigned int)*(bptr+k) & 0xff));
          for (k=0;k<cline-kmax;k++)
            printf("   ");
          printf("|");
          for (k=0;k<kmax;k++) 
            if (isprint((int)*(bptr+k))) 
                printf("%c",*(bptr+k));
            else printf(".");
          bptr+=kmax;
        }
        printf("\n");
        break;
    case  SDS_STRING  :
    case  SDS_FSTRING  :
        kmax = total_size;
        for (k=0;k<kmax;k++) 
          if (isprint((int)*(object_pointer+k))) 
              printf("%c",*(object_pointer+k));
          else printf(".");
        printf("\n");
        break;
    case  SDS_SDS:
        break;
    default       :
      printf("element type %lx unprintable\n",type_code);
      break;
  }
}
/***********************************************************************/
int
align_delta(address,alignment_size)
int  address;
char  alignment_size;
/***********************************************************************/
{
  int  i,j;
  unsigned int  ad = (unsigned int)address;
  
  if (!alignment_size)
    return(0);
  j = (int)(alignment_size & 0xff);
  i=ad%j;
  i = (i == 0)?0:j-i;
  return(i);
}
/***********************************************************************/
void
pindent(n)
int  n;
/***********************************************************************/
{
  int  i;
  for (i=0;i<n;i++)
    printf("   ");
}

/***********************************************************************/
sds_handle 
sds_set_object_type(sds_index, object_index,structure_flag)
sds_handle sds_index,object_index;
int structure_flag;
/***********************************************************************/
{
  struct direc   *dptr = sds_direc_ptr(sds_index);
  if (dptr == DNULL)
    return SDS_NO_SUCH_SDS;
  if ((object_index < 0) ||
      (object_index >= dptr[0].nelems))
    return SDS_NO_SUCH_OBJ;
  dptr[object_index].structype = structure_flag;
}

/***********************************************************************/
sds_handle 
sds_get_object_type(sds_index,object_index)
sds_handle sds_index,object_index;
/***********************************************************************/
{
  struct direc   *dptr = sds_direc_ptr(sds_index);
  if (dptr == DNULL)
    return SDS_NO_SUCH_SDS;
  if ((object_index < 0) ||
      (object_index >= dptr[0].nelems))
    return SDS_NO_SUCH_OBJ;
  return dptr[object_index].structype;
}

/***********************************************************************/
sds_handle 
sds_set_object_location(sds_index, object_index,location_flag)
sds_handle sds_index,object_index;
int location_flag;
/***********************************************************************/
{
  struct direc   *dptr = sds_direc_ptr(sds_index);
  if (dptr == DNULL)
    return SDS_NO_SUCH_SDS;
  if ((object_index < 1) ||
      (object_index >= dptr[0].nelems))
    return SDS_NO_SUCH_OBJ;
  dptr[object_index].illoca = location_flag;
		return 0;
}

/***********************************************************************/
sds_handle
sds_mark_disjoint(sds,object)
sds_handle sds;
sds_handle object;
/***********************************************************************/
{ return sds_set_object_location(sds,object,SDS_DISJOINT_OBJECT); }
