#include "Sds/sdsgen.h"
#include "Sds/sds_externs.h"
#include "malloc.h"

extern int sds_is_init;
extern int sds_error;
extern int *dup_sizes[];
extern char *heap[];

sds_handle sds_type_duplicate_def();

/*********************************************************************/
sds_handle
sds_duplicate_object(new_sds,old_sds,object)
sds_handle  new_sds,old_sds,object;
/*********************************************************************/
{
  struct  direc  *dptr,*old_dptr;
  sds_code typecode;
  sds_code newtypecode;
	sds_handle newobject;

  if (sds_is_init == 0) return(SDS_NOT_INITIALISED);

  if ((old_dptr = sds_direc_ptr(old_sds)) == DNULL ||
      (dptr = sds_direc_ptr(new_sds)) == DNULL)
    return(SDS_NO_SUCH_SDS);

  if (object == 0 || object > old_dptr[0].nelems)
    return(SDS_NO_SUCH_OBJ);

  if (dup_sizes[new_sds] == INULL)
   dup_sizes[new_sds] = (int *)malloc((dptr[0].nelems + 1) * sizeof(int));
  else
   dup_sizes[new_sds] = (int *)realloc((char *)dup_sizes[new_sds],
																(dptr[0].nelems + 1) * sizeof(int));

  if (dup_sizes[new_sds] == (char)0 )
  {
    sds_perror("malloc failure, sds_duplicate");
    exit(1);
  }
  sds_cleanup();
  if ((typecode = old_dptr[object].elemcod) & SDS_INDLIST)
	{
    newtypecode = sds_type_duplicate_def(old_sds,new_sds,typecode);
		typecode = newtypecode;
	}

  newobject = sds_declare_object(new_sds, 
    sds_obind2ptr(old_sds,object),
    sds_obind2name(old_sds,object),
    old_dptr[object].nelems,
    typecode);

  dup_sizes[new_sds][newobject] = old_dptr[object].nelems;

   dptr[newobject].structype = old_dptr[object].structype;  
   if (old_dptr[object].illoca == SDS_DISJOINT_OBJECT)
     dptr[newobject].illoca = SDS_DISJOINT_OBJECT;  
    
  return newobject;
}
/*********************************************************************/
sds_handle
sds_type_duplicate_def(source_sds_index,new_sds_index,typecode)
sds_handle  source_sds_index,new_sds_index;
sds_code typecode;
/*********************************************************************/
{
  struct   direc    *dptr = sds_direc_ptr(source_sds_index);
  char              *temp,*name_source,*namelist;
  struct  type_list *tlist_source,*tlist;
  int                nnames;
  int                tlist_counter = 1;
  int                name_counter = 0;
  int                char_counter = 0;
  int                counter;
  sds_code           tc;

  if (typecode < (long)NTYPES) /* It's a primitive */
    return typecode;
  tlist_source = get_tlist(source_sds_index);
  if (tlist_source == NULL)
    return (sds_error = SDS_NO_SUCH_OBJ);
  tlist_source += typecode & ~SDS_CODE_MASK;
  temp = 
  name_source = heap[source_sds_index] + (tlist_source[0].nelems & 0xffff);
  nnames = tlist_source[0].nelems >> 16;

  while (name_counter++ < nnames)
    while (name_source[char_counter++] != (char)0);

  namelist = malloc(char_counter);

  if (namelist == (char)0 )
  {
    sds_perror("malloc failure, sds_transfer_object");
    exit(1);
  }

  for (counter = 0;counter < char_counter; counter++)
  {
    namelist[counter] = temp[counter];
    if (namelist[counter] == (char)0)
      namelist[counter] = ',';
  }

  while (~tlist_source[tlist_counter++].elemcod & SDS_RETLIST);
  tlist_counter--;

  tlist = (struct type_list *)malloc(tlist_counter * sizeof(struct type_list));
  if (tlist == (char)0 )
  {
    sds_perror("malloc failure, sds_transfer_object 2");
    exit(1);
  }
  tlist_source += 2;
  memcpy((char *)tlist,(char *)tlist_source,
      (tlist_counter - 1) * sizeof(struct type_list));
  tlist[tlist_counter - 1].elemcod = SDS_ENDLIST;
  tlist[tlist_counter - 1].nelems = 0;

  counter=0;
  while (!((tc = tlist[counter].elemcod) & SDS_RETLIST))
  {
    if (tc & SDS_INDLIST )
      tlist[counter].elemcod = 
            sds_type_duplicate_def(source_sds_index,new_sds_index,tc);
    counter++;
  }

  typecode = sds_define_object(new_sds_index,tlist,namelist);

  free(namelist);
  free((char *)tlist);

  return typecode;
}
