/* $Header: sds_ftypes.c,v 1.4 92/08/04 15:06:21 salty Exp $ */

/**************************************************************************
 *                 ****** ISTK Release 1.2 *****                          *
 *                                                                        *
 *                                                                        *
 * This code has been produced by numerous authors at the CERN centre for *
 * high energy physics, Geneve, Switzerland, at the SSC laboratory in     *
 * Dallas, Texas, USA and at the Lawrence Berekeley Laboratory in         *
 * California, USA.                                                       *
 * The latter two institutions perform work under US Government contract. *
 * The intent of the work is to provide useful code for people who need   *
 * it, with an emphasis on free and collaborative exchange of ideas,      *
 * techniques and implementations.                                        *
 * Please read the disclaimer and copyright notices contained in the ISTK *
 * distribution and in distributed applications.                          *
 *                                                                        *
 **************************************************************************/


/* Reference release  Aug 10 1991 - C G Saltmarsh */
/* Has the basics used at CDG & SSC 1988-1991, plus vxworks
   support
*/


#if defined(vms)
#include "sdsgen.h"
#include "sds_externs.h"
#include "ltypes.h"
#else
#include "Sds/sdsgen.h"
#include "Sds/sds_externs.h"
#include "Sds/ltypes.h"
#endif

/*  Here is stored code to allow Fortran to load some
  special types - multi-dimensioned arrays - into
  SDS.
*/
/*********************************************************************/
sds_handle
sds_twod_declare(sds_index,obj_ptr,name,n1,n2,code)
sds_handle  sds_index;
void  *obj_ptr;
char  *name;
sds_code  code;
long   n1,n2;
/*********************************************************************/
{

  twod_type_list[0].nelems = (unsigned long)n2;
  twod_type_list[0].elemcod = (unsigned long)code;
  return(sds_declare_object(sds_index,obj_ptr,name,n1,
    sds_define_object(sds_index,twod_type_list, "dim1,dim2")));
}
/*********************************************************************/
sds_handle
sds_threed_declare(sds_index,obj_ptr,name,n1,n2,n3,code)
sds_handle  sds_index;
void  *obj_ptr;
char  *name;
sds_code  code;
long   n1,n2,n3;
/*********************************************************************/
{

  unsigned long  two_code;

  twod_type_list[0].nelems = (unsigned long)n3;
  twod_type_list[0].elemcod = (unsigned long)code;
  two_code = sds_define_object(sds_index,twod_type_list, "dim1,dim2");
  twod_type_list[0].nelems = (unsigned long)n2;
  twod_type_list[0].elemcod = (unsigned long)two_code;

  return(sds_declare_object(sds_index,obj_ptr,name,n1,
    sds_define_object(sds_index,twod_type_list, "dim2,dim3")));
}
