/* $Header: sds_lin.c,v 1.5 92/08/06 09:47:27 salty Exp $ */

/**************************************************************************
 *                 ****** ISTK Release 1.2 *****                          *
 *                                                                        *
 *                                                                        *
 * This code has been produced by numerous authors at the CERN centre for *
 * high energy physics, Geneve, Switzerland, at the SSC laboratory in     *
 * Dallas, Texas, USA and at the Lawrence Berekeley Laboratory in         *
 * California, USA.                                                       *
 * The latter two institutions perform work under US Government contract. *
 * The intent of the work is to provide useful code for people who need   *
 * it, with an emphasis on free and collaborative exchange of ideas,      *
 * techniques and implementations.                                        *
 * Please read the disclaimer and copyright notices contained in the ISTK *
 * distribution and in distributed applications.                          *
 *                                                                        *
 **************************************************************************/


/* Reference release  Aug 10 1991 - C G Saltmarsh */
/* Has the basics used at CDG & SSC 1988-1991, plus vxworks
   support
*/

#include <string.h>
#include <stdlib.h>

#ifndef vms
#include <unistd.h>
#include <memory.h>
#endif

#if defined(vms)
#include "sdsgen.h"
#include "sds_externs.h"
#else
#include "Sds/sdsgen.h"
#include "Sds/sds_externs.h"
#endif

extern  int  sds_error;
extern  int  serial_stream[];
extern  char  sds_rbytes[];


static  sds_handle  flat_sds = -1,flat_obj = -1;
static  int  template_count;
static  int  bumpy_struct_size;
static char  *bump_buffer = (char *)0;

static struct template {
  sds_code        elemcod;
  char           *address;
  sds_code        size;
  char           *target;
  } template[64];

/********** forward declarations ***********/
sds_handle sds_flat_setup();
sds_handle sds_flat_setup();
void       flat_cleanup();
int        make_template();

/*********************************************************************/
sds_handle
sds_flat_setup(sds_index,object_index,subelem,type,pointer)
sds_handle  sds_index;
sds_code    object_index,*type;
int         subelem;
void        *pointer;
/*********************************************************************/
{
  struct  direc  *dptr = sds_direc_ptr(sds_index);

  if (dptr == DNULL)
    return(sds_error = SDS_NO_SUCH_SDS);
  if (flat_sds == -1) 
  {
    if (!make_template(sds_index,object_index)) 
    {
      flat_cleanup();
      return(sds_error = SDS_NO_SUCH_OBJ);
    }
    flat_sds = sds_index;
    flat_obj = object_index;
  }
  if (flat_sds != sds_index) 
  {
    flat_cleanup();
    return(sds_error = SDS_NO_SUCH_SDS);
  }
  if ((subelem > template_count) || (subelem < 0)) 
  {
    return(sds_error = SDS_NO_SUCH_OBJ);
  }

  template[subelem].target = pointer;
  *type = (int)template[subelem].elemcod;
  return(0);
}
/*********************************************************************/
void
flat_cleanup()
/*********************************************************************/
{
  flat_sds = -1;
  if (bump_buffer != (char *)0)
    free(bump_buffer);
  bump_buffer = (char *)0;
}
/*********************************************************************/
sds_handle 
sds_flat_read(sds_index,object_index,max)
sds_handle  sds_index;
sds_code    object_index;
unsigned long  max;
/*********************************************************************/
{
  unsigned long  rec,i,j,copy_size,offset;
  unsigned long  total_size;
  struct  sds_header  *head;
  struct direc *dptr = sds_direc_ptr(sds_index);
  int  fd = serial_stream[sds_index];
  int  rbytes;


  if (fd < 0)
    return(sds_error = SDS_FILE_NOP);

  if (dptr == DNULL)
    return(sds_error = SDS_NO_SUCH_SDS);
  
  if (object_index != flat_obj)
    return(sds_error = SDS_NO_SUCH_OBJ);


  head = get_header(sds_index);
  offset = BASE_OFFSET + head->list_size + head->heap_size;
  for (i=0;i<object_index;i++) 
  {
    offset += dptr[i].nelems*dptr[i].elemsz;
    offset += align_delta((int)offset,RBYTE);
  }

  total_size = dptr[object_index].nelems*dptr[object_index].elemsz;  

/* Don't try to copy more than max objects (else potential bang)   */
  if (max > dptr[object_index].nelems) max = dptr[object_index].nelems;

/*  In bytes.....            */
  copy_size = dptr[object_index].elemsz;

  if (lseek(fd,offset,L_SET) < 0) 
  {
    printf("lseek failure");
    perror("ach!");
    exit(1);
  }
  for (rec = 0;rec<max;rec++) 
  {
    rbytes = sds_read_data(fd,bump_buffer,bumpy_struct_size);
    for (j=0;j<template_count;j++) 
      if (template[j].target  != (char *)0) 
      {
        memcpy(template[j].target,
          template[j].address,
          template[j].size);
        template[j].target += template[j].size;
      }
  }

  return(rec);
}
/*********************************************************************/
int
make_template(sds,obj)
sds_handle  sds,obj;
/*********************************************************************/
{

  int  level,ok = 1,start = 0;
  struct  sds_odesc  *thing;
  char  *base_addr = 0;

  template_count = 0;
  while ((level = sds_describe(sds,obj,&thing)) >= 0) 
  {
    if (!(thing[level].elemcod & SDS_INDLIST) && !start) 
    {
      start = level;
      bumpy_struct_size = thing[level-1].size;
      bump_buffer = malloc(bumpy_struct_size);
      base_addr = thing[level].address;
    }
    if (start == level) 
    {
      if ((thing[level].elemcod & SDS_INDLIST)) 
      {
        ok = 0;
      }
      template[template_count].elemcod = thing[level].elemcod;
      template[template_count].address =
        thing[level].address -
        base_addr +
        bump_buffer;
      template[template_count].target = (char *)0;
      template[template_count].size  = (int)thing[level].size;
      template_count++;
    }
  }    
  return(ok);
}
