/* $Header: sds_load.c,v 1.6 92/09/29 16:08:23 matt Exp $ */



#if ! defined(vms) && ! defined (__GCC_2__)
#include <stddef.h>
#include <memory.h>
#endif

#include "Sds/sdsgen.h"
#include "Sds/sds_externs.h"

#ifdef  VMS
#define BLOCKING_FACTOR 512
#else
#define BLOCKING_FACTOR 8192
#endif

extern int      sds_error;
extern int      load_source[];
extern struct type_list tlist[];

sds_handle sds_bread();

/*********************************************************************/
sds_handle
sds_dataset_size(sds)
sds_handle sds;
/*********************************************************************/
{
  struct direc *dptr;

  sds_error = 0;
  if ((dptr = sds_direc_ptr(sds)) == DNULL)
    return(sds_error = SDS_NO_SUCH_SDS);
  else
		return sds_sz(dptr);
}
/***********************************************************************/
unsigned long
sds_data_sz(dptr)
struct direc *dptr;
/***********************************************************************/
{
  unsigned long size = sds_sz(dptr);
  if (size > (unsigned long)0) 
  {
    size -= dptr[1].offst;
  }
  return(size);
}

/*********************************************************************/
unsigned long
sds_sz(dptr)
struct direc *dptr;
/*********************************************************************/
{
  int size, i;
  sds_handle sds = sds_which(dptr);

  size =  (unsigned long )(tlist_size(get_tlist(sds)) + get_heap_size(sds));
  size += BASE_OFFSET;

  for ( i = 0; i<dptr[0].nelems ; i++ )
  {
    size += align_delta((int)size,dptr[i].align_type);
    size += dptr[i].nelems*dptr[i].elemsz;
  }
  return size;
}

/*********************************************************************/
sds_handle
sds_load_fd(fd, nbytes, blocking_size)
int fd;
unsigned long nbytes;
int blocking_size;
/*********************************************************************/
{
  char *sdptr;
  struct sds_header *sdsh;
  struct direc *dptr;
  sds_handle sds;
  int obj;

  if ((sds = next_sds()) < 0)
    return(sds_error = sds);

  sdptr = (char *)malloc((unsigned int)nbytes);

  if (sdptr == (char ) 0)
  {
     sds_perror("malloc failure, load_sds_file");
     exit(1);
  }
  if (sds_bread(fd,sdptr,(int)nbytes, blocking_size) != nbytes)
  {
     free(sdptr);
     return sds_error = SDS_FILE_RD;
  }
  sdsh = (struct sds_header*)sdptr;
  dptr = (struct direc *)
          (sdptr + BASE_OFFSET + (int)sdsh->list_size + (int)sdsh->heap_size);

  if (dptr == DNULL)
    return sds_error;
  set_sys_vars(sds,dptr);
  load_source[(int)sds] = SDS_FILE;
  for (obj = 0;obj < dptr[0].nelems; obj++)
    dptr[obj].illoca = (char) 0;
  return(sds);

}

/*********************************************************************/
sds_handle
sds_bread(fd,sdptr,number, block)
int  fd,number, block;
char *sdptr;
/*********************************************************************/
{
  int    nb;
  int    tot_nb = 0;
  char    *tdptr = sdptr;
  int  tries = 0;
  int  remainder;

  remainder = number;

  while (remainder > block ) 
  {

    if ((nb = sds_read_data(fd,tdptr,block)) < 0)
      return(sds_error = SDS_FILE_RD);

/* But reading 0 means I've come to the end without error  */
    if (nb == 0)
      tries++;
    else 
    {
      tries = 0;
      tdptr += nb;
      remainder -= nb;
      tot_nb += nb;
    }
    if (tries == 2) 
    {
      printf("dammit,I believe the size is wrong!\n");
      tot_nb += number;
      break;
    }
  }
  if (remainder) 
  {
    if ((nb = sds_read_data(fd,tdptr,remainder)) < 0)
      return(sds_error = SDS_FILE_RD);
    tot_nb += nb;
  }
  return(tot_nb);
}
/*********************************************************************/
sds_handle
sds_vread(fd,sdptr,number)
int  fd,number;
char *sdptr;
/*********************************************************************/
{
  return sds_bread(fd,sdptr,number, BLOCKING_FACTOR);
}
