/* $Header: sds_res.c,v 1.9 93/01/13 12:42:39 salty Exp $ */

/**************************************************************************
 *                 ****** ISTK Release 1.2 *****                          *
 *                                                                        *
 *                                                                        *
 * This code has been produced by numerous authors at the CERN centre for *
 * high energy physics, Geneve, Switzerland, at the SSC laboratory in     *
 * Dallas, Texas, USA and at the Lawrence Berekeley Laboratory in         *
 * California, USA.                                                       *
 * The latter two institutions perform work under US Government contract. *
 * The intent of the work is to provide useful code for people who need   *
 * it, with an emphasis on free and collaborative exchange of ideas,      *
 * techniques and implementations.                                        *
 * Please read the disclaimer and copyright notices contained in the ISTK *
 * distribution and in distributed applications.                          *
 *                                                                        *
 **************************************************************************/


/* Reference release  Aug 10 1991 - C G Saltmarsh */
/* Has the basics used at CDG & SSC 1988-1991, plus vxworks
   support
*/

#include <string.h>
#include <stdlib.h>

#ifndef vms
#include <unistd.h>
#include <memory.h>
#endif

#if defined(vms)
#include "sdsgen.h"
#include "sds_externs.h"
#include "dtypes.h"
#else
#include "Sds/sdsgen.h"
#include "Sds/sds_externs.h"
#include "Sds/dtypes.h"
#endif

#define    STACK_INC  16
#define    SDS_READY  -1
#define    SDS_VIRTUAL  -2

#define ALL_ELEMENTS 1
#define ONE_ELEMENT 2


extern int               sds_error;
extern char              sds_sizes[];
extern struct type_list *get_tlist();
extern char             *get_heap();

/****** forward declarations *******/
void       sds_prev_object();
void       sds_next_object();
sds_handle sds_vdescribe();
sds_handle sds_vresolve();
void       sds_cleanup();
int        sds_nextname();
void       sds_fix_align();
sds_handle sds_res_init();
sds_handle sds_find_thing();


/***********************************************************************/
static struct  sds_res_control {
  int                 stack_size;
  int                 addr_inc;
  int                 thiso;
  struct  sds_odesc  *start_stack;
  struct  sds_odesc  *this;
  struct  sds_odesc  *parent;
  int                 sds_used;
  struct  type_list  *tptr;
  struct  type_list   tdum[2];
  char               *nheap;
  char               *sds_al;
  long                base_address;
	int                 next_return_goes_up;
  } sres_cont[2];

static struct  sds_res_control  *c = &sres_cont[0];
static char    rnull = (char)0;
static int     malt = 0;
static int     ended_describe  = 0;

/***********************************************************************/
void
sds_rinit()
/***********************************************************************/
{
  sds_alt_resolution_stack();
  sds_cleanup();
  sds_main_resolution_stack();
  sds_cleanup();
}
/***********************************************************************/
void
sds_alt_resolution_stack() { c = &sres_cont[1];malt = 1; }
/***********************************************************************/
void
sds_main_resolution_stack() { c = &sres_cont[0];malt = 0; }
/***********************************************************************/

/***********************************************************************/
void
sds_cleanup()
/***********************************************************************/
{

  if (c->stack_size) 
  {
    free((char *)c->start_stack);
  }
  c->sds_used = SDS_READY;
  c->stack_size = 0;
  ended_describe = 1;
}
/***********************************************************************/
int
sds_describe(sds_index,object_index,thing_list)
sds_handle  sds_index;
sds_code  object_index;
struct   sds_odesc  **thing_list;
/***********************************************************************/
{

  long             *header = (long *)get_header(sds_index);
  struct direc     *dptr = sds_direc_ptr(sds_index);
  char             *heap = get_heap(sds_index);
  char             *name = sds_obind2name(sds_index,0);
  struct type_list *tptr = get_tlist(sds_index);

  return sds_vdescribe(sds_index,header,
             dptr,heap,name,tptr,object_index,thing_list);
}
/***********************************************************************/
sds_handle
sds_vdescribe(sds,header,dptr,heap,name,tptr,object,thing_list)
sds_handle            sds;
sds_code              object;
unsigned  long       *header;
struct   sds_odesc  **thing_list;
struct direc         *dptr;
char                 *heap;
char                 *name;
struct type_list     *tptr;
/***********************************************************************/
{

  int          ind;
  static  int  firstpass = 1;
  char        *temp_addr;

  if (ended_describe == 1) 
  {
    ended_describe = 0;
    firstpass = 1;
  }

  if (c->sds_used == SDS_READY)
  {
    if (((sds_error = sds_res_init(sds,header,dptr,heap,
                name,tptr,object,SDS_OBJECT)) < 0) &&
        (sds_error != SDS_ZERO_LENGTH)) 
    {
      c->sds_used = SDS_READY;
      firstpass = 1;
      return(sds_error);
    }
    else if (sds != c->sds_used) 
    {
      firstpass = 1;
      c->sds_used = SDS_READY;
      return(sds_error = SDS_WRONG_RES_LIST);
    }
    c->base_address = (long)c->this->address;
  }

  while (1) 
  {
    while ((c->tptr[c->this->ind].elemcod & SDS_RETLIST)) 
    {
      sds_prev_object(ALL_ELEMENTS);
      if (c->this == c->start_stack) 
      {
        c->sds_used = SDS_READY;
        firstpass = 1;
        return(SDS_END_RES_STACK);
      }
    }
    if (firstpass) 
    {
      firstpass = 0;
    } 
    else 
    {
      c->this->elemcod = c->tptr[c->this->ind].elemcod;
      c->this->nelems = c->tptr[c->this->ind].nelems;
    }

    ind = c->this->elemcod & ~SDS_CODE_MASK;
    if (c->this->elemcod & SDS_INDLIST)
    {
      if (c->tptr[ind].elemcod & SDS_LENLIST) 
      {
        c->this->namelist = &rnull;
        c->this->maxn = c->tptr[ind].nelems >> 16;
        if (c->this->maxn)
          c->this->namelist =
                 (c->nheap + (c->tptr[ind].nelems & 0xffff));
        ind++;
      }
      if (c->tptr[ind].elemcod & SDS_SIZE_ALIGN) 
      {
        c->this->size = c->tptr[ind].nelems;
        c->this->align = (char)(c->tptr[ind].elemcod & 0xff);
        ind++;
      }
      c->this->nnames =  (c->parent->maxn >= c->this->nelems)?
         (unsigned long)c->this->nelems:
          1;

      c->parent->maxn -= c->this->nnames;
      c->this->name = c->parent->namelist;
      if (c->this->nnames != (unsigned long)0)
        c->parent->namelist =
             sds_jstr(c->parent->namelist,c->this->nnames);
      c->this->address += c->addr_inc;
      c->this->address += align_delta(c->this->address - c->base_address,
                                      c->this->align);
      temp_addr = c->this->address;
      c->this->ind++;

      sds_next_object();
      c->this->address = temp_addr;
      c->addr_inc = 0;
      c->this->ind = ind;
      c->this->nelems = c->tptr[ind].nelems;
      c->this->elemcod = c->tptr[ind].elemcod;
      *thing_list = c->start_stack;
			c->next_return_goes_up = 1;
      return(c->thiso-1);
    }
    else 
    {
      ind = c->this->ind; 
      c->this->nelems = c->tptr[ind].nelems;
      if (((c->this->elemcod = c->tptr[ind].elemcod) >= SDS_RETLIST)) 
      {
      }
      else 
      {
        c->this->nnames =  (c->parent->maxn >= (unsigned long)1)?
                           (unsigned long)1:
                           (unsigned long)0;
        c->parent->maxn -= c->this->nnames;
        c->this->name = c->parent->namelist;
        if (c->this->nnames != (unsigned long)0)
           c->parent->namelist =
                 sds_jstr(c->parent->namelist,c->this->nnames);

        c->this->size = (long)(sds_sizes[c->this->elemcod] & 0xff);
        c->this->align = c->sds_al[c->this->elemcod] & 0xff;
        c->this->address += c->addr_inc;
        c->this->address += align_delta(c->this->address - c->base_address,
                                        c->this->align);

        *thing_list = c->start_stack;
        c->addr_inc = c->this->size * c->this->nelems;
        c->this->ind += 1;
			  c->next_return_goes_up = 0;
        return(c->thiso);
      }
    }
  }
}

int
sds_peek_endstruct() { return c->next_return_goes_up; };

/***********************************************************************/
char  *
sds_jstr(str,n)
char  *str;
unsigned long   n;
/***********************************************************************/
{

  unsigned long  j;
  if (n == (unsigned long)0) return(str);
  for (j=0;j<n;j++)
#if !defined(psos)
    str = strchr(str,0) + 1;
#else
    str = (char *)strchr(str,0) + 1;
#endif
  return(str);
}
/***********************************************************************/
void
sds_prev_object(flag)
int  flag;
/***********************************************************************/
{
  int number_to_inc = 1;

  c->this--;
  c->parent--;
  c->thiso--;

  if (flag == ALL_ELEMENTS)
    number_to_inc = c->this->nelems;

  if (!(c->this->elemcod & SDS_INDLIST))
    c->this->elemcod = c->tptr[c->this->ind].elemcod;

	if (c->this->elemcod & SDS_RETLIST)
	{
		c->addr_inc = 0;
	}
	else if (c->this != c->start_stack) 
  {
    c->addr_inc = c->this->size * number_to_inc;
    c->addr_inc += align_delta(c->addr_inc,c->this->align);
  }
}
/***********************************************************************/
void
sds_next_object()
/***********************************************************************/
{
  if (c->stack_size == 0) 
  {
    c->thiso = 0;
    c->stack_size = STACK_INC;
    c->this = c->start_stack = 
      (struct sds_odesc *)calloc((unsigned)c->stack_size,sizeof(struct sds_odesc)); 
    if (c->this == (char)0 )
    {
      sds_perror("malloc failure, sds_next_object");
      exit(1);
    }
  } 
  else 
  {
    c->thiso++;
    if (c->thiso == c->stack_size) 
    {
      c->stack_size += STACK_INC;
      c->start_stack = 
        (struct sds_odesc *)realloc((char *)c->start_stack,
          (unsigned)c->stack_size*sizeof(struct sds_odesc));
      if (c->this == (char)0 )
      {
        sds_perror("realloc failure, sds_next_object");
        exit(1);
      }
    }
  }
  c->this = &c->start_stack[c->thiso];
  if (c->thiso)
  {
    c->parent = &c->start_stack[c->thiso-1];
  } 
  else 
  {
    c->parent = c->this;
  }
}
/***********************************************************************/
sds_handle
sds_find_thing(sds_index,name,thing)
sds_handle  sds_index;
char  *name;
struct  sds_odesc  **thing;
/***********************************************************************/
{

  struct  sds_odesc  *thinglist;
  int  firstpass = 1,nocomp = 1,level,dlev;
  long  object = 0,nomen,addr_inc;
  char  *thingname,lname[32];

  lname[0] = (char)0;

  sds_rinit();

  sds_nextname(NULL,lname);
  sds_cleanup();
  while ((level = sds_nextname(name,lname))) 
  {
    if (firstpass) 
    {
      firstpass = 0;
      if ((object = sds_obname2ind(sds_index,lname)) < 0) 
      {
        return(sds_error = SDS_NO_SUCH_OBJ);
      }  
    }

    while ((dlev = sds_describe(sds_index,object,&thinglist)) == level) 
    {
      nocomp = 1;
      thingname = thinglist[dlev].name;
      for (nomen = (long)0;nomen < thinglist[dlev].nnames;nomen++) 
      {
        if (!(nocomp = strcmp(lname,thingname))) 
        {
          addr_inc = nomen*thinglist[dlev].size;
          addr_inc += align_delta(addr_inc,thinglist[dlev].align);
          thinglist[dlev].address += addr_inc;
          if (thinglist[dlev].elemcod &
            SDS_INDLIST)
            thinglist[dlev+1].address += addr_inc;
          thinglist[dlev].nelems -= nomen;
          break;
        }
        else 
#if !defined(psos)
          thingname = strchr(thingname,0) + 1;
#else
          thingname = (char *)strchr(thingname,0) + 1;
#endif
      }
    *thing = &thinglist[dlev];
    if (!nocomp) break;
    }  
    if (nocomp)
      return(sds_error = SDS_NO_SUCH_OBJ);
  }
	/*
  if (strcmp(name,lname)) 
    return(sds_error = SDS_NO_SUCH_OBJ);
		*/
  return(object);
}
/***********************************************************************/
int
sds_nextname(name,buffer)
char  *name,*buffer;
/***********************************************************************/
{

  static  char  *nptr = NULL,*cptr = NULL,*bptr = NULL;
  static  int  lev = 0,die = 0;

  if (die) 
  {
    die = 0;
    return(0);
  }
  if (nptr != name) 
  {
    lev = 0;
    nptr = bptr = cptr = name;
  }
  if (name == NULL)
    return(0);

#if !defined(psos)
  if ((cptr = strchr(cptr,'.')) != NULL) 
#else
  if ((cptr = (char *)strchr(cptr,'.')) != NULL) 
#endif
  {
    strncpy(buffer,bptr,(cptr-bptr));
    buffer[cptr-bptr] = (char)0;
    bptr = ++cptr;
  }
  else  
  {
    strcpy(buffer,bptr);
    nptr = NULL;
    die = 1;
  }
  return(++lev);
}
/***********************************************************************/
int
sds_make_name(name,thing_list,start_level,end_level)
char  *name;
struct  sds_odesc  *thing_list;
int  start_level,end_level;
/***********************************************************************/
{
  int  lev;

  if (start_level < 0) start_level = 0;
  if (end_level < 0) end_level = 0;
  if (start_level > end_level) start_level = end_level;
  *name = (char)0;
  for (lev=start_level;lev <= end_level;lev++) 
  {
    if ((thing_list[lev].name != NULL) &&
        (*thing_list[lev].name != (char)0)) 
        {
      strcat(name,thing_list[lev].name);
      strcat(name,".");
    }
  }
  *(strchr(name,0)-1) = (char)0;
  return((int)thing_list[lev].nnames);
}
/***********************************************************************/
sds_handle
sds_res_init(sds,header,dptr,heap,name,tptr,object,flag)
sds_handle         sds;
long              *header;
int                flag;
sds_code           object;
struct direc      *dptr;
char              *heap;
char              *name;
struct type_list  *tptr;
/***********************************************************************/
{

  int  retval = 0;

  if (dptr == DNULL)
    return(sds_error = SDS_NO_SUCH_SDS);
  sds_cleanup();
	c->next_return_goes_up = 0;
  c->sds_used = sds;
  c->addr_inc = 0;
  c->nheap = heap;
  c->tdum[1].elemcod = SDS_RETLIST;
  sds_fix_align(header);

  sds_next_object();
  c->this->nelems = (unsigned long)0;
  c->this->address   = (char *)0;
  c->this->name   = name;
  c->this->namelist   = &rnull;

  if (flag == SDS_OBJECT) 
  {
    c->this->nnames   = 
    c->this->maxn   = dptr[object].obj_name >> 16;
    if (c->this->maxn)
      c->this->namelist = (c->nheap + (dptr[object].obj_name & 0xffff));
  }

  sds_next_object();

  if (flag == SDS_OBJECT) 
  {
    c->this->elemcod   = dptr[object].elemcod;
    c->this->address   = sds_getp(dptr,object);
    c->this->align     = dptr[object].align_type;
    if ((c->this->nelems = dptr[object].nelems) == 0L)
      retval = SDS_ZERO_LENGTH;
    c->this->size   = dptr[object].elemsz;
  }
  else 
  {
    c->this->elemcod  = object;
    c->this->address   = (char *)0;
    c->this->align     = (char)0;
    c->this->nelems    = (unsigned long)1;
  }
  c->tdum[0].elemcod  =  c->this->elemcod;
  c->tdum[0].nelems  =  c->this->nelems;

  if ((c->this->elemcod & SDS_INDLIST)) 
  {
    c->tptr = tptr;
    c->this->ind = 
      (unsigned long)tlist_size(c->tptr)/sizeof(struct type_list); 
    c->this->ind -= 3;
  }  
  else 
  {
    c->tptr = c->tdum;
    c->this->ind  = (unsigned long)0;
  }
  c->parent->ind = c->this->ind;

  return(retval);
}
/***********************************************************************/
int
sds_resolve(sds_index,object_index,thing_list,flag)
sds_handle  sds_index;
sds_code  object_index,flag;
struct   sds_odesc  **thing_list;
/***********************************************************************/
{
  long             *header = (long *)get_header(sds_index);
  struct direc     *dptr = sds_direc_ptr(sds_index);
  char             *heap = get_heap(sds_index);
  char             *name = sds_obind2name(sds_index,0);
  struct type_list *tptr = get_tlist(sds_index);

  return sds_vresolve(sds_index,header,dptr,heap,
                name,tptr,object_index,thing_list,flag);
}
/***********************************************************************/
sds_handle
sds_vresolve(sds,header,dptr,heap,name,tptr,object,thing_list,flag)
sds_handle           sds;
int                  flag;
sds_code             object;
long                *header;
struct   sds_odesc **thing_list;
struct direc        *dptr;
char                *heap;
char                *name;
struct type_list    *tptr;
/***********************************************************************/
{

  int  ind = 0;
  char *temp_addr;

  if (c->sds_used == SDS_READY)
  { 
    if ((sds_error = sds_res_init(sds,header,dptr,heap,
                name,tptr,object,flag)) < 0) 
    {
      c->sds_used = SDS_READY;
      return(sds_error);
    }
    else if (sds != c->sds_used) 
    {
      c->sds_used = SDS_READY;
      return(sds_error = SDS_WRONG_RES_LIST);
    }
    c->base_address = (long)c->this->address;
  }

  while (1) 
  {
    while ((c->tptr[c->this->ind].elemcod & SDS_RETLIST)) 
    {
      sds_prev_object(ONE_ELEMENT);
      if (c->this == c->start_stack) 
      {
        c->sds_used = SDS_READY;
        return(SDS_END_RES_STACK);
      }
    }
    ind = c->this->elemcod & ~SDS_CODE_MASK;
    if (c->this->elemcod & SDS_INDLIST)
    {
      if (c->tptr[ind].elemcod & SDS_LENLIST) 
      {
        ind++;
      }
      if (c->tptr[ind].elemcod & SDS_SIZE_ALIGN) 
      {
        c->this->size = c->tptr[ind].nelems;
        c->this->align =
           (char)(c->tptr[ind].elemcod & 0xff);
        ind++;
      }
      c->this->address += c->addr_inc;
      c->this->address += align_delta(c->this->address - c->base_address,
                                      c->this->align);
      temp_addr = c->this->address;
      if ((c->this->nelems == 0) || ((--(c->this->nelems)) == 0)) 
      {
        c->this->ind += 1;
        c->this->nelems = c->tptr[c->this->ind & ~SDS_CODE_MASK].nelems;
        c->this->elemcod = c->tptr[c->this->ind & ~SDS_CODE_MASK].elemcod;
      }
      sds_next_object();
      c->this->address = temp_addr;
      c->addr_inc = 0;
      c->this->ind = ind;
      c->this->nelems = c->tptr[ind].nelems;
      c->this->elemcod = c->tptr[ind].elemcod;
    } 
    else 
    {
      ind = c->this->ind;
      c->this->nelems = c->tptr[ind].nelems;
      if (((c->this->elemcod = c->tptr[ind].elemcod) >= SDS_RETLIST)) 
      {
      } 
      else 
      {
        c->this->size = (long)(sds_sizes[c->this->elemcod] & 0xff);
        c->this->align = c->sds_al[c->this->elemcod] & 0xff;
        c->this->address += c->addr_inc;
        c->this->address += align_delta(c->this->address - c->base_address,
                                        c->this->align);
        *thing_list = c->start_stack;
        c->addr_inc = c->this->size * c->this->nelems;
        c->this->ind += 1;
        return(c->thiso);
      }
    }
  }
}
/***********************************************************************/
unsigned long
sds_tlsize(sds,code,alignment_type)
int  sds;
long  code;
char  *alignment_type;
/*  This figures out the size of an object described by ty_list
 *  The size returned is that of the object in the ORIGINAL system -
 *  While this is going on, I also work out
 *  what sort of datum the thing is. This is needed for
 *  sparchitecture as alignment depends on data type    */
/***********************************************************************/
{
  unsigned long  laddr = 0,lsize = 0,thing_size = (unsigned long)0;
  struct  sds_odesc  *thing;
  int  thiso;

  *alignment_type = (char)0;
  while ((thiso = sds_resolve(sds,code,&thing,SDS_CODE)) >= 0) 
  {
    lsize = thing[thiso].nelems * thing[thiso].size;
    laddr = (unsigned long)thing[thiso].address;
    *alignment_type = 
      (thing[thiso].align > *alignment_type)?
      thing[thiso].align:*alignment_type;
  }
  thing_size = lsize + (unsigned long)laddr; 
  thing_size += align_delta(thing_size,*alignment_type);
  return(thing_size);
}
/***********************************************************************/
unsigned long
sds_rsize(sds,code,alignment_type)
int  sds;
long  code;
char  *alignment_type;
/***********************************************************************/
{
  struct  type_list  *tptr = get_tlist(sds);
  unsigned long  size = (unsigned long)0;
  unsigned long  ind = code & ~SDS_CODE_MASK;
  int  i;

  for (i=0;i<2;i++,ind++)
    if (tptr[ind].elemcod & SDS_SIZE_ALIGN) 
    {
      size = tptr[ind].nelems;
      *alignment_type = (char)(tptr[ind].elemcod & 0xff);
    }
  return(size);
}
    
/***********************************************************************/
long
sds_sizeof_object(sds_index, object_index)
sds_handle    sds_index;
sds_code    object_index;
/***********************************************************************/
{
    unsigned char junk;
    struct direc *dptr = sds_direc_ptr(sds_index);
    sds_handle    size;

    size = sds_object_size(sds_index, dptr[object_index].elemcod, &junk);
    return size * dptr[object_index].nelems;
}
/***********************************************************************/
long
sds_object_size(sds,code,alignment_type)
sds_handle  sds;
sds_code    code;
unsigned char  *alignment_type;
/***********************************************************************/
/*  How big is a thing - a primitive or a reference to a tlist     */
/*  If the size is < 0, this signals an unknown thing.    */
/*  Size 0 is 'undetermined' (eg SDS)        */
{


  long  *header = (long *)get_header(sds);

  if (code == SDS_SDS) 
    return((long)0);
  else if (code & SDS_INDLIST)
    return(sds_rsize(sds,code,alignment_type));
  else if (code < (long)0 || code > (long)NTYPES)
    return(sds_error = SDS_UNDEFINED_TYPE);
  else 
  {
    sds_fix_align(header);
    *alignment_type = c->sds_al[code];
    return((long)sds_sizes[code]);
  }
}
/***********************************************************************/
void
sds_fix_align(header)
long  *header;
/***********************************************************************/
{

  sds_handle  state;
  int         arch = SDS_ARC;

  if (header == (long *)NULL)
    c->sds_al = sds_arcs[arch];
  else 
  {
    state = bad_sds_header((struct sds_header *)header);
    arch = (state == SDS_SWAPPED_BYTES)?
      (*header & 0x00ff0000) >> 16:
      (*header & 0x0000ff00) >> 8;
    c->sds_al = sds_arcs[arch-1];
  }
}



/***********************************************************************/
sds_handle 
object_size(dptr,tptr,heap)
struct direc     *dptr;
struct type_list  *tptr;
char        *heap;
/***********************************************************************/
{


  long  *header = (long *)NULL;
  long  code = dptr->elemcod;

  if (code & SDS_INDLIST)
    return(object_tlsize(header,dptr,heap,"",tptr));
  else if (code < (long)0 || code > (long)NTYPES)
    return(sds_error = SDS_UNDEFINED_TYPE);
  else 
  {
    sds_fix_align(header);
    dptr->align_type = c->sds_al[code];
    return((long)sds_sizes[code]);
  }
}
/***********************************************************************/
sds_handle 
object_tlsize(header,dptr,heap,name,tptr)
long        *header;
struct direc     *dptr;
char        *heap;
char        *name;
struct type_list  *tptr;
/***********************************************************************/
{
  unsigned long  laddr = 0,lsize = 0,thing_size = (unsigned long)0;
  struct  sds_odesc  *thing;
  int  thiso;
  long  code = dptr->elemcod;

  while ((thiso = sds_vresolve(SDS_VIRTUAL,header,
        dptr,heap,name,tptr,code,&thing,SDS_CODE)) >= 0) 
  {
    lsize = thing[thiso].nelems * thing[thiso].size;
    laddr = (unsigned long)thing[thiso].address;
    dptr->align_type = 
      (thing[thiso].align > dptr->align_type)?
      thing[thiso].align:dptr->align_type;
  }
  thing_size = lsize + (unsigned long)laddr; 
  thing_size += align_delta(thing_size,dptr->align_type);
  sds_rinit();
  return(thing_size);
}
