/* $Header: shm.c,v 1.7 92/08/10 14:01:14 salty Exp $ */

/**************************************************************************
 *                 ****** ISTK Release 1.2 *****                          *
 *                                                                        *
 *                                                                        *
 * This code has been produced by numerous authors at the CERN centre for *
 * high energy physics, Geneve, Switzerland, at the SSC laboratory in     *
 * Dallas, Texas, USA and at the Lawrence Berekeley Laboratory in         *
 * California, USA.                                                       *
 * The latter two institutions perform work under US Government contract. *
 * The intent of the work is to provide useful code for people who need   *
 * it, with an emphasis on free and collaborative exchange of ideas,      *
 * techniques and implementations.                                        *
 * Please read the disclaimer and copyright notices contained in the ISTK *
 * distribution and in distributed applications.                          *
 *                                                                        *
 **************************************************************************/


/* Reference release  Aug 10 1991 - C G Saltmarsh */
/* Has the basics used at CDG & SSC 1988-1991, plus vxworks
   support
*/


/*s**********************************************************************
 *                                                                      *
 *              Copyright (C) Frogsoft Corporation, 1986                *
 *                                                                      *
 *      This library contains Proprietary Information of Frogsoft       *
 *      Corporation and should not be treated as Confidential.          *
 *                                                                      *
 *                                                                      *
 *                                                                      *
 *      Authors: WFH, CGS                                               *
 *                                                                      *
 *                                                                      *
 *                                                                      */
/*e**********************************************************************/

#include <stdio.h>     
#include <ctype.h>     
#include <time.h>
#include <stdlib.h>

#ifndef vms
#include <unistd.h>
#include <memory.h>
#endif

#ifdef vms
#include <types.h>
#include <stat.h>
#include <file.h>
#else
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <string.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifdef hp9000s300
#include <sys/sysmacros.h>
#endif

#if defined(__DGUX__) || defined(sgi)
extern void     *shmat();
#else
extern char     *shmat();
#endif

#ifdef lynx68k
#define SHM_DEF_KEY_SIZE 1
#else
#define SHM_DEF_KEY_SIZE 0
#endif

extern char     *sbrk();

#endif

#if defined(vms)
#include "direc.h"
#include "sds_externs.h"
#else
#include "Sds/direc.h"
#include "Sds/sds_externs.h"
#endif

extern int sds_error;
     
key_t getkey();

#ifdef  hp9000s300
static  char  *end_shared_mem = (char *)0;
#define  MALLOC_SPACE  0x800000
#endif

/******* forward declarations *****/
#if defined(__STDC__)
char      *shm_attach(key_t, int);
int        shm_back(char *,char *);
void       shm_dt(struct direc *);
#else
char      *shm_attach();
int        shm_back();
void       shm_dt();
#endif
     
char *
shm_make(name,size,mode)
/*s**********************************************************************
 *                                                                      *
 *      Creates a data segment of 'name' (with expansion)               *
 *      size 'size' (same units as sizeof)                              *
 *      mode 'mode' (umask is cleared before creation)                  *
 *                                                                      *
 *      Author: CGS, WFH                                                *
 *                                                                      */
/*e**********************************************************************/
char    *name;
int    size,mode;
{
  struct  shmid_ds  nop;
  char             *sdptr;
  key_t             key;
  char              fullname[128];
  int               sid;
  int               cmask,flags;
  int               user_id, grp_id;
  struct  stat      statbuf;

  user_id = getuid();
  grp_id  = getgid();
     
  nop.shm_perm.mode = 0666;
  nop.shm_perm.uid = (ushort)user_id;
  nop.shm_perm.gid = (ushort)grp_id;
   
  cmask = umask(0);
  nexpand(fullname,name);
  if (stat(fullname,&statbuf) == -1) 
  {
    fprintf(stderr,
            "Check existance of key file for shared memory:%s\n",
            fullname);
    exit(1);
  }
  shm_destroy(name);
  key = getkey(fullname);
  flags = IPC_CREAT | 0666;
  if ((sid = shmget(key,size,flags)) == -1) 
  {
    perror("failed to shmget");
    fprintf(stderr,"key %d size %d flags %x\n",(int)key,size,(unsigned)flags);
    exit(1);
  }

  shmctl(sid,IPC_SET,&nop);

  sdptr = shm_attach(sid,0);

  cmask = umask(cmask);
  return(sdptr);
}
struct direc    *
shm_attr(name)
/*s**********************************************************************
 *                                                                      *
 *      1. Attach shared data with name "/user/.../shardat/name" and    *
 *         return pointer to directory.                                 *
 *                                                                      *
 *      Author: CGS, WFH                                                *
 *                                                                      */
/*e**********************************************************************/
char    *name;
{
  char              *sdptr;
  key_t              key;
  int                sid;
  char              fullname[80];
     
  sds_error = 0;
  nexpand(fullname,name);
  key = getkey(fullname);
  sid = shmget(key,SHM_DEF_KEY_SIZE,0666);
  sdptr = shm_attach(sid,SHM_RDONLY);

  if (sdptr == SNULL) return(DNULL);

  if (bad_sds_header((struct sds_header *)sdptr)) 
  {
    shmdt(sdptr);
    return(DNULL);
  }
  return(header_to_direc(sdptr));
}
     
struct direc    *
shm_attw(name)
/*s**********************************************************************
 *                                                                      *
 *      1. Attach shared data with name "/user/.../shardat/name" and    *
 *         return pointer to it.                                        *
 *                                                                      *
 *      Author: CGS, WFH                                                *
 *                                                                      */
/*e**********************************************************************/
char    *name;
{
  char  *sdptr;
  key_t   key;
  int     sid;
  char    fullname[80];
     
  nexpand(fullname,name);
  key = getkey(fullname);
  sid = shmget(key,SHM_DEF_KEY_SIZE,0666);
  sdptr = shm_attach(sid,0);

  if (sdptr == SNULL) 
  {
    return(DNULL);
  }
  if (bad_sds_header((struct sds_header *)sdptr)) 
  {
    shmdt(sdptr);
    return(DNULL);
  }
  return(header_to_direc(sdptr));
}
     
int
shm_quit(dptr)
/*s**********************************************************************
 *                                                                      *
 *      Author: CGS, WFH                                                *
 *                                                                      */
/*e**********************************************************************/
struct direc    *dptr;
{
  char *sdptr = (char *)dptr - dptr[0].offst;
  return(shmdt(sdptr));
}

int
shm_q(name)
/*s**********************************************************************
 *                                                                      *
 *      Query the existence of a shared data segment                    *
 *              calling sequence:       i = shm_q(name)                 *
 *                                      char    *name (name of segment) *
 *              return values:          i = 0  segment does not exist   *
 *                                      i = 1  segment does exist       *
 *                                                                      *
 *      Author: WFH                                                     *
 *      last modification:      23.02.1987      14:36                   *
 *                                                                      */
/*e**********************************************************************/
char    *name;
{
        key_t   key;
        char    fullname[80];
     
        nexpand(fullname,name);
        key = getkey(fullname);
         return(shmget(key,0,0666)<0?0:1);
}

int
shm_back(fname,ffname)
/*********************************************************************
*                                                                    *
*   Back up a shared data segment fname into the file ffname         *
*                                                                    *
*   Author:   CGS,WFH      15.06.1987                                *
*                                                                    *
***************************************************/
char    *fname,*ffname;
{
  struct direc   *dptr;
  int  ret = 0;
     
/*      attach to table                                 */
  if ((dptr = shm_attr(fname)) == DNULL) return(-1);
  ret = sds_back(dptr,ffname);
  shm_dt(dptr);
  return(ret);
}

void
shm_dt(dptr)
struct direc * dptr;
{
  char *sdptr;
  sdptr = (char *)dptr - dptr[0].offst;
  shmdt((char *)dptr);
}

int
shm_unback(fname,ffname)
/*s**********************************************************************
 *                                                                      *
 *   Copies file "fname" to a shared data segment "fname"               *
 *   The shared data segment is created                                 *
 *                                                                      *
 *      Author: WFH,CS,RJ}      09.05.1987      16:51                   *
 *   Last modification:   21.07.1987   10:22                            *
 *                                                                      */
/*e**********************************************************************/
char    *fname,*ffname;
{
  char            *sdptr;
  int    nbytes;
  char    fullname[256];
  key_t   key;
  int     fd;
  int   sid, shmflg;
  off_t   ffsiz();
     
  nexpand(fullname,fname);
  key = getkey(fullname);
  if ((fd = open(ffname,O_RDONLY, 0x664)) == -1)
  { 
    return -1;
  }

  nbytes = ffsiz(fd) + BASE_OFFSET;
/*      make table                                      */
  shmflg = 0666 | IPC_CREAT;
  sid = shmget(key,(int)nbytes,shmflg);
  if ((sdptr = shm_attach(sid,0)) == SNULL) 
  {
    return(-1);
  }

  sds_read_data(fd,sdptr,nbytes);
  close(fd);
  shmdt(sdptr);
  return(0);
}

int
shm_sz(fname)
/*********************************************************************
*                                                                    *
*   returns size of a shared data segment fname                      *
*                                                                    *
*   Author:   CGS,WFH      15.06.1987                                *
*                                                                    *
***************************************************/
char    *fname;
{
  struct   direc   *dptr;
     
  if ((dptr = shm_attr(fname)) == DNULL) return(-1);
    return(sds_sz(dptr));
}
int
shm_destroy(name)
/******************************************************
 *  Destroy  dataset <name> if it exists
 *
 ******************************************************/
char  *name;
{
     
  if (shm_q(name)) /*it exists : destroy it */
	{ 
    key_t             mykey;
    int               shmid,i;
    char              fullname[128];
    struct  shmid_ds  shmidstruc;
    struct  shmid_ds  *buf = &shmidstruc;

    nexpand(fullname,name);
    mykey = getkey(fullname);
		shmid = shmget(mykey,SHM_DEF_KEY_SIZE,0);
    if ((i = shmctl(shmid,IPC_RMID,buf)) != 0) 
      return(-1);
  }
	return 0;
}

/*************************************************************************/
char  *
shm_attach(sid, flag)
key_t  sid;
int    flag;
/*************************************************************************/
{
  char              *shm_ptr;
#ifdef  hp9000s300
	struct  shmid_ds  nop;
#endif


  if (sid < 0)
  {
    return (char *)0;
  }

#ifdef  hp9000s300
  if (end_shared_mem == (char *)0)
  {
    end_shared_mem = sbrk(0) + MALLOC_SPACE ;
  }
#ifdef  SHM_DEBUG
  printf("end of shm is %x\n",(int)end_shared_mem);
#endif

  end_shared_mem += 0x1000 - (int)end_shared_mem % 0x1000;

#ifdef  SHM_DEBUG
  printf("end of shm modulo'd to %x\n",(int)end_shared_mem);
#endif
  if ((shm_ptr = (char *)shmat(sid,end_shared_mem,flag  )) == (char *)-1) 
  {
#ifdef  SHM_DEBUG
    perror("attach failed");
#endif
    return (char *)0;
  }
  shmctl(sid,IPC_STAT,&nop);
  end_shared_mem = shm_ptr +  nop.shm_segsz;

#ifdef  SHM_DEBUG
  printf("seg size %x at %x\n",nop.shm_segsz,(int)shm_ptr);
  printf("end shm is %x\n",(int)end_shared_mem);
#endif

#else /* not hp - sun perhaps */

  if ((shm_ptr = (char *)shmat(sid,(char *)0,flag)) == (char *)-1) 
  {
    return (char *)0;
  }

#endif

  return shm_ptr;
}

key_t
getkey(fullname)
char  *fullname;
{
  key_t key;
  key = ftok(fullname,'c');
  if (key == -1) 
  {
    fprintf(stderr,
            "Check existance of key file for shared memory:%s\n",
            fullname);
    exit(1);
  }
  return key;
}
