/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * calibrate.c -- Calibrate the number of iterations of a set piece of code to produce
 *                a 100 microsecond delay.
 * 
 * Author           : Peter A. Buhr
 * Created On       : Fri Nov  9 08:12:37 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:24:35 1990
 * Update Count     : 4
 */

#include <stdio.h>
#include <Time.i>

#define TIMES 10000000					/* cannot be larger or overflow will occur */

int main() {
    int i;
    int StartTime, EndTime;
    
    StartTime = Time();					/* do it once to set up memory */
    for ( i = 1; i <= TIMES; i += 1 ) {
    } /* for */
    EndTime = Time();

    StartTime = Time();					/* now do it for real */
    for ( i = 1; i <= TIMES; i += 1 ) {
    } /* for */
    EndTime = Time();

    fprintf( stdout, "#define ITERATIONS_FOR_100USECS %d\n", ( 100 * TIMES ) / ( EndTime - StartTime ) );

    return( 0 );					/* so that "make" does not terminate */
} /* main */

/* Local Variables: */
/* compile-command: "gcc -O calibrate.c" */
/* End: */
