/* Copyright (c) 1988 P. A. Buhr */

/*
  This is a monitor implementation of the LOOK disk scheduling algorithm (elevator
  algorithm).  The LOOK algorithm schedules movement of the disk head in the same
  direction until there are no more outstanding requests in that direction, and
  then it switches direction.
  */

#include <uMonitor.h>

uMonitor LOOK {
#   define NoOfTracks 100
    
    uCondition Tracks[NoOfTracks];
    int NoRequest = 0;
    int CurrentPos = 0, Direction = 1;

    uEntry void InitLOOK( void ) {
	int i;

	for ( i = 0; i < NoOfTracks; i += 1 ) {
	    Tracks[i] = U_CONDITION;
	} /* for */
    } /* InitLOOK */
    
    uEntry void StartDiskRequest( int TrackNo ) {
	NoRequest += 1;					/* request for disk usage */
	if ( NoRequest > 1 ) {				/* disk in use => wait */
	    uWait Tracks[TrackNo];			/* wait on the condition variable for this track */
	} /* if */
    } /* StartDiskRequest */
    
    uEntry void EndDiskRequest( void ) {
	NoRequest -= 1;
	if ( NoRequest > 0 ) {				/* any processs waiting ? */
	    for ( ;; ) {				/* scan along tracks in one direction for a process to execute */
	    if ( uCondLength( &Tracks[CurrentPos] ) != 0 ) break; /* found a waiting process ? */
		if ( CurrentPos == 0 ) {		/* off one end ?, change direction */
		    Direction = 1;
		    uPrintf( "Turning, Direction:%d\n", Direction );
		} /* if */
		if ( CurrentPos == NoOfTracks - 1 ) {	/* or the other end ?, change direction */
		    Direction = -1;
		    uPrintf( "Turning, Direction:%d\n", Direction );
		} /* if */
		CurrentPos += Direction;		/* advance to check next track */
	    } /* for */
	    uSignal Tracks[CurrentPos];			/* signal next request */
	} /* if */
    } /* EndDiskRequest */
} /* LOOK */

void DiskUser( int trackno ) {
    StartDiskRequest( trackno );
    uPrintf( "processing request:%d\n", trackno );
    EndDiskRequest( );
    uDie( NULL, 0 );
} /* DiskUser */

#define NoOfTests 10

int tester[NoOfTests] = { 20, 99, 0, 15, 30, 4, 16, 80, 85, 2 };

void uMain( ) {
    uTask process[NoOfTests];
    int i;

    InitLOOK( );					/* initialize the monitor */
    
    for ( i = 0; i < NoOfTests; i += 1 ) {
	process[i] = uEmit( DiskUser, tester[i] );
	uYield( );
    } /* for */
    
    for ( i = 0; i < NoOfTests; i += 1 ) {
	uAbsorb( process[i], NULL, 0 );
    } /* for */
} /* uMain */
