/*
  Girl and Boy processes use a monitor to exchange phone numbers.  A Girl
  or Boy process must wait until a task of the opposite sex arrives to
  exchange phone numbers.
  */

#include <uMonitor.h>

extern int random( void );

#define Girl 0
#define Boy 1
#define other(t) (1 - t)

uMonitor ExPhoneNos (PriorityNonBlocking) {
    int PhoneNo[2];
    uCondition GirlBoy[2] = {U_CONDITION, U_CONDITION}, WaitForPartner = U_CONDITION;
    
    uEntry int Exchange( int sex, int HomeNo ) {
	if (uCondLength(&GirlBoy[other(sex)]) == 0) {
	    uWait GirlBoy[sex];
	    PhoneNo[sex] = HomeNo;
	    uSignal WaitForPartner;
	} else {
	    PhoneNo[sex] = HomeNo;
	    uSignal GirlBoy[other(sex)];		/* signal partner */
	    uWait WaitForPartner;
	}
	return PhoneNo[other(sex)];
    } /* Exchange */
} /* ExPhoneNos */

void Person(int gender) {
    int PhoneNo;
    char *names[2] = { "Girl", " Boy" };
    
    PhoneNo = Exchange( gender, (int)uThisTask( ) );
    uPrintf( "%s:%x exchanged with %s:%x\n", names[gender], uThisTask(), names[other(gender)], PhoneNo );

    uDie( NULL, 0 );
} /* Person */

#define NoOfPersons 40

void uMain( ) {
    int i, Boys, Girls;
    uTask PidGirls[NoOfPersons / 2], PidBoys[NoOfPersons / 2];

    for ( Boys = 0, Girls = 0; Boys + Girls < NoOfPersons; ) {
	if ( random() % 10 <= 7 ) {			/* create more girls at the start */
	    if ( Girls < NoOfPersons / 2 ) {
		PidGirls[Girls] = uEmit( Person, Girl );
		Girls += 1;
	    } /* if */
	} else {
	    if ( Boys < NoOfPersons / 2 ) {
		PidBoys[Boys] = uEmit( Person, Boy );
		Boys += 1;
	    } /* if */
	} /* if */
	if ( ( Boys + Girls ) % 3 == 0 ) {				/* let them get mixed up a bit */
	    uDelay( 2 );
	} /* if */
    } /* for */
    
    for ( i = 0; i < NoOfPersons / 2; i += 1 ) {	/* absorb the girls */
	uAbsorb( PidGirls[i], NULL, 0 );
    } /* for */
    
    for ( i = 0; i < NoOfPersons / 2; i += 1 ) {	/* absorb the boys */
	uAbsorb( PidBoys[i], NULL, 0 );
    } /* for */

    uPrintf( "successful execution\n" );
} /* uMain */
