/* Monitor Program Example 3 */
/* Copyright (c) 1986 P. A. Buhr */

/*
  Third Reader/Writer Problem (Hoare 74)
  
  A single resource is modified by a number of writer processes and accessed by a
  number of reader processes. Any number of reader process may simultaneously
  access the resource, but only one process, a writer, can be accessing the
  resource during a modification. Note that when a writer process has exclusive
  access to the resource, it is not precluded from first reading the resource
  before changing it; hence a writer may also be a reader, but the converse is not
  true.
  */

/*
  This monitor implements the readers and writers in the following way. Readers
  wait if there is a writer, all readers are started after a writer (Hoare). This
  allows readers to temporally jump ahead of writers.  Hence, readers might be
  reading stale information (i.e. readers that occur after a write do not read the
  information from the write). It does solve the starvation problem.
  */

#include <uMonitor.h>

uMonitor {
    int ReadCount = 0, WriteUsage = 0;
    uCondition OkToRead = U_CONDITION, OkToWrite = U_CONDITION;
    
    uEntry void StartRead() {
	if (WriteUsage || uCondLength(&OkToWrite) != 0) uWait OkToRead;
	ReadCount += 1;
	uSignal OkToRead;				/* once one reader can start, they all can */
    } /* StartRead */
    
    uEntry void EndRead() {
	ReadCount -= 1;
	if (ReadCount == 0) uSignal OkToWrite;
    } /* EndRead */
    
    uEntry void StartWrite() {
	if (WriteUsage || ReadCount != 0) uWait OkToWrite;
	WriteUsage = 1;
    } /* StartWrite */
    
    uEntry void EndWrite() {
	WriteUsage = 0;
	if (uCondLength(&OkToRead) != 0) {
	    uSignal OkToRead;
	} else {
	    uSignal OkToWrite;
	} /* if */
    } /* EndWrite */
}
