/* Monitor Program Example 4 */
/* Copyright (c) 1986 P. A. Buhr */

/*
  Fourth Readers and Writers Problem
  
  A single resource is modified by a number of writer processes and accessed
  by a number of reader processes. Any number of reader process may simultaneously
  access the resource, but only one process, a writer, can be accessing the
  resource during a modification. Note that when a writer process has exclusive
  access to the resource, it is not precluded from first reading the resource
  before changing it; hence a writer may also be a reader, but the converse is not
  true.
  */

/*
  This monitor ensures that readers and writers are serviced in a FIFO manner.
  There is no starvation and no stale reads.
  */

#include <uMonitor.h>

uMonitor {
#   define READER 0
#   define WRITER 1
    
    int ReadCount = 0, WriteUsage = 0;
    uCondition ReaderWriter = U_CONDITION;
    
    uEntry void StartRead() {
	if (WriteUsage || uCondLength(&ReaderWriter) != 0) {
	    uWait ReaderWriter with READER;
	} /* if */
	ReadCount += 1;
	if (uCondLength(&ReaderWriter) != 0) {
	    if (uCondFront(&ReaderWriter) == READER) {
		uSignal ReaderWriter;
	    } /* if */
	} /* if */
    } /* StartRead */
    
    uEntry void EndRead() {
	ReadCount -= 1;
	if (ReadCount == 0) {
	    uSignal ReaderWriter;
	} /* if */
    } /* EndRead */
    
    uEntry void StartWrite() {
	if (WriteUsage || ReadCount != 0) {
	    uWait ReaderWriter with WRITER;
	} /* if */
	WriteUsage = 1;
    } /* StartWrite */
    
    uEntry void EndWrite() {
	WriteUsage = 0;
	uSignal ReaderWriter;
    } /* EndWrite */
}
