/* Copyright (c) 1989  P. A. Buhr */

/*
  Method: Dekker's algorithm: Prevent the bounded waiting problem by
  alternating between processes when they both simultaneously declare intent.
  Work?: YES
  */

#include <uSystem.h>

#define WantIn 1
#define DontWantIn 0

int *Last;						/* shared between processes */

void Dekker(int *me, int *other) {
    int i;						/* loop counter */

    for (i = 1; i <= 1000; i += 1) {			/* exercise critical section */

        /* entry protocol */

        *me = WantIn;					/* declare intent */
        while (*other == WantIn) {			/* other process wants in, too */
            if (Last == me) {				/* last one in CS ? */
                *me = DontWantIn;			/* retract intent */
                while (Last == me) {}			/* busy wait until it's my turn */
                *me = WantIn;				/* declare intent & try again */
            } /* if */
        } /* while */
    
        /* critical section */
    
        CriticalSection();

        /* exit protocol */

        Last = me;
        *me = DontWantIn;				/* declare not interested */
    } /* for */

    uDie(NULL, 0);
} /* Dekker */

void uMain() {
    uTask t0, t1;
    int me, other;					/* shared between processes */
 
    uSetTimeSlice(10);
    
    me = other = DontWantIn;
    Last = &me;
    t0 = uEmit(Dekker, &me, &other);			/* start process */
    t1 = uEmit(Dekker, &other, &me);			/* start process */
 
    uAbsorb(t0, NULL, 0);				/* wait for completion of process */
    uAbsorb(t1, NULL, 0);				/* wait for completion of process */
    uPrintf("successful execution\n");
} /* uMain */
