/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * parcc.c -- Command to compile programs that use the multiple processor uSystem.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Wed Feb 14 13:50:16 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:31:40 1990
 * Update Count     : 13
 */

#include <stdio.h>
#include "uUnix.h"
#include "shell.h"
#include "vstrcat.h"

#define MAX 1024					/* maximum length of strings */

char *home = HOME;					/* home directory for uSystem defined in Makefile */

void main( int argc, char *argv[] ) {

    int i;
    char com[MAX] = "";					/* declare space for command and initialize it to empty string */
    
    vstrcat( com, home, "/bin/concc -multi", 0 );	/* concat home and ucc path along with options to command */

    for ( i = 1; i < argc; i += 1 ) {
	vstrcat( com, " ", argv[i], 0 );		/* concat each arg to command */
    } /* for */

    exit( shell( com ) );				/* call shell to execute command, and return result */
} /* main */

/* Local Variables: */
/* compile-command: "dmake" */
/* End: */
