/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * cpp.c -- Command for preforming the monitor preprocessor pass after the cpp preprocessor pass.
 * 
 * Author           : Peter A. Buhr
 * Created On       : Sat Nov 17 12:05:29 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Mon Mar 11 13:46:02 1991
 * Update Count     : 11
 */

#include <stdio.h>
#include <strings.h>
#include <uUnix.h>
#include <shell.h>
#include <vstrcat.h>

#define MAX 1024

char *home = HOME;

int main( int argc, char *argv[] ) {

    int i;
    int j;
    int code;
    char *dir = "/release";
    char tmp[MAX];
    char arg[MAX] = "";
    char com[MAX] = "";
    char *cpp_in = "";
    char *cpp_out = "";
    char *mon = "";

    sprintf( tmp, "/tmp/moncc%d", getpid() );
    
    for ( i = 1; i < argc; i += 1 ) {
	if ( strcmp( argv[i], "-D__MON__" ) == 0 ) {
	    mon = "MON";
	} else if ( strcmp( argv[i], "-D__MONWORK__" ) == 0 ) {
	    dir = "/work";
	} else if ( argv[i][0] == '-' ) {
	    vstrcat( arg, " ", argv[i], 0 );
	} else {
	    if ( strcmp( cpp_in, "" ) == 0 ) {
		cpp_in = argv[i];
	    } else if ( strcmp( cpp_out, "" ) == 0 ) {
		cpp_out = argv[i];
	    } else {
		for ( j = 0; j < argc; j += 1 ) {
		    printf( "%s ", argv[j] );
		} /* for */
		printf( "\n%s usage: %s input-file [output-file] [options]\n", argv[0], argv[0] );
		exit( 1 );
	    } /* if */
	} /* if */
    } /* for */

    if ( strcmp( cpp_out, "" ) == 0 && strcmp( mon, "MON" ) == 0 )  {
	printf( "error, cannot use -E and -MON flags together.\n" );
	exit( -1 );
    } /* if */

    if ( strcmp( cpp_out, "" ) == 0 ) {
	vstrcat( com, "gcc -E", arg, " ", cpp_in, 0 );
	exit( shell( com ) );
    } /* if */

    vstrcat( com, "gcc -E", arg, " ", cpp_in, " > ", tmp, 0 );
    code = shell( com );
    if ( code != 0 ) {
	unlink( tmp );
	exit( code );
    } /* if */

    strcpy( com, "" );
    
    if ( strcmp( mon, "MON" ) == 0 ) {
	vstrcat( com, home, "/monitor", dir, "/bin/mon-cpp ", tmp, 0 );
	shell( com );
	unlink( tmp );
	exit( -1 );					/* do not continue compilation */
    } /* if */

    vstrcat( com, home, "/monitor", dir, "/bin/mon-cpp ", tmp, " ", cpp_out, 0 );
    code = shell( com );
    unlink( tmp );
    if ( code != 0 ) {					/* shell can return + and - code */
	exit( -1 );					/* do not continue compilation */
    } /* if */
    return( 0 );
} /* main */

/* Local Variables: */
/* compile-command: "/bin/make -k" */
/* End: */
