#ifndef _MON_PCS_LIST_H
#define _MON_PCS_LIST_H

typedef struct _Mon_pcs {
    uSemaphore semaphore;
    struct _Mon_pcs *next;
} _Mon_pcs;

typedef struct _Mon_pcs_list {
    _Mon_pcs *head;
    _Mon_pcs *tail;
} _Mon_pcs_list;

static inline void _mon_add_pcs_to_pcs_list( _Mon_pcs_list *pcs_list, _Mon_pcs *pcs )
{
    pcs -> next = NULL;
    if ( pcs_list -> head ) {
	pcs_list -> tail -> next = pcs;
    } else {
	pcs_list -> head = pcs;
    }
    pcs_list -> tail = pcs;
}

static inline _Mon_pcs *_mon_remove_pcs_from_pcs_list( _Mon_pcs_list *pcs_list )
{
    _Mon_pcs *pcs = pcs_list -> head;
    pcs_list -> head = pcs -> next;
    return pcs;
}

static inline int _mon_not_empty_pcs_list( _Mon_pcs_list *pcs_list )
{
    return ( pcs_list -> head != NULL );
}

static inline _Mon_pcs *_mon_first_pcs_of_pcs_list( _Mon_pcs_list *pcs_list )
{
    return pcs_list -> head;
}
#endif
