'\" t
.TH xftp 1 "24 Sept 1993"
.na
.SH NAME
LLNL XFTP - an X-based interface to FTP
.RE

.SH SYNOPSIS
xftp [standard X options]
.RE

.SH DESCRIPTION

\fILLNL XFTP\fR is a graphical user interface to FTP (File Transfer Protocol).  \fILLNL XFTP\fR does not execute the \fIftp\fR program; instead, it directly communicates with remote FTP servers.  \fILLNL XFTP\fR is an X client and follows the OSF/Motif look-and-feel.  \fILLNL XFTP\fR enables users to transfer files and perform various directory manipulation commands, both remotely and locally.  Two especially notable features are the ability to (1) perform "third-party" file transfers, and (2) transfer or delete entire directory substructures.

\fILLNL XFTP's\fR main window is divided into five main sections: (1) the main menu bar at the top of the window,  (2) the diagnostics log at the bottom, (3) the file transfer controls in the center, and (4 and 5) the "left" and "right" host sections to either side of the file transfer controls.

\fILLNL XFTP\fR can be connected to zero, one, or two hosts.  The hosts may be any combination of local and remote hosts (the local host is the client host upon which \fILLNL XFTP\fR is running).  In this document, a connected host is referred to as either the "left" or "right" host, depending on whether it is displayed in the left or right host section, respectively.

Each host section consists of four major graphical elements: (1) a label which displays the host's name; (2) a menu bar whose menus contain many commands that operate on the host; (3) a "directory" menu; and (4) a scrollable "directory list."

Each host's \fIConnect\fR menu contains commands for connecting/disconnecting local and remote hosts.

Each host's \fIDir\fR menu contains various commands for creating new directories, and for changing and displaying the current directory.

Each host's \fISelect\fR menu contains commands for selecting/deselecting entries in the current directory (the selections appear in the scrollable list of directory entries).

Each host's \fIOps\fR menu contains several commands that operate on selected directory entries.

Each host's directory menu contains each link of the path of the current directory (the last link is displayed).  By selecting a link in the path, the current directory is correspondingly changed.  (Hence, this is a mechanism to traverse up the host's directory structure.)

Each host's directory list contains the entries of the current directory.  One way to select/deselect a directory entry is to click on it.  If an entry is double-clicked, an attempt is made to change the current directory to that entry.  (Hence, this is a way to traverse down the host's directory structure.)

The file transfer controls in the middle of the main window allow the user to initiate file transfers on selected entries.  The transfers can go from left to right or from right to left.  Angle brackets in the \fICopy\fR and \fIRcopy\fR buttons indicate the direction of the transfer (e.g., ">>Copy>>" indicates that a left-to-right transfer would take place).

The scrollable diagnostics log window at the bottom of the main window displays error and status information.  The user can control the level of verbosity of messages written to this window via the user preference \fIDiagnostics.\fR  The contents of this window can be saved to a file by selecting the \fISave\fR \fILog\fR item in the \fILog\fR menu.  The diagnostics window can be cleared by selecting the \fIClear\fR \fILog\fR item in the \fILog\fR menu.

There is a flag to the left of the diagnostics log window that indicates whether an operation completes successfully or not.  If an operation fails then (1) a beep is emitted, (2) the flag changes from green to red (white to black on monochrome displays), (3) the "OK" in the flag changes to "E", and (4) an error message is written to the diagnostic  log window. The next operation will clear the error flag.

\fILLNL XFTP\fR automatically caches (1) wildcard expressions, (2) paths of current directories, (3) host names and user names used in connecting to remote hosts, and (4) quoted commands.  The purpose of each cache is to reduce the amount of typing required.  For example, when the user wishes to apply a wildcard expression to select directory entries, a list of recently referenced wildcard expressions for that host will be presented to the user; the user can then double-click on an existing wildcard expression to apply it.  The cache is automatically preserved across \fILLNL XFTP\fR sessions in a file named \fI.xftpcache\fR in the users home directory.
.RE
.SH GETTING STARTED
Use the \fIConnect\fR menus to connect the two sides to the desired combination of local and/or remote hosts.  (Depending on how the user preferences are set, when \fILLNL XFTP\fR comes up some combination of the left and right sides might already be connected to the local host.)

Once connected, traverse through a host's directory structure by (1) using the directory name menu (the menu just above the directory list), (2) double-clicking on entries in the directory list, or (3) selecting the \fIChange\fR \fIDirectory\fR item in the host's \fIDir\fR menu.

Obtain different types of views into a host's current directory by selecting the \fIDisplay\fR \fIDirectory\fR (\fILong)\fR or \fIDisplay\fR \fIDirectory\fR (\fITable)\fR items in the host's \fIDir\fR menu.

Select/deselect directory entries to operate on by (1) single-clicking on entries in the main directory list, (2) single-clicking on entries in the tabular directory list, (3) dragging the mouse with the left button held down over entries in the tabular directory list, or (4) by selecting any of the items in the host's \fISelect\fR menu.

Transfer selected items by clicking on the \fICopy\fR or \fIRcopy\fR (recursive copy) buttons.  Be sure to first set the file transfer mode by toggling the appropriate button (\fIASCII\fR or \fIBinary)\fR in the main window.

Perform other types of operations on selected items by selecting any one of the items in the host's \fIOps\fR menu.

Configure \fILLNL XFTP\fR by selecting the \fIPreferences\fR item in the \fIOptions\fR menu.
.RE
.SH COMMANDS
\fILLNL XFTP\fR contains a large number of commands.  The commands are found in (1) the main menus, (2) the host menus, and (3) in the \fIXfer Ops\fR controls.  Here is a list of the commands:

About LLNL XFTP (in \fIFile\fR menu) 
.RS
Gives version information.
.RE

Change Directory (in \fIDir\fR menus) 
.RS
Change the current directory.  A dialog pops up to prompt for the directory to change to.  The directory may be specified with a full or relative path.  Previously referenced directories are cached and displayed in a scrollable list.  Double-click on a path in the list to change to that directory.  Single click on a path in the list to place that entry into the text field labeled "Directory:", where it can be edited.  Click on the \fIOK\fR button to change to the directory displayed in the text field.  (See user preferences \fIAdd\fR \fIto\fR \fICache,\fR \fIDiagnostics,\fR \fIDirectory\fR \fICache\fR \fISize,\fR \fIHost\fR \fICache\fR \fISize,\fR and \fISort\fR \fICaches.)\fR
.RE

Clear Log (in \fILog\fR menu) 
.RS
Clear the diagnostics log window.
.RE

Connect to Local (in \fIConnect\fR menus) 
.RS
Connect to the local (client) host.  If currently connected, the connection is first closed.  (See user preferences \fILeft\fR \fIAuto\fR \fILocal\fR \fILogin\fR and \fIRight\fR \fIAuto\fR \fILocal\fR \fILogin.)\fR
.RE

Connect to Remote (in \fIConnect\fR menus) 
.RS
Connect to a remote host.  If currently connected, the connection is first closed.  A dialog pops up to prompt for the remote host and user names.  An optional port number may follow the host name (using a space as the delimiter).  Previously used host/user name pairs are cached and displayed in a scolled list labeled "Recently Referenced Hosts:".  Double-clicking on a host/user name pair initiates a connection.  Single-clicking on a host/user name pair places those values into the host name and user name fields, where they can be edited.  Click on the \fIConnect\fR button to initiate a connection.  (See user preferences \fIAdd\fR \fITo\fR \fICache,\fR \fIDiagnostics,\fR \fIHost\fR \fICache\fR \fISize,\fR \fIUser\fR \fICache\fR \fISize,\fR and \fISort\fR \fICaches.)\fR
.RE

Contextual Help (in \fIHelp\fR menu) 
.RS
Enter contextual-help mode.  The mouse cursor changes to a pointing hand.  Move the hand and click on any graphical element in the main window that you wish to know more about.
.RE

Copy (in \fIXfer\fR \fIOps\fR controls) 
.RS
Transfers the selected files according to the mode (\fIASCII\fR or \fIBinary)\fR specified in \fIXfer\fR \fIMode.\fR  A dialog pops up to enable the user to monitor the progress of the transfers.  The dialog contains a button for aborting the transfers.  (See user preferences \fIBeep\fR \fIWhen\fR \fIOps\fR \fIDone,\fR \fIDiagnostics,\fR \fIInitial\fR \fITransfer\fR \fIMode,\fR and \fIInquire\fR \fIOn\fR \fICopy.)\fR
.RE

Delete Selected Entry(s) (in \fIOps\fR menus) 
.RS
Deletes the selected entries.  A dialog pops up to enable the user to monitor the progress of the deletions.  The dialog contains a button for aborting the deletions.  (See user preferences \fIBeep\fR \fIWhen\fR \fIOps\fR \fIDone,\fR \fIDiagnostics,\fR and \fIInquire\fR \fIOn\fR \fIDelete.)\fR
.RE

Deselect All Entries (in \fISelect\fR menus) 
.RS
Deselect all the entries in the host's current directory.  (See user preference \fIDiagnostics.)\fR
.RE

Disconnect (in \fIConnect\fR menus) 
.RS
Close the currently connected host.  (See user preference \fIDiagnostics.)\fR
.RE

Display Directory (Long) (in \fIDir\fR menus) 
.RS
Pops up a dialog that displays the contents of the current directory in a scrollable list.  If supported by the host (and this is almost always the case), additional information about each directory entry is displayed, such as file length and access restrictions.  This display is automatically updated as the current directory changes.  This directory display does not support selecting entries or displaying the current selection.  \fIWarning:\fR Using this feature can increase network traffic, put an additional load on the remote host, and slow down interactivity.   (See user preference \fIDiagnostics.)\fR
.RE

Display Directory Path (in \fIDir\fR menus) 
.RS
Pops up a dialog that displays the current directory for that host.  It will be automatically updated as the current directory changes.  (See user preference \fIDiagnostics.)\fR
.RE

Display Directory (Table) (in \fIDir\fR menus) 
.RS
Pops up a dialog that displays the contents of the current directory in tabular form.  This dialog may be used to view and modify the directory's selected entries.  Entries may be selected/deselected either by clicking or by moving the cursor over the entries with the mouse button down.  Moving the mouse too quickly can cause some of the entries to be skipped.  If an entry is double-clicked, an attempt is made to change the current directory to that entry.  This display is automatically updated as the current directory changes.  (See user preference \fIDiagnostics.)\fR
.RE

Getting Started (in \fIHelp\fR menu) 
.RS
Describes how to get started using \fILLNL XFTP.\fR
.RE

LLNL XFTP Overview (in \fIHelp\fR menu) 
.RS
Gives a high-level description of \fILLNL XFTP.\fR
.RE

Make Directory (in \fIDir\fR menus) 
.RS
Pops up a dialog to prompt for the name of a directory to make in the current directory.  (See user preference \fIDiagnostics.)\fR
.RE

Move Selected Entry(s) (in \fIOps\fR menus) 
.RS
Move selected entries from the current directory to another directory on the same host.  This is similar to the UNIX \fImv\fR command, but without rename capability.  (See user preferences \fIBeep\fR \fIWhen\fR \fIOps\fR \fIDone,\fR and \fIDiagnostics.)\fR
.RE

Preferences (in \fIOptions\fR menu) 
.RS
Display the user preferences dialog.  See \fIUSER\fR \fIPREFERENCES\fR section for a description of user preferences.
.RE

Quit (in \fIFile\fR menu) 
.RS
Terminate \fILLNL XFTP.\fR
.RE

Rcopy (in \fIXfer\fR \fIOps\fR controls) 
.RS
Recursively transfers the selected entries according to the mode (\fIASCII\fR or \fIBinary)\fR specified in \fIXfer\fR \fIMode.\fR  If a selected entry is a directory, an attempt is made to transfer its entire directory subtree.  A dialog pops up to enable the user to monitor the progress of the transfers.  The dialog contains a button for aborting the transfers.  (See user preferences \fIBeep\fR \fIWhen\fR \fIOps\fR \fIDone,\fR \fIDiagnostics,\fR \fIInitial\fR \fIXfer\fR \fIMode,\fR and \fIInquire\fR \fIOn\fR \fICopy.)\fR
.RE

Recursively Delete Selected Entry(s) (in \fIOps\fR menus) 
.RS
Recursively deletes the selected entries.  A dialog pops up to enable the user to monitor the progress of the deletions.  The dialog contains a button for aborting the deletions.  \fIWarning:\fR Exercise extreme caution when using this command because it deletes entire directory subtrees.  To minimize the chance of an unintentional deletion, this menu item is greyed out unless the user preference \fIRecursive\fR \fIDelete\fR \fIEnabled\fR is enabled.  (See user preferences \fIBeep\fR \fIWhen\fR \fIOps\fR \fIDone,\fR \fIDiagnostics,\fR \fIInquire\fR \fIOn\fR \fIDelete,\fR and \fIRecursive\fR \fIDelete\fR \fIEnabled.)\fR
.RE

Rename Selected Entry(s) (in \fIOps\fR menus) 
.RS
Pop up a dialog to individually rename selected entries.  This is similar to the  UNIX \fImv\fR command except that the renamed entries cannot be moved to another directory.  (See user preference \fIDiagnostics.)\fR
.RE

Save Log (in \fILog\fR menu) 
.RS
Write the contents of the diagnostics window to a user-specified file.  The existing contents of the diagnostics window are not removed.
.RE

Save Preferences (in \fIOptions\fR menu) 
.RS
Save the current settings of the user preferences to a file.
.RE

Select All Entries (in \fISelect\fR menus) 
.RS
Select all the entries in the host's current directory.
.RE

Send Quoted Command (in \fIOps\fR menus)
.RS
Pops up a dialog to prompt for a "raw" command to send to the FTP server of the remote host.  Previously issued commands are cached and displayed in a scrolled list.  Double-clicking on a command in the list issues that command.  To have a command act on items selected in the host's directory list, use the quote placeholder (which by default is "<>") to represent a selected item.  For example, type "stage 1 <>" to send a STAGE command to the the remote host for each selected item.  The quote placeholder can changed via the user preferences.  (See user preferences \fIBeep\fR \fIWhen\fR \fIOps\fR \fIDone,\fR \fIDiagnostics,\fR and \fIQuote\fR \fIPlaceholder.)\fR
.RE

Use Wildcard (in \fISelect\fR menus) 
.RS
Pops up a dialog to prompt for a wildcard expression to use in selecting entries in the host's current directory list.  Previously referenced wildcard expressions are cached and displayed in a scrolled list.  Double-clicking on an item in the list applies that wildcard expression.  Single-clicking on an item in the list places the expression in a text field where it may be edited.  Choose the toggle item \fIReplace\fR \fIFilename\fR \fISelection\fR to cause the currently selected entries to be cleared before applying the wildcard.  Choose the toggle item \fIAdd\fR \fIto\fR \fIFilename\fR S\fIelection\fR to cause the entries selected by the wildcard to be added to the current selection.  (See user preference \fIInitial\fR \fIWildcard\fR \fIMode).\fR
.RE

Using Help (in \fIHelp\fR menu) 
.RS
Gives a description of the online help package.
.RE
.RE
.SH USER PREFERENCES
Selecting item \fIPreferences\fR in the \fIOptions\fR menu pops up a dialog that allows the user to configure \fILLNL XFTP\fR according to his/her preferences.  The user is presented with a number of configuration parameters, which are set by either toggling, sliding, or typing.  Click the \fIApply\fR button to cause the new values to take effect.  The \fIOK\fR button has the same effect as \fIApply,\fR but the dialog is also closed.  The \fICancel\fR button undoes changes made since \fIOK\fR or \fIApply\fR were last pressed.  The preferences can be preserved across \fILLNL XFTP\fR sessions in a text file named \fI.xftprc\fR in the user's home directory.  The user may alter the order the preferences are presented in the dialog by (1) terminating \fILLNL XFTP,\fR (2) using a text editor to change the order of lines in \fI.xftprc,\fR and (3) restarting \fILLNL XFTP.\fR

Add To Cache 
.RS
Specifies whether newly referenced items should be added to the directory, quoted command, wildcard, and host/user caches.  It is usually desirable to choose \fIYes.\fR  Choose \fINo\fR if referencing a series of seldom-referenced items that would clear the cache of your favorite entries.
.RE

Beep When Ops Done 
.RS
Specifes whether to beep when each set of deletion, move, quoted command, and file transfer operations completes.
.RE

Diagnostics
.RS
Specifies the level of diagnostics information to be written to the diagnostics log window.  Choose \fIQuiet\fR for error messages, only.  Choose \fINormal\fR for error messages and success messages.  Choose \fIVerbose\fR for error messages, success messages, and replies received from the FTP servers.  Choose \fIDebug\fR for error messages, success messages, commands sent to the FTP servers, replies received from the FTP servers, and other assorted diagnostics.
.RE

Directory Cache Size 
.RS
The maximum number of previously referenced directory paths cached per host.  The cache is preserved across \fILLNL XFTP\fR sessions.
.RE

Enhance Colors 
.RS
Speficies whether to "pretty up" some of the graphical elements (such as scrolled lists and text fields) by changing the normal background colors.  This preference has no effect on monochrome displays.  Choose \fIYes\fR to enhance the appearance, or \fINo\fR for the usual Motif look.
.RE

Host Cache Size 
.RS
The maximum number of hosts to cache items for.  The cache is preserved across \fILLNL XFTP\fR sessions.
.RE

Initial Logfile Name 
.RS
The default file name to be presented to the user in the "Save Log" dialog.
.RE

Initial Transfer Mode 
.RS
The default file transfer mode (\fIASCII\fR or \fIBinary).\fR
.RE

Initial Wildcard Mode 
.RS
The default mode of the "Use Wildcard" dialog.  Choose \fIReplace\fR to make "Replace Filename Selection" the default.  Choose \fIAdd\fR to make "Add to Filename Selection" the default.
.RE

Inquire On Copy 
.RS
Specifies whether to pop up a dialog that asks the user to confirm that the indicated transfers should take place.
.RE

Inquire On Delete 
.RS
Specifies whether to pop up a dialog that asks the user to confirm that the indicated deletions should take place.
.RE

Inquire On Move 
.RS
Specifies whether to pop up a dialog that asks the user to confirm that the indicated moves should take place.
.RE

Inquire On Quote 
.RS
Specifies whether to pop up a dialog that asks the user to confirm that the indicated commands should be sent.
.RE

Left Auto Local Login 
.RS
Specifies whether to automatically connect the left side to the local (client) host upon starting \fILLNL XFTP.\fR
.RE

Max Ftp Retries 
.RS
Specifies the maximum number of retries \fILLNL XFTP\fR will attempt if it receives a response from an FTP server that indicates the desired operation failed because of some temporary condition on the remote host.
.RE

Quote Cache Size 
.RS
The number of quoted commands to cache.
.RE

Quote Placeholder 
.RS
This is used as a placeholder in a quoted command to represent items selected in the directory list.  For example, the quoted command "stage 1 <>" will send a STAGE command to the remote host for each selected item.  The default value is "<>", but the placeholder can be set to any nonnull printable string.
.RE

Recursive Delete Enabled 
.RS
Specifies whether to enable the \fIRecursively\fR \fIDelete\fR \fISelected\fR \fIEntry(s)\fR item in the \fIOps\fR menus.  Choose \fINo\fR to help prevent accidental recursive deletions.
.RE

Right Auto Local Login 
.RS
Specifies whether to automatically connect the right side to the local (client) host upon starting \fILLNL XFTP.\fR
.RE

Sort Caches 
.RS
Specifies whether to sort (by ASCII-collating sequence) cached items when they are displayed in dialogs.  If \fIYes,\fR then sort.  If \fINo,\fR then the most recently referenced items are placed at the top of the list.
.RE

Store Unique 
.RS
Specifies whether existing sink files are to be renamed before file transfer occurs.  If \fIYes\fR then the existing sink file is typically renamed by appending a "." (period) followed by an integer between 1 and 99.
.RE

Symbols On Dir Entries 
.RS
Specifies whether to append single characters to directory entries in order to distinguish their types.  If \fIYes(Unsafe)\fR is chosen, "/" is appended to directories, "*" is appended to executables, "@" is appended to symbolic links, and "=" is appended to AF_UNIX address family sockets.  The "Yes" option is considered to be unsafe because some FTP servers do not support this feature and may give unpredictable results.  (Most UNIX hosts support this option.)  Furthermore, if you are referencing a directory or directory entry whose name ends with one of the special characters, you will need to select \fINo(Safe).\fR  When in doubt, select \fINo(Safe).\fR  One further note: use of this feature can dramatically degrade interactivity.
.RE

Use Last Dir At Login 
.RS
Specifies whether to automatically enter the most recently referenced directory after connecting to a host.  If this option is requested, but is not possible to perform (e.g., because the directory no longer exists), an error message will be generated, and your home directory will be entered.  \fINote:\fR This mechanism attempts to enter the last directory referenced on the host, regardless of whether it is another user's directory.
.RE

User Cache Size 
.RS
The number of user names to cache (for remote hosts).  The cache is preserved across \fILLNL XFTP\fR sessions.
.RE

Wildcard Cache Size 
.RS
The number of wildcard expressions to cache.  The cache is preserved across \fILLNL XFTP\fR sessions.
.RE
.RE
.SH WIDGET HIERARCHY
Most of \fILLNL XFTP's\fR widget heirarchy is listed here so that the knowledgeable user can use the X resource mechanism to customize \fILLNL XFTP.\fR  Widget names are followed by their class names in parentheses.  A question mark is displayed if the widget's name is not known.  \fILLNL XFTP's\fR classname is \fIXFtp.\fR
	

\fIMain\fR \fIWindow\fR 
.RS
.nf

main  (XmMainWindow)
    mainMenuBar (XmRowColumn)
        File (XmCascadeButton)
        ? (XmMenuShell)
            pulldown (XmRowColumn)
        Edit (XmCascadeButton)	
        ? (XmMenuShell)
            pulldown (XmRowColumn)
        Options (XmCascadeButton)
        ? (XmMenuShell)
            pulldown (XmRowColumn)
        Help (XmCascadeButton)
        ? (XmMenuShell) 
            pulldown (XmRowColumn)
    pane  (XmPanedWindow)
        topForm  (XmForm)
            leftHost  (XmForm)
                hostName  (XmLabel)
                hostMenuBar  (XmRowColumn)
                    Connect  (XmCascadeButton)
                    ?  (XmMenuShell)
                        pulldown  (XmRowColumn)
                    Dir  (XmCascadeButton)
                    ?  (XmMenuShell)
                        pulldown  (XmRowColumn)
                    Select  (XmCascadeButton)
                    ?  (XmMenuShell)
                        pulldown  (XmRowColumn)
                    Ops  (XmCascadeButton)
                    ?  (XmMenuShell)
                        pulldown  (XmRowColumn)
                dirNameForm  (XmForm)
                    dirName  (XmRowColumn)
                        ?  (XmCascadeButtonGadget)
                    ?  (XmMenuShell)
                        dirNameMenu  (XmRowColumn)
                            ?  (XmPushButtonGadget)
                                       . . .
                            ?  (XmPushButtonGadget)
                dirListSW  (XmScrolledWindow)
                    dirList  (XmList)
            rightHost  (XmForm)
                hostName  (XmLabel)
                hostMenuBar  (XmRowColumn)
                    Connect  (XmCascadeButton)
                        ?  (XmMenuShell)
                            pulldown  (XmRowColumn)
                        Dir  (XmCascadeButton)
                        ?  (XmMenuShell)
                            pulldown  (XmRowColumn)
                        Select  (XmCascadeButton)
                        ?  (XmMenuShell)
                            pulldown  (XmRowColumn)
                        Ops  (XmCascadeButton)
                        ?  (XmMenuShell)
                            pulldown  (XmRowColumn)
                    dirNameForm  (XmForm)
                        dirName  (XmRowColumn)
                            ?  (XmCascadeButtonGadget)
                        ?  (XmMenuShell)
                            dirNameMenu  (XmRowColumn)
                                ?  (XmPushButtonGadget)
                                        . . .
                                ?  (XmPushButtonGadget)
                    dirListSW  (XmScrolledWindow)
                        dirList  (XmList)
                centerControls  (XmForm)
                    xferModeFrame  (XmFrame)
                        xferMode  (XmRowColumn)
                            ascii  (XmToggleButtonGadget)
                    xferModeLabel  (XmLabel)
                    xferOpsFrame  (XmFrame)
                        xferOps  (XmRowColumn)
                            copyButton  (XmPushButton)
                            rCopyButton  (XmPushButton)
                    xferOpsLabel  (XmLabel)
                    logo  (XmLabelGadget)
            bottomForm  (XmForm)
                resultFlagFrame  (XmFrame)
                    resultFlag  (XmLabel)
                logSW  (XmScrolledWindow)
                    log  (XmText)    
.RE

\fIAbort\fR \fIin\fR \fIProgress\fR \fIDialog\fR 
.RS
.nf
?  (XmDialogShell)
    abort  (XmForm)
        abortMessage  (XmLabel)
.RE

\fIAbout\fR \fIXFTP\fR \fIDialog\fR 
.RS
.nf
about  (XmSelectionBox)
    form  (XmForm)
		frame  (XmFrame)
			startup  (XmLabel)
.RE

\fIAccount\fR \fIDialog\fR 
.RS
.nf
account  (XmSelectionBox)
.RE

\fIChange\fR \fIDirectory\fR \fIDialog\fR 
.RS
.nf
changeDir  (XmSelectionBox)
.RE

\fIFile\fR \fITransfer\fR \fIMonitor\fR \fIDialog\fR 
.RS
.nf
monitor  (XmSelectionBox)
    controlArea  (XmForm)
        nameLabel  (XmLabel)
        name  (XmLabel)
        lengthLabel  (XmLabel)
        length  (XmLabel)
        bytesMovedLabel  (XmLabel)
        bytesMove  (XmLabel)
        scale  (XmScale)
.RE

\fIHelp\fR \fIDialog\fR 
.RS
.nf
?  (XmDialogShell)
    help  (XmForm)
        pane  (XmPanedWindow)
            controlArea  (XmForm)
                topic  (XmLabel)
                textSW   (XmScrolledWindow)
                    text  (XmText)
.RE

\fIInformation\fR \fIDialog\fR 
.RS
.nf
information  (XmMessageBox)
.RE

\fILeft\fR \fIDirectory\fR \fIPath\fR \fIDialog\fR 
.RS
.nf
leftDirPath  (XmSelectionBox)
.RE

\fILeft\fR \fILong\fR \fIDirectory\fR \fIList\fR \fIDialog\fR 
.RS
.nf
?  (XmDialogShell)
    leftDirLong  (XmForm)
        dirListSW  (XmScrolledWindow)
            dirList  (XmText)
        separator  (XmPushButton)
        closeButton  (XmPushButton)
        helpButton  (XmPushButton)
.RE

\fILeft\fR \fITabular\fR \fIDirectory\fR \fIList\fR \fIDialog\fR 
.RS
.nf
?  (XmDialogShell)
    leftDirTable  (XmForm)
        scrolledWindow  (XmScrolledWindow)
            drawingArea  (XmDrawingArea)
        separator  (XmSeparator)
        closeButton  (XmPushButton)
        helpButton  (XmPushButton)
.RE

\fIMake\fR \fIDialog\fR 
.RS
.nf
makeDir  (XmSelectionBox)
.RE

\fIMonitor\fR \fIDialog\fR 
.RS
.nf
mpMonitor  (XmSelectionBox)
    form  (XmForm)
        pathLabel  (XmLabel)
        path  (XmLabel)
.RE

\fIMove\fR \fIDialog\fR 
.RS
.nf
move  (XmSelectionBox)
    form  (XmForm)
        instruction  (XmLabel)
        dirNameForm  (XmForm)
            dirName  (XmRowColumn)
                ?  (XmCascaseButtonGadget)
            ? (XmMenuShell)
                dirNameMenu  (XmRowColumn)
                    ?  (XmPushButtonGadget)
                              . . .
                    ?  (XmPushButtonGadget)
        dirListSw  (XmScrolledWindow)
            dirList  (XmList)
.RE

\fIPassword\fR \fIDialog\fR 
.RS
.nf
password  (XmSelectionBox)
.RE

\fIPreferences\fR \fIDialog\fR 
.RS
.nf
?  (XmShellDialog)
    prefs  (XmForm)
        actionArea  (XmForm)
            okButton  (XmPushButton)
        separator  (XmSeparator)
        scrolledWindow  (XmScrolledWindow)
            rowColumn  (XmRowColumn)
                frame  (XmFrame)
                    form  (XmForm)
                        label  (XmLabel)
                        --------------------------------------
                        textField  (XmTextField)
                        --------------------------------------
                        radioBoxFrame  (XmFrame)
                            radioBox  (XmRowColumn)
                                ?  (XmToggleButtonGadget)
                                           . . .
                                ?  (XmToggleButtonGadget)
                        --------------------------------------
                        scale  (XmScale)
                        --------------------------------------
.RE

\fIQuestion\fR \fIDialog\fR 
.RS
question  (XmMessageBox)
.RE

\fIQuote\fR \fIDialog\fR 
.RS
.nf
quote  (XmSelectionBox)
    form  (XmForm)
        listLabel  (XmLabel)
        listSW  (XmScrolledWindow)
            list  (XmList)
        textLabel  (XmLabel)
        text  (XmTextField)
        warningLabel  (XmLabel)
        warningFrame  (XmFrame)
            warning  (XmRowColumn)
            warningMsg1  (XmLabel)
            warningMsg2  (XmLabel)
            warningMsg3  (XmLabel)
.RE

\fIRemote\fR \fIConnect\fR \fIDialog\fR 
.RS
.nf
rConnect  (XmSelectionBox)
    form  (XmForm)
        hostListLabel  (XmLabel)
        hostListSW  (XmScrolledWindow)
            hostList  (XmList)
        hostNameLabel  (XmLabel)
        hostName  (XmTextField)
        userNameLabel  (XmLabel)
        userName  (XmTextField)
.RE

\fIRename\fR \fIDialog\fR 
.RS
.nf
rename (XmSelectionBox)
    form  (XmForm)
        oldNameLabel  (XmLabel)
        oldName  (XmLabel)
        newNameLabel  (XmLabel)
        newName  (XmTextField)
.RE

\fIRight\fR \fIDirectory\fR \fIPath\fR \fIDialog\fR 
.RS
rightDirPath  (XmSelectionBox)
.RE

\fIRight\fR \fILong\fR \fIDirectory\fR \fIList\fR \fIDialog\fR 
.RS
.nf
?  (XmDialogShell)
    rightDirLong  (XmForm)
        dirListSW  (XmScrolledWindow)
            dirList  (XmText)
        separator  (XmPushButton)
        closeButton  (XmPushButton)
        helpButton  (XmPushButton)
.RE

\fIRight\fR \fITabular\fR \fIDirectory\fR \fIList\fR \fIDialog\fR 
.RS
.nf
?  (XmDialogShell)
    rightDirTable  (XmForm)
        scrolledWindow  (XmScrolledWindow)
            drawingArea  (XmDrawingArea)
        separator  (XmSeparator)
        closeButton  (XmPushButton)
        helpButton  (XmPushButton)
.RE

\fISave\fR \fIDiagnostics\fR \fILog\fR \fIDialog\fR 
.RS
saveLog  (XmSelectionBox)
.RE

\fIVerify\fR \fIDialog\fR 
.RS
.nf
verify  (XmSelectionBox)
    form  (XmForm)
        label  (XmLabel)
        listSW  (XmScrolledWindow)
            list  (XmList)
.RE

\fIWildcard\fR \fIDialog\fR 
.RS
.nf
wildcard  (XmSelectionBox)
    form  (XmForm)
        listLabel  (XmLabel)
        listSW  (XmScrolledWindow)
            list  (XmList)
        textLabel  (XmTextField)
        text  (XmTextField)
        radioBoxFrame  (XmFrame)
            radioBox  (XmRowColumn)
                replaceToggle  (XmToggleButtonGadget)
                addToggle  (XmToggleButtonGadget)
.RE
.RE
.RE
.SH LIMITATIONS
There are some things beyond our control that might cause \fILLNL XFTP\fR to work incorrectly:

\fILLNL XFTP\fR might not work with some old X servers.  For example, some older OpenWindows servers might dump core.  MacX fans should use nothing older than version 1.1.7b.

Old, buggy versions of Motif can cause weirdness.

Out-of-spec FTP servers can cause untold grief.  (Most Unix-based servers work correctly.)

Third-party file transfers will not work unless at least one of the remote FTP servers supports the PASV (passive) command.
.RE
.SH FILES
.nf
$HOME/.xftpcache   cache file
$HOME/.xftprc      user preferences
XFtp.color         application defaults file for color displays
XFtp.mono          application defaults file for monochrome displays
.SH AVAILABILITY
The sources for \fILLNL XFTP\fR are tarred and compressed, and are available via anonymous ftp:
.nf

                   IP Address:  phoenix.ocf.llnl.gov
                    Directory:  /llnlxftp
.RE
.RE
.SH SUPPORT
Because our resources are limited, we will not be able to give individual assistance in building and using \fILLNL XFTP\fR.  However, your comments, suggestions and bug reports are valuable in helping us determine how to best direct our efforts.  Our email address is
.nf

                           llnlxftp@llnl.gov

.RE
.SH COPYRIGHT
(c) 1993.  The Regents of the University of California.  All rights reserved.

This work was produced at the University of California, Lawrence Livermore National Laboratory (UC LLNL) under contract no.  W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy (DOE) and The Regents of the University of California (University) for the operation of UC LLNL.  Copyright is reserved to the University for purposes of controlled dissemination, commercialization through formal licensing, or other disposition under terms of Contract 48; DOE policies, regulations and orders; and U.S. statutes.  The rights of the Federal Government are reserved under Contract 48 subject to the restrictions agreed upon by the DOE and University.

                           DISCLAIMER

This software was prepared as an account of work sponsored by an agency of the United States Government.  Neither the United States Government nor the University of California nor any of their employees, makes any warranty, express or implied, or assumes any liability or responsibility for the accuracy, completeness, or usefulness of any information, apparatus, product, or process disclosed, or represents that its specific commercial products, process, or service by trade name, trademark, manufacturer, or otherwise, does not necessarily constitute or imply its endorsement, recommendation, or favoring by the United States Government or the University of California. The views and opinions of the authors expressed herein do not necessarily state or reflect those of the United States Government or the University of California, and shall not be used for advertising or product endorsement purposes.

Permission to use, copy, modify and distribute this software and its documentation for any non-commercial purpose, without fee, is hereby granted, provided that the above copyright notice and this permission notice appear in all copies of the software and supporting documentation, and that all UC LLNL identification in the user interface remain unchanged.  The title to copyright LLNL XFTP shall at all times remain with The Regents of the University of California and users agree to preserve same. Users seeking the right to make derivative works with LLNL XFTP for commercial purposes may obtain a license from the Lawrence Livermore National Laboratory's Technology Transfer Office, P.O. Box 808, L-795, Livermore, CA 94550.

.SH SEE ALSO
ftpd(8C)
.RE
.SH AUTHOR
.nf
     Neale G. Smith, Lawrence Livermore National Laboratory
.RE



