/*
 * monSocks.h --
 *
 *      This header file describes the externally-visible facilities
 *      of Monitor daemon which are exported to Socks5 server.
 *
 * Copyright(C) 1995, 1996 NEC Corporation. All rights reserved.
 * This is a genuine component of Socks5Toolkit(TM).
 *
 * $Header: /insg/project/socks/s5watch/include/monSocks.h,v 1.2 1997/08/26 22:04:43 miked Exp $
 * $Log: monSocks.h,v $
 * Revision 1.2  1997/08/26 22:04:43  miked
 * Defined some vars as register to improve performance.
 *
 * Revision 1.1.1.1  1996/08/30  02:43:49  miked
 * Initial version.
 *
 * Revision 1.3  1996/07/30  21:01:02  miked
 * Yet another copyright notice.
 *
 * Revision 1.2  1996/07/09  23:57:50  miked
 * Added new copyright notice.
 *
 * Revision 1.1.1.1  1996/07/08  15:09:43  miked
 * Initial version for Socks5 API.
 */

#ifndef _H_MONSOCKS
#define _H_MONSOCKS

#include "monAPI.h"

/*
 *----------------------------------------------------------------------
 *    C O N S T A N T S
 *----------------------------------------------------------------------
 */

/*
 * Type of IPC allowed between Socks5 server and Monitor.
 */

#define S5_MON_PIPE       1           /* Named pipe (FIFO) */
#define S5_MON_MEM        2           /* Shared memory */

/*
 *----------------------------------------------------------------------
 *    P R O C E D U R E S
 *----------------------------------------------------------------------
 */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Open/close a data transfer channel from Socks5 to Monitor.
 */

EXTERN int
S5SocksMonOpen _ANSI_ARGS_((
    CONST char FAR*      name,       /* IN  -- Name */
    int                  ipcType,    /* IN  -- Type of IPC */
    S5MonHandle FAR*     handlePtr   /* OUT -- Opaque handle */
));

EXTERN int
S5SocksMonClose _ANSI_ARGS_((
    S5MonHandle          handle       /* IN -- Opaque handle */
));


/*
 * Put Socks5 link information into Monitor table.
 */

EXTERN int
S5SocksMonPut _ANSI_ARGS_((
    S5MonHandle          handle,      /* IN -- Opaque handle */
    register unsigned int state,      /* IN -- State of Socks5 link */
    register S5LinkInfo FAR* linkPtr, /* IN -- Pointer to Socks5 link info */
    unsigned int         optDataLen,  /* IN -- Length of optional data */ 
    CONST VOID FAR*      optDataPtr,  /* IN -- Pointer to optional data */
    int                  socksErr,    /* IN -- Socks5 error */
    CONST char FAR*      socksErrMsg  /* IN -- Socks error message */
));

#ifdef __cplusplus
}
#endif

#endif /* _H_MONSOCKS */
