#ifndef SIGFIX_H
#define SIGFIX_H

typedef RETSIGTYPE (*Sig_t)P((void));

#ifdef HAVE_SIGACTION
typedef sigset_t Sigset_t;

#ifndef DONT_NEED_SIGNAL
static inline Sig_t Signal(int signo, RETSIGTYPE(*func)()) {
    struct sigaction sa, oa;

    sa.sa_flags   = 0;
    sa.sa_handler = func;
    sigemptyset(&sa.sa_mask);
    sigaction(signo, &sa, &oa);
    return (Sig_t)oa.sa_handler;
}
#endif

#ifndef DONT_NEED_SIGBLOCK
static inline Sigset_t SigBlock(int signo) {
    sigset_t set;
    sigemptyset(&set);
    sigaddset(&set, signo);
    sigprocmask(SIG_BLOCK, &set, NULL);

    return set;
}
#endif

#ifndef DONT_NEED_SIGUNBLOCK
static inline void SigUnblock(Sigset_t set) {
    sigprocmask(SIG_UNBLOCK, &set, NULL);
}
#endif

#ifndef DONT_NEED_SIGPAUSE
static inline void SigPause(void) {
    sigset_t set;
    sigemptyset(&set);
    sigsuspend(&set);
}
#endif

#ifndef DONT_NEED_SIGPENDING
static inline int SigPending(int signo) {
    sigset_t set;
    sigpending(&set);
    return sigismember(&set, signo);
}
#endif
#else
typedef int Sigset_t;
		       
#ifndef DONT_NEED_SIGNAL
static inline Sig_t Signal(int signo, RETSIGTYPE(*func)()) {
    return (Sig_t)signal(signo, func);
}
#endif

#ifndef DONT_NEED_SIGBLOCK
static inline Sigset_t SigBlock(int signo) {
    return sigblock(signo);
}
#endif

#ifndef DONT_NEED_SIGUNBLOCK
static inline void SigUnblock(Sigset_t mask) {
    sigsetmask(mask);
}
#endif

#ifndef DONT_NEED_SIGPAUSE
static inline void SigPause(void) {
    sigpause(0);
}
#endif

#ifndef DONT_NEED_SIGPENDING
static inline int SigPending(int signo) {
     return 0;
}
#endif
#endif    
#endif
