/* cfuserid.c */

/* Copyright 1997 by Eberhard Mattes <mattes@azu.informatik.uni-stuttgart.de>
   Donated to the public domain.  No warranty.

   1997-01-04 Initial version
   1997-04-05 Reorganize library */

#include <stdlib.h>
#include <syslog.h>
#include "firewall.h"
#include "libemfw.h"

int config_userid (Cfg *confp, int do_set)
{
  Cfg *cf;
  int uid = -1;

  if ((cf = cfg_get ("userid", confp)) != (Cfg *)0) 
    {
      if (cf->argc != 1)
	{
	  syslog (LLEV, "fwtkcfgerr: userid must have one parameter, line %d",cf->ln);
	  exit (1);
	}
      if ((uid = mapuid (cf->argv[0])) == -1)
	{
	  syslog (LLEV, "fwtkcfgerr: cannot map %s to uid", cf->argv[0]);
	  exit (1);
	}
    }
  if (do_set && uid != -1 && setuid (uid) != 0)
    {
      syslog (LLEV, "fwtksyserr: cannot setuid %d: %m", uid);
      exit (1);
    }
  return uid;
}
