/*
 * dsock.c - PTX socket processing functions for lsof
 */


/*
 * Copyright 1995 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1995 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dsock.c,v 1.7 97/10/23 15:53:08 abe Exp $";
#endif


#define	TCPSTATES		/* activate tcpstates[] */
#include "lsof.h"


_PROTOTYPE(static unsigned long get_qsize,(struct queue *qp));


/*
 * get_qsize() - get streams queue size
 */

static unsigned long
get_qsize(qp)
	struct queue *qp;		/* queue head pointer */
{
	int lm;
	struct queue q;
	unsigned long rv = (unsigned long)0;

	for (lm = 0; qp && (lm < 100); lm++, qp = q.q_next) {
	    if (kread((KA_T)qp, (char *)&q, sizeof(q)))
		return(rv);
	    rv += (unsigned long)q.q_count;
	}
	return(rv);
}


/*
 * print_tcptpi() - print TCP/TPI info
 */

void
print_tcptpi(nl)
	int nl;				/* 1 == '\n' required */
{
	char buf[128];
	char *cp = (char *)NULL;
	int ps = 0;
	int s;

	if (Ftcptpi & TCPTPI_STATE) {
	    s = Lf->lts.state.i;
	    switch (Lf->lts.type) {
	    case 0:				/* TCP */
		if (s < 0 || s >= TCP_NSTATES) {
		    (void) printf("UNKNOWN_TCP_STATE_%d", s);
		    cp = buf;
		} else
		    cp = tcpstates[s];
		break;
	    case 1:				/* TPI */
		switch (s) {
		case TS_UNBND:
		    cp = "TS_UNBND";
		    break;
		case TS_WACK_BREQ:
		    cp = "TS_WACK_BREQ";
		    break;
		case TS_WACK_UREQ:
		    cp = "TS_WACK_UREQ";
		    break;
		case TS_IDLE:
		    cp = "TS_IDLE";
		    break;
		case TS_WACK_OPTREQ:
		    cp = "TS_WACK_OPTREQ";
		    break;
		case TS_WACK_CREQ:
		    cp = "TS_WACK_CREQ";
		    break;
		case TS_WCON_CREQ:
		    cp = "TS_WCON_CREQ";
		    break;
		case TS_WRES_CIND:
		    cp = "TS_WRES_CIND";
		    break;
		case TS_WACK_CRES:
		    cp = "TS_WACK_CRES";
		    break;
		case TS_DATA_XFER:
		    cp = "TS_DATA_XFER";
		    break;
		case TS_WIND_ORDREL:
		    cp = "TS_WIND_ORDREL";
		    break;
		case TS_WREQ_ORDREL:
		    cp = "TS_WREQ_ORDREL";
		    break;
		case TS_WACK_DREQ6:
		    cp = "TS_WACK_DREQ6";
		    break;
		case TS_WACK_DREQ7:
		    cp = "TS_WACK_DREQ7";
		    break;
		case TS_WACK_DREQ9:
		    cp = "TS_WACK_DREQ9";
		    break;
		case TS_WACK_DREQ10:
		    cp = "TS_WACK_DREQ10";
		    break;
		case TS_WACK_DREQ11:
		    cp = "TS_WACK_DREQ11";
		    break;
		default:
		    (void) sprintf(buf, "UNKNOWN_TPI_STATE_%d", s);
		    cp = buf;
		}
	    }
	    if (cp) {
		if (Ffield)
		    (void) printf("%cST=%s%c", LSOF_FID_TCPTPI, cp, Terminator);
		else {
		    putchar('(');
		    (void) fputs(cp, stdout);
		}
		ps++;
	    }
	}

# if	defined(HASTCPTPIQ)
	if (Ftcptpi & TCPTPI_QUEUES) {
	    if (Lf->lts.rqs) {
		if (Ffield)
		    putchar(LSOF_FID_TCPTPI);
		else {
		    if (ps)
			putchar(' ');
		    else
			putchar('(');
		}
		(void) printf("QR=%lu", Lf->lts.rq);
		if (Ffield)
		    putchar(Terminator);
		ps++;
	    }
	    if (Lf->lts.sqs) {
		if (Ffield)
		    putchar(LSOF_FID_TCPTPI);
		else {
		    if (ps)
			putchar(' ');
		    else
			putchar('(');
		}
		(void) printf("QS=%lu", Lf->lts.sq);
		if (Ffield)
		    putchar(Terminator);
		ps++;
	    }
	}
# endif	/* defined(HASTCPTPIQ) */

# if	defined(HASTCPTPIW)
	if (Ftcptpi & TCPTPI_WINDOWS) {
	    if (Lf->lts.rws) {
		if (Ffield)
		    putchar(LSOF_FID_TCPTPI);
		else {
		    if (ps)
			putchar(' ');
		    else
			putchar('(');
		}
		(void) printf("WR=%lu", Lf->lts.rw);
		if (Ffield)
		    putchar(Terminator);
		ps++;
	    }
	    if (Lf->lts.wws) {
		if (Ffield)
		    putchar(LSOF_FID_TCPTPI);
		else {
		    if (ps)
			putchar(' ');
		    else
			putchar('(');
		}
		(void) printf("WW=%lu", Lf->lts.ww);
		if (Ffield)
		    putchar(Terminator);
		ps++;
	    }
	}
# endif	/* defined(HASTCPTPIW) */

	if (!Ffield && ps)
	    putchar(')');
	if (nl)
	    putchar('\n');
}


/*
 * process_socket() - process socket
 */

void
process_socket(pn, fam, ipid, pa)
	char *pn;			/* protocol name */
	int fam;			/* address family (AF_*) */
	int ipid;			/* IP protocol ID (IPPROTO_*) &/
	KA_T pa;			/* kernel PCB address */
{
	char *cp, dev_ch[32];
	struct in_addr *fa = (struct in_addr *)NULL;
	int fp, lp;
	struct in_addr *la = (struct in_addr *)NULL;
	struct inpcb pcb;
	struct queue q;
	struct stdata sd;
	struct tcpcb tcb;
	unsigned long urs, uws;

	Namech[0] = '\0';
	if (!Fsize)
	    Lf->off_def = 1;

/*
 * Enter protocol name and address.
 */
	(void) strcpy(Lf->iproto, pn);
	Lf->inp_ty = 2;
	if (pa) {
	    (void) sprintf(dev_ch, "0x%08x", pa);
	    enter_dev_ch(dev_ch);
	}
/*
 * Process protocols.
 */
	switch (fam) {
	case AF_INET:
	    (void) strcpy(Lf->type, "inet");
	    if (Fnet)
		Lf->sf |= SELNET;
	/*
	 * Read IP protocol control block.
	 */
	    if (pa) {
		if (kread(pa, (char *)&pcb, sizeof(pcb))) {
		    (void) sprintf(Namech, "%s: can't read PCB from %#x",
			pn, pa);
		    enter_nm(Namech);
		    return;
		}
	    } else {
		(void) sprintf(Namech, "%s: no protocol control block", pn);
		enter_nm(Namech);
		return;
	    }
	    switch(ipid) {
	    case IPPROTO_ICMP:
	    case IPPROTO_TCP:
	    case IPPROTO_UDP:
		la = (struct in_addr *)&pcb.inp_laddr;
		lp = (int)ntohs(pcb.inp_lport);

#if	defined(HASINADDRSTR)
		if (pcb.inp_faddr.s_addr != INADDR_ANY || pcb.inp_fport != 0)
#else	/* !defined(HASINADDRSTR) */
		if (pcb.inp_faddr != INADDR_ANY || pcb.inp_fport != 0)
#endif	/* defined(HASINADDRSTR) */

		{
		    fa = (struct in_addr *)&pcb.inp_faddr;
		    fp = (int)ntohs(pcb.inp_fport);
		}
		if (fa || la)
		    (void) ent_inaddr(la, lp, fa, fp);
		if (ipid == IPPROTO_TCP && pcb.inp_ppcb
		&&  kread((KA_T)pcb.inp_ppcb, (char *)&tcb, sizeof(tcb)) == 0)
		{
		    if (!Fsize) {
			if (Lf->access == 'r')
			    Lf->off = (unsigned long)tcb.rcv_nxt;
			else
			    Lf->off = (unsigned long)tcb.snd_nxt;
			Lf->off_def = 1;
		    } else {
			if (Lf->access == 'r')
			    Lf->sz = (SZOFFTYPE)tcb.tp_rcv.tp_cc;
			else if (Lf->access == 'w')
			    Lf->sz = (SZOFFTYPE)tcb.tp_snd.tp_cc;
			else
			    Lf->sz = (SZOFFTYPE)(tcb.tp_rcv.tp_cc
				   + tcb.tp_snd.tp_cc);
			Lf->sz_def = 1;
		    }

#if	defined(HASTCPTPIQ)
		    Lf->lts.rq = (unsigned long)tcb.tp_rcv.tp_cc;
		    Lf->lts.sq = (unsigned long)tcb.tp_snd.tp_cc;
		    Lf->lts.rqs = Lf->lts.sqs = 1;
#endif	defined(HASTCPTPIQ)

		    Lf->lts.type = 0;
		    Lf->lts.state.i = (int)tcb.t_state;
		} else if (ipid == IPPROTO_UDP) {
		    Lf->lts.type = 1;
		    Lf->lts.state.i = (int)pcb.inp_state;
		    if (Fsize
		    &&  pcb.inp_queue
		    &&  kread((KA_T)pcb.inp_queue, (char *)&q, sizeof(q)) == 0
		    &&  q.q_str
		    &&  kread((KA_T)q.q_str, (char *)&sd, sizeof(sd)) == 0)
		    {

#if	PTXV>=441
			urs = get_qsize(sd.sd_rdq);
#else	/* PTXV<441 */
			urs = (unsigned long)q.q_count;
#endif	/* PTXV>=441 */

			uws = get_qsize(sd.sd_wrq);
			if (Lf->access == 'r')
			    Lf->sz = (SZOFFTYPE)urs;
			else if (Lf->access == 'w')
			    Lf->sz = (SZOFFTYPE)uws;
			else
			    Lf->sz = (SZOFFTYPE)(urs + uws);
			Lf->sz_def = 1;
		    }
		}
		break;
	    default:
		(void) sprintf(Namech,
		    "%s: unknown IP ID (%d) for AF_INET family", pn, ipid);
	    }
	    break;
	default:
	    (void) strcpy(Lf->type, "sock");
	    (void) sprintf(Namech, "%s: unknown family (%d) for IP ID %d",
		pn, fam, ipid );
	}
	if (Namech[0])
	    enter_nm(Namech);
}


#if	PTXV>=421
/*
 * process_unix_socket() - process UNIX domain socket
 */

void
process_unix_socket(s, u)
	struct socket *s;		/* local socket copy */
	struct unpcb *u;		/* UNIX protocol control block */
{
	struct socket cs;
	struct unpcb cu;
	char dev_ch[32];

	if (Funix)
	    Lf->sf |= SELUNX;
	(void) strcpy(Lf->type, "unix");
	(void) sprintf(dev_ch, "0x%08x", s->so_pcb);
	enter_dev_ch(dev_ch);
	if (u->unp_ino) {
	    Lf->inode = (unsigned long)u->unp_ino;
	    Lf->inp_ty = 1;
	}
	if (Foffset)
	    Lf->off_def = 1;
	else {
	    Lf->sz = (SZOFFTYPE)u->unp_cc;
	    Lf->sz_def = 1;
	}
	if (!u->unp_conn
	||  kread((KA_T)u->unp_addr, (char *)&cu, sizeof(cu))
	||  !cu.unp_socket
	||  kread((KA_T)cu.unp_socket, (char *)&cs, sizeof(cs))
	||  !cs.so_pcb)
	    return;
	(void) sprintf(Namech, "->%08x", cs.so_pcb);
}
#endif	/* PTXV>=421 */
