IDEAL

MODEL USE16 LARGE, C

EXTRN xmsEntry:FAR PTR PROC

EXTRN PASCAL SYSTEMREQUEST:PROC
EXTRN PASCAL REQUESTCONFIRM:PROC
EXTRN PASCAL TRANSMITCONFIRM:PROC
EXTRN PASCAL RECEIVELOOKAHEAD:PROC
EXTRN PASCAL INDICATIONCOMPLETE:PROC
EXTRN PASCAL RECEIVECHAIN:PROC
EXTRN PASCAL STATUS:PROC
EXTRN allocStack:PROC
EXTRN freeStack:PROC

CODESEG

; *ALL* interrupt threads come through this macro.
MACRO callback callbackProc,callbackProcGlue,argsSize
PUBLIC &callbackProcGlue
PROC &callbackProcGlue FAR

	; Save off the registers.
	PUSHF
	PUSHAD
	PUSH es
	PUSH ds

	; Load DS.
	MOV  ax,DGROUP
	MOV  ds,ax

	; Get and install a stack.
	CALL allocStack

	; Save off the old stack in other regs.
	MOV  bx,ss
	MOV  cx,sp

	; Install the new one.
	MOV  ss,dx
	MOV  sp,ax

	; Save the old one on to the new stack.
	PUSH bx
	PUSH cx

	; Allocate the space for the arguments on the stack.
	SUB  sp,&argsSize

	; Set up the destination for the move.
	MOV  ax,ss
	MOV  es,ax
	MOV  di,sp

	; Set up the source for the move.
	MOV  ds,bx
	MOV  si,cx
	ADD  si,4 + 6 + 32

	; Move the arguments to the stack.
	MOV  cx,&argsSize
	SHR  cx,1
	CLD
	REP MOVSW

	; Set my data segment again.
	MOV  ax,DGROUP
	MOV  ds,ax

	; Call the real callback.
	CALL &callbackProc

	; We don't deallocate the arguments because this was Pascal calling conventions.

	; Pop off the old stack.
	POP  di
	POP  si

	; Save off the current allocated stack.
	MOV  bx,ss
	MOV  cx,sp

	; Restore the old stack.
	MOV  ss,si
	MOV  sp,di

	; Save the return code.
	PUSH ax 

	; Free the stack. Push the pointer to it.
	PUSH bx
	PUSH cx

	CALL freeStack

	; Release the argument to freeStack().
	ADD  sp,4

	; Get the return code back.
	POP  ax

	; Get a pointer to ax on the stack.
	ADD  di,32

	; Be careful to restore eax with the return value.
	MOV  [WORD PTR ss:di],ax

	POP  ds
	POP  es
	POPAD
	POPF

	RET &argsSize
ENDP &callbackProcGlue
ENDM callback

; Define all of the callbacks for the NDIS procs.
; callback <Pascal convention callback>,
;          <name of the glue routine>,
;          <size of arguments>

callback SYSTEMREQUEST,systemRequestGlue,14
callback REQUESTCONFIRM,requestConfirmGlue,12
callback TRANSMITCONFIRM,transmitConfirmGlue,10
callback RECEIVELOOKAHEAD,receiveLookaheadGlue,16
callback INDICATIONCOMPLETE,indicationCompleteGlue,4
callback RECEIVECHAIN,receiveChainGlue,16
callback STATUS,statusGlue,12


STRUC xmsRegs
theAx	dw	?
theBx	dw	?
theDx	dw	?
theSi	dw	?
theDs	dw	?
ENDS xmsRegs

PUBLIC xmsCall
PROC xmsCall
	ARG  theXmsRegs:FAR PTR
	;USES si,di,es,ds,ax,bx,cx,dx
	USES si,di,ds

	MOV  cx,ds
	LES  di,[theXmsRegs]
	MOV  ax,[es:di + xmsRegs.theAx]
	MOV  bx,[es:di + xmsRegs.theBx]
	MOV  dx,[es:di + xmsRegs.theDx]
	MOV  si,[es:di + xmsRegs.theSi]
	MOV  ds,[es:di + xmsRegs.theDs]
	MOV  es,cx
	CALL [es:xmsEntry]
	LES  di,[theXmsRegs]
	MOV  [es:di + xmsRegs.theAx],ax
	MOV  [es:di + xmsRegs.theBx],bx
	MOV  [es:di + xmsRegs.theDx],dx
	MOV  [es:di + xmsRegs.theSi],si
	MOV  [es:di + xmsRegs.theDs],ds

	RET
ENDP xmsCall

PUBLIC swapLong
PROC swapLong
	ARG  aLong:DWORD
	MOV  dx,[WORD PTR aLong]
	MOV  ax,[WORD PTR aLong + 2]
	XCHG al,ah
	XCHG dl,dh
	RET
ENDP swapLong

PUBLIC swapAddr
PROC swapAddr
	ARG  aLong:DWORD
	MOV  dx,[WORD PTR aLong]
	MOV  ax,[WORD PTR aLong + 2]
	XCHG al,ah
	XCHG dl,dh
	RET
ENDP swapAddr

PUBLIC swapWord
PROC swapWord
	ARG  aShort:WORD
	MOV  ax,[aShort]
	XCHG al,ah
	RET
ENDP swapWord

IF @Cpu AND 08h

PUBLIC swapLongPtr
PROC swapLongPtr
	ARG  aLong:FAR PTR
	;USES es,si,ax,bx
	USES si
	LES  si,[aLong]
	MOV  ax,[WORD PTR es:si]
	MOV  bx,[WORD PTR es:si + 2]
	XCHG al,ah
	XCHG bl,bh
	MOV  [WORD PTR es:si],bx
	MOV  [WORD PTR es:si + 2],ax
	RET
ENDP swapLongPtr

ELSE

PUBLIC swapLongPtr
PROC swapLongPtr
	ARG   aLong:FAR PTR DWORD
	;USES  eax,si,es
	USES  si
	LES   si,[aLong]
	MOV   eax,[es:si]
	BSWAP eax
	MOV   [es:si],eax
	RET
ENDP swapLongPtr

ENDIF

PUBLIC swapWordPtr
PROC swapWordPtr
	ARG  aShort:FAR PTR WORD
	;USES es,si,ax
	USES si
	LES  si,[aShort]
	MOV  ax,[es:si]
	XCHG al,ah
	MOV  [es:si],ax
	RET
ENDP swapWordPtr

PUBLIC moveBytes
PROC moveBytes
	ARG  dest:FAR PTR,src:FAR PTR,length:WORD
	PUSH ds
	PUSH si
	PUSH di
	;PUSHA
	;PUSH ds
	;PUSH es
	CLD
	LDS  si,[src]
	LES  di,[dest]
	MOV  cx,[length]
	REP  movsb
	;POP  es
	;POP  ds
	;POPA
	POP  di
	POP  si
	POP  ds
	RET
ENDP moveBytes

PUBLIC moveWords
PROC moveWords
	ARG  dest:FAR PTR,src:FAR PTR,length:WORD
	;PUSHA
	;PUSH ds
	;PUSH es
	PUSH ds
	PUSH si
	PUSH di
	CLD
	LDS  si,[src]
	LES  di,[dest]
	MOV  cx,[length]
	REP  movsw
	;POP  es
	;POP  ds
	;POPA
	POP  di
	POP  si
	POP  ds
	RET
ENDP moveWords

PUBLIC moveLongs
PROC moveLongs
	ARG  dest:FAR PTR,src:FAR PTR,length:WORD

	;PUSHA
	;PUSH ds
	;PUSH es
	PUSH ds
	PUSH si
	PUSH di
	CLD
	LDS  si,[src]
	LES  di,[dest]
	MOV  cx,[length]
IF @Cpu AND 08h
	SHL  cx,1
	REP  movsw
ELSE
	REP  movsd
ENDIF
	;POP  es
	;POP  ds
	;POPA
	POP  di
	POP  si
	POP  ds
	RET
ENDP moveLongs

MASK1	EQU  080000057h
MASK2 	EQU  080000062h
MASK3 	EQU  020000029h

MACRO lfsr aLong,mask
	LOCAL bitNotSet,around

	; Load the long and test the bottom bit.
	MOV  eax,&aLong
	TEST al,1

	; If one then do the LFSR.
	JZ   bitNotSet

	; XOR with the mask, shr and or in a bit at top.
	XOR  eax,&mask
	SHR  eax,1
	OR   eax,080000000h
	MOV  dl,1
	JMP  around

	; Else just do the shift.
bitNotSet:
	SHR  eax,1
	XOR  dl,dl
around:
	; Save the long.
	MOV  &aLong,eax
ENDM

PUBLIC randByte
PROC randByte
	ARG  key:FAR PTR

	; Save regs.
	PUSH di

	; Load a pointer to the LFSR.
	LES  di,[key]
	MOV  cx,8
	XOR  bl,bl

genBit1:
	; Load the first LFSR
	lfsr <[DWORD PTR es:di]>,MASK1

	; Test the result.
	TEST dl,1

	; Gen the real bit based on the result.
	JZ   genBit3

	; genBit2
	lfsr <[DWORD PTR es:di + 4]>,MASK2

	; XOR with the other long.
	XOR  eax,[DWORD PTR es:di + 8]

	JMP  around
genBit3:
	lfsr <[DWORD PTR es:di + 8]>,MASK3

	; XOR with the other long.
	XOR  eax,[DWORD PTR es:di + 4]

around:
	; Build the byte in bx.
	SHL  bl,1

	; Mask the bottom bit.
	AND  al,1

	; Or it into the result.
	OR   bl,al
	DEC  cx
	JNZ  genBit1
	MOV  al,bl

	; Restore regs.
	POP  di
	RET
ENDP randByte

END
