/*
 * dnode1.c - FreeBSD node functions for lsof
 *
 * This module must be separate to keep separate the multiple kernel inode
 * structure definitions.
 */


/*
 * Copyright 1995 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dnode1.c,v 1.2 97/05/30 16:30:33 abe Exp $";
#endif


#include "lsof.h"

#if	defined(HAS9660FS)

/*
 * Do a little preparation for #include'ing cd9660_node.h, then #include it.
 */

#undef	i_size;
#undef	doff_t
#undef	IN_ACCESS

#include "cd9660_node.h"


/*
 * read_iso_node() -- read CD 9660 iso_node
 */

int
read_iso_node(v, d, ino, sz)
	struct vnode *v;		/* containing vnode */
	dev_t *d;			/* returned device number */
	unsigned long *ino;		/* returned inode number */
	unsigned long *sz;		/* returned size */
{

# if	FREEBSDV200
	struct iso_node *ip;
# else	/* FREEBSD>=200 */
	struct iso_node i;
# endif	/* FREEBSDV<200 */


# if	FREEBSDV<200
	ip = (struct iso_node *)v->v_data;
	*d = ip->i_dev;
	*ino = ip->i_number;
	*sz = ip->i_size;
# else	/* FREEBSDV>=200 */
	if (!v->v_data
	||  kread((KA_T)v->v_data, (char *)&i, sizeof(i)))
	    return(1);
	*d = i.i_dev;
	*ino = i.i_number;
	*sz = i.i_size;
# endif	/* FREEBSDV<200 */

	return(0);
}
#endif	/* defined(HAS9660FS) */
