#ifndef PAN_HASH_LOW
#define PAN_HASH_LOW

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include "..\pan_glob.h"

/**************************** Constant hash tables **************************/

const uint8 nyblTab[256]=  /* used by encrypt */
{/* 0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f  */
   0x7,0x8,0x0,0x8,0x6,0x4,0xE,0x4,0x5,0xC,0x1,0x7,0xB,0xF,0xA,0x8,
   0xF,0x8,0xC,0xC,0x9,0x4,0x1,0xE,0x4,0x6,0x2,0x4,0x0,0xA,0xB,0x9,
   0x2,0xF,0xB,0x1,0xD,0x2,0x1,0x9,0x5,0xE,0x7,0x0,0x0,0x2,0x6,0x6,
   0x0,0x7,0x3,0x8,0x2,0x9,0x3,0xF,0x7,0xF,0xC,0xF,0x6,0x4,0xA,0x0,
   0x2,0x3,0xA,0xB,0xD,0x8,0x3,0xA,0x1,0x7,0xC,0xF,0x1,0x8,0x9,0xD,
   0x9,0x1,0x9,0x4,0xE,0x4,0xC,0x5,0x5,0xC,0x8,0xB,0x2,0x3,0x9,0xE,
   0x7,0x7,0x6,0x9,0xE,0xF,0xC,0x8,0xD,0x1,0xA,0x6,0xE,0xD,0x0,0x7,
   0x7,0xA,0x0,0x1,0xF,0x5,0x4,0xB,0x7,0xB,0xE,0xC,0x9,0x5,0xD,0x1,
   0xB,0xD,0x1,0x3,0x5,0xD,0xE,0x6,0x3,0x0,0xB,0xB,0xF,0x3,0x6,0x4,
   0x9,0xD,0xA,0x3,0x1,0x4,0x9,0x4,0x8,0x3,0xB,0xE,0x5,0x0,0x5,0x2,
   0xC,0xB,0xD,0x5,0xD,0x5,0xD,0x2,0xD,0x9,0xA,0xC,0xA,0x0,0xB,0x3,
   0x5,0x3,0x6,0x9,0x5,0x1,0xE,0xE,0x0,0xE,0x8,0x2,0xD,0x2,0x2,0x0,
   0x4,0xF,0x8,0x5,0x9,0x6,0x8,0x6,0xB,0xA,0xB,0xF,0x0,0x7,0x2,0x8,
   0xC,0x7,0x3,0xA,0x1,0x4,0x2,0x5,0xF,0x7,0xA,0xC,0xE,0x5,0x9,0x3,
   0xE,0x7,0x1,0x2,0xE,0x1,0xF,0x4,0xA,0x6,0xC,0x6,0xF,0x4,0x3,0x0,
   0xC,0x0,0x3,0x6,0xF,0x8,0x7,0xB,0x2,0xD,0xC,0x6,0xA,0xA,0x8,0xD
};
                                /*** nyblTab reversed ***/
/*0x02,0x1C,0x2B,0x2C,0x30,0x3F,0x6E,0x72,0x89,0x9D,0xAD,0xB8,0xBF,0xCC,0xEF,0xF1,*/
/*0x0A,0x16,0x23,0x26,0x48,0x4C,0x51,0x69,0x73,0x7F,0x82,0x94,0xB5,0xD4,0xE2,0xE5,*/
/*0x1A,0x20,0x25,0x2D,0x34,0x40,0x5C,0x9F,0xA7,0xBB,0xBD,0xBE,0xCE,0xD6,0xE3,0xF8,*/
/*0x32,0x36,0x41,0x46,0x5D,0x83,0x88,0x8D,0x93,0x99,0xAF,0xB1,0xD2,0xDF,0xEE,0xF2,*/
/*0x05,0x07,0x15,0x18,0x1B,0x3D,0x53,0x55,0x76,0x8F,0x95,0x97,0xC0,0xD5,0xE7,0xED,*/
/*0x08,0x28,0x57,0x58,0x75,0x7D,0x84,0x9C,0x9E,0xA3,0xA5,0xB0,0xB4,0xC3,0xD7,0xDD,*/
/*0x04,0x19,0x2E,0x2F,0x3C,0x62,0x6B,0x87,0x8E,0xB2,0xC5,0xC7,0xE9,0xEB,0xF3,0xFB,*/
/*0x00,0x0B,0x2A,0x31,0x38,0x49,0x60,0x61,0x6F,0x70,0x78,0xCD,0xD1,0xD9,0xE1,0xF6,*/
/*0x01,0x03,0x0F,0x11,0x33,0x45,0x4D,0x5A,0x67,0x98,0xBA,0xC2,0xC6,0xCF,0xF5,0xFE,*/
/*0x14,0x1F,0x27,0x35,0x4E,0x50,0x52,0x5E,0x63,0x7C,0x90,0x96,0xA9,0xB3,0xC4,0xDE,*/
/*0x0E,0x1D,0x3E,0x42,0x47,0x6A,0x71,0x92,0xAA,0xAC,0xC9,0xD3,0xDA,0xE8,0xFC,0xFD,*/
/*0x0C,0x1E,0x22,0x43,0x5B,0x77,0x79,0x80,0x8A,0x8B,0x9A,0xA1,0xAE,0xC8,0xCA,0xF7,*/
/*0x09,0x12,0x13,0x3A,0x4A,0x56,0x59,0x66,0x7B,0xA0,0xAB,0xD0,0xDB,0xEA,0xF0,0xFA,*/
/*0x24,0x44,0x4F,0x68,0x6D,0x7E,0x81,0x85,0x91,0xA2,0xA4,0xA6,0xA8,0xBC,0xF9,0xFF,*/
/*0x06,0x17,0x29,0x54,0x5F,0x64,0x6C,0x7A,0x86,0x9B,0xB6,0xB7,0xB9,0xDC,0xE0,0xE4,*/
/*0x0D,0x10,0x21,0x37,0x39,0x3B,0x4B,0x65,0x74,0x8C,0xC1,0xCB,0xD8,0xE6,0xEC,0xF4*/

const uint8 crypTab[32]=   /* used by encrypt & encryptp */
{0x48,0x93,0x46,0x67,0x98,0x3D,0xE6,0x8D,0xB7,0x10,0x7A,0x26,0x5A,0xB9,0xB1,
 0x35,0x6B,0x0F,0xD5,0x70,0xAE,0xFB,0xAD,0x11,0xF4,0x47,0xDC,0xA7,0xEC,0xCF,
 0x50,0xC0};

/***************************** Constant Cipher tables ***********************/

const uint8 cipher1[8][2][16]=  /* used by pass_cipher */
{ /* 0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f  */
 {{ 0xF,0x8,0x5,0x7,0xC,0x2,0xE,0x9,0x0,0x1,0x6,0xD,0x3,0x4,0xB,0xA},
  { 0x2,0xC,0xE,0x6,0xF,0x0,0x1,0x8,0xD,0x3,0xA,0x4,0x9,0xB,0x5,0x7}},
 {{ 0x5,0x2,0x9,0xF,0xC,0x4,0xD,0x0,0xE,0xA,0x6,0x8,0xB,0x1,0x3,0x7},
  { 0xF,0xD,0x2,0x6,0x7,0x8,0x5,0x9,0x0,0x4,0xC,0x3,0x1,0xA,0xB,0xE}},
 {{ 0x5,0xE,0x2,0xB,0xD,0xA,0x7,0x0,0x8,0x6,0x4,0x1,0xF,0xC,0x3,0x9},
  { 0x8,0x2,0xF,0xA,0x5,0x9,0x6,0xC,0x0,0xB,0x1,0xD,0x7,0x3,0x4,0xE}},
 {{ 0xE,0x8,0x0,0x9,0x4,0xB,0x2,0x7,0xC,0x3,0xA,0x5,0xD,0x1,0x6,0xF},
  { 0x1,0x4,0x8,0xA,0xD,0xB,0x7,0xE,0x5,0xF,0x3,0x9,0x0,0x2,0x6,0xC}},
 {{ 0x5,0x3,0xC,0x8,0xB,0x2,0xE,0xA,0x4,0x1,0xD,0x0,0x6,0x7,0xF,0x9},
  { 0x6,0x0,0xB,0xE,0xD,0x4,0xC,0xF,0x7,0x2,0x8,0xA,0x1,0x5,0x3,0x9}},
 {{ 0xB,0x5,0xA,0xE,0xF,0x1,0xC,0x0,0x6,0x4,0x2,0x9,0x3,0xD,0x7,0x8},
  { 0x7,0x2,0xA,0x0,0xE,0x8,0xF,0x4,0xC,0xB,0x9,0x1,0x5,0xD,0x3,0x6}},
 {{ 0x7,0x4,0xF,0x9,0x5,0x1,0xC,0xB,0x0,0x3,0x8,0xE,0x2,0xA,0x6,0xD},
  { 0x9,0x4,0x8,0x0,0xA,0x3,0x1,0xC,0x5,0xF,0x7,0x2,0xB,0xE,0x6,0xD}},
 {{ 0x9,0x5,0x4,0x7,0xE,0x8,0x3,0x1,0xD,0xB,0xC,0x2,0x0,0xF,0x6,0xA},
  { 0x9,0xA,0xB,0xD,0x5,0x3,0xF,0x0,0x1,0xC,0x8,0x7,0x6,0x4,0xE,0x2}}
};

const uint8 cipher3[16]=    /* used by pass_cipher */
  { 0x3,0xE,0xF,0x2,0xD,0xC,0x4,0x5,0x9,0x6,0x0,0x1,0xB,0x7,0xA,0x8 };


/* The characters used for brute force cracking */
const char key_space[68]={"ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789,./<>?;':\"[]{}`~!@#$%^&*()_-+=|"};
uint8 crypt2_c_val,ghash[16],crypt2data[96];

/**************************Part One : The Brute Force***********************/

/*
 * START OF ITSME ROUTINES modified by Jitsu-Disk feb/98
 *                         touched again on march/98
 */

/*
 * XOR password with object ID, used for initialize in Main
 */
void xorwithid(uint32 id, uint32 *buf)
{int i;
 for (i=0 ; i<8 ; i++) *buf++ ^= id;
}

/*
 * Prepare the password by lengthening... Used for init in Main
 */
unsigned short preparepw(uint8 *pw, int pwLen, uint8 *dst)
{uint8 *p;
 unsigned short turns=1;
 int i=0;

 p=pw;
 do {if (pw+pwLen==p) {p=pw;
                       *dst++=crypTab[i];
                       turns++;}
     else *dst++=*p++;
     i++;
    } while (i<32);

 return turns;
}

/* 
 * encryptp() has changed quite a bit. Comments in this routine
 * are Jitsu-Disk's - SN
 */
int encryptp()
{register int i;

 /* This was not an easy one, but the double-recursive calc_c,calcElement
    is now broken down to a linear iterative formula */
 crypt2data[32]=(crypt2data[0]-crypTab[0])^(crypt2data[0]);
 crypt2_c_val=crypt2data[32];
 /* Wow redundancy DOES bring improvement...*/

 for (i=1;i<32;i++)
  { /* i|32==i+32 if (-1<i<32) */
   crypt2data[i|32]=
    (crypt2data[(crypt2_c_val&0x1f)+i]-crypTab[i])^
    (crypt2data[i]+crypt2_c_val);
   crypt2_c_val=crypt2_c_val+crypt2data[i|32];
  }

 crypt2data[64]=
  (crypt2data[32+(crypt2_c_val&0x1f)]-crypTab[0])^
  (crypt2data[32]+crypt2_c_val);

   /* Heuristic : Calling calcElement is very CPU consuming,
      so let's try to compare the 4 first bits of the first
      nibble first. Proves to be a good solution 93% of the time */
 if (nyblTab[crypt2data[64]]^ghash[0]&15) return(FALSE);
 crypt2_c_val=crypt2_c_val+crypt2data[64];

 /* Heuristic : In 90% of bad match, nibble 0 or 1 rejected */
 /* gOObER changed the form of checking good nibble 1*/
 crypt2data[65]=
  (crypt2data[(crypt2_c_val&0x1f)+33]-crypTab[1])^
  (crypt2data[33]+crypt2_c_val);

 if (nyblTab[crypt2data[65]]^(ghash[0]>>4)) return(FALSE);
  crypt2_c_val=crypt2_c_val+crypt2data[65];

 crypt2data[66]=
  (crypt2data[(crypt2_c_val&0x1f)+34]-crypTab[2])^
  (crypt2data[34]+crypt2_c_val);

 crypt2_c_val=crypt2_c_val+crypt2data[66];

 crypt2data[67]=
  (crypt2data[(crypt2_c_val&0x1f)+35]-crypTab[3])^
  (crypt2data[35]+crypt2_c_val);


 if ( (nyblTab[crypt2data[66]]|nyblTab[crypt2data[67]]<<4)
       !=ghash[1]) return(FALSE);

 crypt2_c_val=crypt2_c_val+crypt2data[67];

 /*Crypt2 & shrinkbuf in short*/
 for (i=36 ; i<64 ; i=i+2)
  {
   crypt2data[32+i]=
    (crypt2data[(crypt2_c_val&0x1f)+i]-crypTab[(i&0x1f)])^
    (crypt2data[i]+crypt2_c_val);
   crypt2_c_val=crypt2_c_val+crypt2data[32+i];

   crypt2data[33+i]=
    (crypt2data[(crypt2_c_val&0x1f)+i+1]-crypTab[((i+1)&0x1f)])^
    (crypt2data[i+1]+crypt2_c_val);
   crypt2_c_val=crypt2_c_val+crypt2data[33+i];

   if ( (nyblTab[crypt2data[32+i]]|
         nyblTab[crypt2data[33+i]]<<4)
       !=ghash[i/2-16]) return(FALSE);
  }

 return(TRUE);
} 

/*********************************End of Part One****************************/

/************************Part two : the hash generation**********************/

/* char p1[32]  : password xored with ID and itself ...
 * char p2[16]  : encrypted password (result)
 */
void make_hash(register uint8 *p1, uint8 *p2)  /* changes both p1 & p2 */
{
  int j,i;
  uint8 a;
  uint8 c=0;
  for (j=0 ; j<2 ; j++)
    for (i=0 ; i<32 ; i++)
    {
      a=(p1[(i+c)&0x1f] - crypTab[i]) ^ (p1[i]+c);
      c+=a;
      p1[i]=a;
    }
  memset(p2,0,16);
  for (i=0 ; i<32 ; i++)
    if (i&1)
      p2[i/2] |= nyblTab[p1[i]]<<4;
    else
      p2[i/2] |= nyblTab[p1[i]];
}

void hash_gen(uint32 id, uint8 *src,uint32 len, uint8 *dst)
{
  uint8 buf[32];
  uint8 *p;
  uint8 *q=src;
  int i;

  /*  Position p on the first byte or src different from 0 starting
      from the end */
  for (p=q+len-1 ; *p--==0 && len ; len--);
  /* Xoring the src against itself in block of 32 :
    ( ( (Block[0] Xor Block[1])Xor Block[2])...) */
  memset(buf,0,32);
  for ( ; len>=32 ; len-=32)
    for (i=0 ; i<32 ; q++, i++)
      buf[i] ^= *q;
  /* Very similar to preparepw(...), has the same effect if the src lengh
     is <=32 */
  p=q;
  if (len>0)
    for (i=0 ; i<32 ; i++)
    {
      if (q+len==p)
      {
	p=q;
	buf[i]^=crypTab[i];
      }
      else
	buf[i]^=*p++;
    }
  /* Exactly the same as XorWithId(...), too lazzy to get rid off :) */
  for (i=0 ; i<32 ; i++)
    buf[i] ^= ((uint8 *)&id)[i&3];
  make_hash(buf,dst);
}
/********************************End of Part two****************************/

/*************************Part three : password cipher***********************/

/* char p1[8] : half of current password hash
 * char p2[8] : half of new password hash
 * char p3[8] : half-pattern such as F(p1,p3)=p2
 *
 * pass_cipher(p1,p2)=p3
 * a XOR func would probably have done the trick... go figure.
 * (my guess is that this was built so there is not function G such as
 *  G(p2,p3)=p1)
 */

void pass_cipher(register uint8 *p1, uint8 *p2, uint8 *p3)
{
 register int j;
 uint8 c;
 uint8 buf[8];
 int i;

 memcpy(buf,p2,8);
 for (i=0 ; i<16 ; i++)
 {
  for (j=0 ; j<8 ; j++)
   {
    c=buf[j]^p1[j];
    buf[j]= cipher1[j][0][c&15] | (cipher1[j][1][c>>4] <<4);
   }
  c=p1[7];
  for (j=7 ; j>0 ; j--) p1[j]=(p1[j]<<4) | (p1[j-1]>>4);
  p1[0]= (c>>4) | (p1[0]<<4);

  memset(p3,0,8);
  for (j=0 ; j<16 ; j++)
   {
    c= cipher3[j];
    c= (cipher3[j]&1) ? (buf[c/2]>>4) : (buf[c/2]&0xf) ;
    p3[j/2] |= (j&1) ? (c<<4) : c ;
   }
  memcpy(buf,p3,8);
 }
}

/********************************End of Part three****************************/



#ifdef __cplusplus
}
#endif

#endif /* PAN_HASH_LOW */
