/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#define NEED_SIGACTION

#include	<stdio.h>
#include	<signal.h>
#include	<setjmp.h>
#include	"config.h"

/*
 * hardware.c
 *
 *	Generates hardware specific information
 *
 */


jmp_buf		sig_jmp;

static SIGRETURN	caught_sig(
#ifdef __STDC__
	void
#endif
)
{
	longjmp(sig_jmp, 1);
	RETURN_SIGFUNC(0);
}

main(argc, argv)
int	argc;
char	*argv[];
{
	unsigned long		l, lm;
	unsigned int		in, im;
	unsigned char		c, cm, *lp;
#ifdef SIGBUS
	unsigned char		al[sizeof(l) * 2];
	register int		i;
#endif /* SIGBUS */
	struct sigaction	new_action, old_action;


        (void) printf("/*\n");
	(void) printf(" * This file is automaticly generated, do not change.\n");
	(void) printf(" */\n\n");

	/*
	 * Number of bits in an unsigned char.
	 */
	for (c = cm = 0x1, i = 0; c; c <<= 1, cm = (cm << 1) | 0x1, i++);
	(void) printf("#define UNSIGNED_CHAR_BITS\t%u\n", i);
	(void) printf("#define UNSIGNED_CHAR_MAX\t%u\n\n", (int) cm);

	/*
	 * Number of bits in an unsigned int.
	 */
	for (in = im = 0x1, i = 0; in; in <<= 1, im = (im << 1) | 0x1, i++);
	(void) printf("#define UNSIGNED_INT_BITS\t%u\n", i);
	(void) printf("#define UNSIGNED_INT_MAX\t%u\n\n", im);

	/*
	 * Number of bits in an unsigned long.
	 */
	for (l = lm = 0x1l, i = 0; l; l <<= 1, lm = (lm << 1) | 0x1l, i++);
	(void) printf("#define UNSIGNED_LONG_BITS\t%u\n", i);
	(void) printf("#define UNSIGNED_LONG_MAX\t%lu\n\n", lm);

	/*
	 * Byte order in an unsigned long.
	 */
	l = 0L;
	lp = (unsigned char* ) &l;
	lp[0] = 1;
	(void) printf((i > 1L) ?
			"#define UNSIGNED_MSB_FIRST\n\n" :
			"#define UNSIGNED_LSB_FIRST\n\n");

#ifdef SIGBUS
	/*
	 * Check if address alignment is necesry on unsigned long.
	 * This method does only work if a SIGBUS signal is generated
	 * when fetching an unsigned long from an unaligned address.
	 */

	for (i = 0; i < sizeof(al); i++)
		al[i] = i;

	new_action.sa_handler = caught_sig;
	(void) sigemptyset(&new_action.sa_mask);
	new_action.sa_flags = 0;
	(void) sigaction(SIGBUS, &new_action, &old_action);
	if (!setjmp(sig_jmp)) {
		for (i = 0; i < sizeof(l); i++) {
			*((unsigned long *) & al[i]) = (unsigned long) i;
			l += *((unsigned long *) & al[i]);
		}
		(void) printf("/* #define UNSIGNED_LONG_ALIGN */\n\n");
	} else {
		(void) printf("#define UNSIGNED_LONG_ALIGN\n\n");
	}
	(void) sigaction(SIGBUS, &old_action, NULL);
#else  /* SIGBUS */
	(void) printf("/* #define UNSIGNED_LONG_ALIGN /* NOT TESTED */\n\n");

#endif /* SIGBUS */

	exit(0);
}
