#! /bin/sh
#
#                         DES SOFTWARE PACKAGE
#                             Version 2.2
#
#                                        _
# Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
# All Rights Reserved
#
#
# The author takes no responsibility of actions caused by the use of this
# software package and does not guarantee the correctness of the functions.
#
# This software package may be freely distributed for non-commercial purpose
# as long as the copyright notice is kept. Any changes made should be
# accompanied by a comment indicating who made the change, when it was made
# and what was changed.
#
# This software package, or any parts of it, may not be used or in any way
# re-distributed for commercial purpose without the authors permission.
# The author keeps the right to decide between of what is commercial and
# what is non-commercial purpose.
#
# Restrictions due to national laws governing the use, import or export of
# cryptographic software is the responsibility of the software user/importer/
# exporter to follow.
#
#
#                                              _
#                                         Stig Ostholm
#                                         Chalmers University of Technology
#                                         Department of Computer Engineering
#                                         S-412 96 Gothenburg
#                                         Sweden
#                                         ----------------------------------
#                                         Email: ostholm@ce.chalmers.se
#                                         Phone: +46 31 772 1703
#                                         Fax:   +46 31 772 3663
# 

PROG="`IFS=/; set $0; eval echo '$'$#`"
USAGE="Usage: ${PROG} [VAR=value ...] [-s] [-o out]"

CC=cc
CFLAGS=
RM='rm -f'
CP=cp
ECHO=echo
VERBOSE=
IDIR=include
FAKEDIR="${IDIR}/fake"

OUT=/dev/null
A_OUT=a.out

while :; do
	case $# in
	0)	break;;
	esac
	case "$1" in
	[A-Z]*=*)
		if VAR="`expr \"$1\" : '^\([^=]*\)=.*$'`"; then
			case "$1" in
			"${VAR}=")
				eval "${VAR}="
				shift
				continue;;
			esac
			if VAL="`expr \"$1\" : \"^${VAR}=\(.*\)\$\"`"; then
				if eval "${VAR}=\"\${VAL}\""; then
					:
				else
					exit 1
				fi
			else
				exit 1
			fi
		else
			exit 1
		fi;;
	-o)     shift
		case $# in
		0)      exit 1;;
		esac
		OUT="$1";;
	-*s*)	VERBOSE=:;;
	--)	shift
		break;;
	-*)	:;;
	*)	break;;
	esac
	shift
done
case $# in
[1-9]*)	echo "${USAGE}" >&2
	exit 1;;
esac
case "${VERBOSE}" in
'')	VERBOSE="${ECHO}";;
esac


if eval ${CC} -E ${CFLAGS} test/signal.c | grep -s 'void[ 	\*()]*signal' >/dev/null 2>&1; then
	SIGRETURN='#define SIGRETURN void'
	RETURN_SIGFUNC='#define RETURN_SIGFUNC(s) return'
else
	SIGRETURN='#define SIGRETURN int'
	RETURN_SIGFUNC='#define RETURN_SIGFUNC(s) return(s)'
fi

if ${CC} -E ${CFLAGS} test/termios.c >/dev/null 2>&1; then
	FAKE_TERMIOS='/* #define FAKE_TERMIOS */'
else
	FAKE_TERMIOS='#define FAKE_TERMIOS'
	eval ${CP} ${FAKEDIR}/termios.h ${IDIR}/termios.h
	eval $VERBOSE "${CP} ${FAKEDIR}/termios.h ${IDIR}/termios.h"
fi

if ${CC} -E ${CFLAGS} test/stdlib.c >/dev/null 2>&1; then
	FAKE_STDLIB='/* #define FAKE_STDLIB */'
else
	FAKE_STDLIB='#define FAKE_STDLIB'
	eval ${CP} ${FAKEDIR}/stdlib.h ${IDIR}/stdlib.h
	eval $VERBOSE "${CP} ${FAKEDIR}/stdlib.h ${IDIR}/stdlib.h"
fi

if ${CC} -E ${CFLAGS} test/string.c | grep -s memcpy >/dev/null 2>&1; then
	MEMORY='/* #include <memory.h> */'
	MEMCPY='/* #define memcpy(s1,s2,n) bcopy(s2,s1,n) */'
	MEMCMP='/* #define memcmp(s1,s2,n) bcmp(s2,s1,n) */'
elif ${CC} -E ${CFLAGS} test/memory.c | grep -s memcpy >/dev/null 2>&1; then
	MEMORY='#include <memory.h>'
	MEMCPY='/* #define memcpy(s1,s2,n) bcopy(s2,s1,n) */'
	MEMCMP='/* #define memcmp(s1,s2,n) bcmp(s2,s1,n) */'
else
	MEMORY='/* #include <memory.h> */'
	MEMCPY='#define memcpy(s1,s2,n) bcopy(s2,s1,n)'
	MEMCMP='#define memcmp(s1,s2,n) bcmp(s2,s1,n)'
fi

if ${CC} -E ${CFLAGS} test/stdio.c | grep -s 'fread(' >/dev/null 2>&1; then
	FAKE_STDIO='/* #define FAKE_STDIO */'
else
	FAKE_STDIO='#define FAKE_STDIO'
fi

if ${CC} ${CFLAGS} -o ${A_OUT} test/gettofd.c >/dev/null 2>&1 && \
   eval ${A_OUT} >/dev/null 2>&1; then
	HAS_GETTIMEOFDAY='#define HAS_GETTIMEOFDAY'
else
	HAS_GETTIMEOFDAY='/* #define HAS_GETTIMEOFDAY */'
fi
eval ${RM} ${A_OUT} gettofd.o

if ${CC} ${CFLAGS} -o ${A_OUT} test/ftime.c >/dev/null 2>&1 && \
   eval ${A_OUT} >/dev/null 2>&1; then
	HAS_FTIME='#define HAS_FTIME'
else
	HAS_FTIME='/* #define HAS_FTIME */'
fi
eval ${RM} ${A_OUT} ftime.o


cat > "${OUT}.$$" << END_OF_TEXT
/*
 * This file is automaticly generated, do not change.
 */

$SIGRETURN
$RETURN_SIGFUNC

#ifdef SIGHUP
# if !defined(SA_NOCLDSTOP) && defined(NEED_SIGACTION)
#  include	<fake/signal.h>
# endif /* !SA_NOCLDSTOP && NEED_SIGACTION */
#endif /* SIGHUP */

$FAKE_TERMIOS
$FAKE_STDLIB
$FAKE_STDIO
#if defined(FAKE_STDIO) && (defined(FILE) || defined(EOF))
# include	<fake/stdio.h>
#endif /* FAKE_STDIO && (FILE || EOF) */

$MEMORY
$MEMCPY
$MEMCMP

$HAS_GETTIMEOFDAY
$HAS_FTIME

#ifndef NULL
# define NULL 0
#endif  /* NULL */

END_OF_TEXT

case $? in
0)	mv "${OUT}.$$" "${OUT}";;
1)	eval $RM "${OUT}.$$"
	exit 1;;
esac

exit $?
