/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	"local_def.h"
#include	"fips_def.h"
#include	"tab_IP.h"
#include	"tab_IPinv.h"
#include	"tab_E.h"
#include	"tab_S_P.h"
#ifndef DEA_TEST
# include	"dea_conf.h"
#endif  /* DEA_TEST */

/*
 * The funktion F
 */

#ifdef E_DATA
# ifdef S_AND_P_DATA
#  define F_DATA \
	des_cblock	b; \
	E_DATA; \
	S_AND_P_DATA
# else  /* S_AND_P_DATA */
#  define F_DATA \
	des_cblock	b; \
	E_DATA
# endif /* S_AND_P_DATA */
#else  /* E_DATA */
# ifdef S_AND_P_DATA
#  define F_DATA \
	des_cblock	b; \
	S_AND_P_DATA
# else  /* S_AND_P_DATA */
#  define F_DATA \
	des_cblock	b
# endif /* S_AND_P_DATA */
#endif /* E_DATA */

#define	F(R, KSn)  \
\
	E(b, R); \
	XOR_8(b, KSn); \
	R = S_AND_P(b)

/*
 * One iteration
 */

#ifdef F_DATA
# define ITERATION_DATA \
	F_DATA; \
	register unsigned long	r0
#else  /*  F_DATA */
# define ITERATION_DATA \
	register unsigned long	r0
#endif /*  F_DATA */

#define ITERATION(L, R, KSn) \
	r0 = R; \
	F(R, KSn); \
	R ^= L; \
	L = r0

/*
 * One encryption/decryption without initial permuation.
 */

#ifdef USE_LOOP
# ifdef USE_INC

#define CRYPT_DATA \
	ITERATION_DATA; \
	register struct des_ks_struct	*s; \
	register int			i

#define ENCRYPT(l,r,sched) \
	for (i = DES_ITERATIONS, s = &(sched)[0]; i > 0; i--, s++) { \
		ITERATION(l, r, (*s)._); \
	}

#define DECRYPT(l,r,sched) \
	for (i = DES_ITERATIONS, s = &(sched)[15]; i > 0; i--, s--) { \
		ITERATION(l, r, (*s)._); \
	}

# else  /* USE_INC */

#define CRYPT_DATA \
	ITERATION_DATA; \
	register int	i

#define ENCRYPT(l,r,sched) \
	for (i = 0; i < DES_ITERATIONS; i++) { \
		ITERATION(l, r, (sched)[i]._); \
	}

#define DECRYPT(l,r,sched) \
	for (i = DES_ITERATIONS - 1; i >= 0; i++) { \
		ITERATION(l, r, (sched)[i]._); \
	}

# endif /* USE_INC */
#else  /* USE_LOOP */
# ifdef USE_INC

#define CRYPT_DATA \
	ITERATION_DATA; \
	register struct des_ks_struct	*s

#define ENCRYPT(l,r,sched) \
	s = &(sched)[0]; \
	ITERATION(l, r, (*s++)._); \
	ITERATION(l, r, (*s++)._); \
	ITERATION(l, r, (*s++)._); \
	ITERATION(l, r, (*s++)._); \
	ITERATION(l, r, (*s++)._); \
	ITERATION(l, r, (*s++)._); \
	ITERATION(l, r, (*s++)._); \
	ITERATION(l, r, (*s++)._); \
	ITERATION(l, r, (*s++)._); \
	ITERATION(l, r, (*s++)._); \
	ITERATION(l, r, (*s++)._); \
	ITERATION(l, r, (*s++)._); \
	ITERATION(l, r, (*s++)._); \
	ITERATION(l, r, (*s++)._); \
	ITERATION(l, r, (*s++)._); \
	ITERATION(l, r, (*s)._)

#define DECRYPT(l,r,sched) \
	s = &(sched)[15]; \
	ITERATION(l, r, (*s--)._); \
	ITERATION(l, r, (*s--)._); \
	ITERATION(l, r, (*s--)._); \
	ITERATION(l, r, (*s--)._); \
	ITERATION(l, r, (*s--)._); \
	ITERATION(l, r, (*s--)._); \
	ITERATION(l, r, (*s--)._); \
	ITERATION(l, r, (*s--)._); \
	ITERATION(l, r, (*s--)._); \
	ITERATION(l, r, (*s--)._); \
	ITERATION(l, r, (*s--)._); \
	ITERATION(l, r, (*s--)._); \
	ITERATION(l, r, (*s--)._); \
	ITERATION(l, r, (*s--)._); \
	ITERATION(l, r, (*s--)._); \
	ITERATION(l, r, (*s)._)

# else  /* USE_INC */

#define CRYPT_DATA \
	ITERATION_DATA

#define ENCRYPT(l,r,sched) { \
	ITERATION(l, r, (sched)[0]._); \
	ITERATION(l, r, (sched)[1]._); \
	ITERATION(l, r, (sched)[2]._); \
	ITERATION(l, r, (sched)[3]._); \
	ITERATION(l, r, (sched)[4]._); \
	ITERATION(l, r, (sched)[5]._); \
	ITERATION(l, r, (sched)[6]._); \
	ITERATION(l, r, (sched)[7]._); \
	ITERATION(l, r, (sched)[8]._); \
	ITERATION(l, r, (sched)[9]._); \
	ITERATION(l, r, (sched)[10]._); \
	ITERATION(l, r, (sched)[11]._); \
	ITERATION(l, r, (sched)[12]._); \
	ITERATION(l, r, (sched)[13]._); \
	ITERATION(l, r, (sched)[14]._); \
	ITERATION(l, r, (sched)[15]._); \
}

#define DECRYPT(l,r,sched) { \
	ITERATION(l, r, (sched)[15]._); \
	ITERATION(l, r, (sched)[14]._); \
	ITERATION(l, r, (sched)[13]._); \
	ITERATION(l, r, (sched)[12]._); \
	ITERATION(l, r, (sched)[11]._); \
	ITERATION(l, r, (sched)[10]._); \
	ITERATION(l, r, (sched)[9]._); \
	ITERATION(l, r, (sched)[8]._); \
	ITERATION(l, r, (sched)[7]._); \
	ITERATION(l, r, (sched)[6]._); \
	ITERATION(l, r, (sched)[5]._); \
	ITERATION(l, r, (sched)[4]._); \
	ITERATION(l, r, (sched)[3]._); \
	ITERATION(l, r, (sched)[2]._); \
	ITERATION(l, r, (sched)[1]._); \
	ITERATION(l, r, (sched)[0]._); \
}

# endif /* USE_INC */
#endif /* USE_LOOP */
