/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdio.h>
#include	<string.h>
#include	"config.h"
#include	"fips_def.h"
#include	"fips_E.h"
#ifndef DEA_TEST
# include       "dea_conf.h"
#endif /* DEA_TEST */


/*
 * This program generates a macro definition for us as the expansion E.
 *
 *	E(B, R)
 *
 * The input is 32 bits in the unsigned long `R' with the least significant
 * bit as the first. The output is the least significant six bits in each
 * unsigned character B[0] .. B[7], with the first bit as the least significant
 * bit of B[0].
 */

static char	*prog;
static char	*base;
static int	c_file = 0;


#ifndef USE_SHIFT
# define USE_SHIFT
#endif  /* ! USE_SHIFT */

main(argc, argv)
int	argc;
char	*argv[];
{
#ifdef USE_SHIFT
	register int		n, s_min, s_max, r, c, bit, s, sh, sp, se;
	register unsigned long	b;
	unsigned long		st[E_ROWS][DES_R_BITS * 2];
	unsigned long		nb[E_ROWS][DES_R_BITS * 2];
	int			b_set[E_ROWS];
#else  /* USE_SHIFT */
#endif /* USE_SHIFT */

	prog = (prog = strrchr(*argv, '/')) ? (prog + 1) : *argv;
	if (argc != 3 || (strcmp(argv[1], "-c") && strcmp(argv[1], "-h")))
		goto usage;
	c_file = strcmp(argv[1], "-h");
	base = argv[2];

	(void) printf("/*\n");
	(void) printf(" * This file is automaticly generated, do not change.\n");
	(void) printf(" */\n\n");

	if (c_file) {
		(void) printf("#include\t\"local_def.h\"\n#include\t\"version.h\"\n");
		(void) printf("#include\t\"%s.h\"\n\n", base);
	}

#ifdef USE_SHIFT
	if (c_file) {
		(void) printf("/* No global definitions. */\n");
	} else {
		s_min = DES_R_BITS * 2;
		s_max = 0;
		for (r = 0; r < E_ROWS; r++) {

			b_set[r] = 0;

			for (s = 0; s < DES_R_BITS * 2; s++)
				nb[r][s] = st[r][s] = 0x0l;

			for (bit = 1, c = 0; c < E_COLUMNS; bit++, c++) {
				sh = bit - e[r][c];
				s = DES_R_BITS + sh;
				st[r][s] |= 0x1l << (e[r][c] - 1);
				nb[r][s]++;
				if (s > s_max)
					s_max = s;
				if (s < s_min)
					s_min = s;
			}
		}

		(void) printf("#define E_DATA register unsigned long\ter\n\n");
		(void) printf("#define E(B, R) \\\n");
		(void) printf("\ter = R; \\\n");
		for (n = sp = 0, s = DES_R_BITS; s <= s_max; s++)
			for (r = 0; r < E_ROWS; r++) {
				if (!st[r][s])
					continue;
				if (n++)
					(void) printf("; \\\n");
				sh = s - DES_R_BITS;
				se = sh - sp;
				b = st[r][s] << sh;
				if (nb[r][s] > 1) {
					(void) printf("\ter <<= %d; \\\n", se);
					if (b_set[r]++)
						(void) printf("\tB[%d] |= er & 0x%08lxl",
							      r, b);
					else
						(void) printf("\tB[%d] = er & 0x%08lxl",
							      r, b);
					sp = sh;
				} else {
					if (b_set[r]++) {
						(void) printf("\tif (er & 0x%08lxl) \\\n",
							      st[r][s] << sp);
						(void) printf("\t\tB[%d] |= 0x%08lxl",
							      r, b);
					} else {
						(void) printf("\tB[%d] = (er & 0x%08lxl) ? ",
							      r, st[r][s] << sp);
						(void) printf("0x%08lxl : 0x%08lxl",
							      b, 0x0l);
					}
				}
			}
		if (sp) {
			sp = 0;
			(void) printf("; \\\n\ter = R");
		}
		for (s = DES_R_BITS - 1; s >= s_min; s--)
			for (r = 0; r < E_ROWS; r++) {
				if (!st[r][s])
					continue;
				if (n++)
					(void) printf("; \\\n");
				sh = s - DES_R_BITS;
				se = sh - sp;
				b = st[r][s] >> -sh;
				if (nb[r][s] > 1) {
					(void) printf("\ter >>= %d; \\\n", -se);
					if (b_set[r]++)
						(void) printf("\tB[%d] |= er & 0x%08lxl",
							      r, b);
					else
						(void) printf("\tB[%d] = er & 0x%08lxl",
							      r, b);
					sp = sh;
				} else {
					if (b_set[r]++) {
						(void) printf("\tif (er & 0x%08lxl) \\\n",
							      st[r][s] >> -sp);
						(void) printf("\t\tB[%d] |= 0x%08lxl",
							      r, b);
					} else {
						(void) printf("\tB[%d] = (er & 0x%08lxl) ? ",
							      r, st[r][s] >> -sp);
						(void) printf("0x%08lxl : 0x%08lxl",
							      b, 0x0l);
					}
				}
			}
		(void) printf("\n");
# ifdef NOTDEF
		for (r = 0; r < E_ROWS; r++) {
			(void) printf("\tB[%d] = (", r);
			for (s = min_s[r]; s <= max_s[r]; s++)
				if (nb[r][s]) {
					(void) printf("((er & 0x%08lxl) ", st[r][s]);
					sh = s - DES_R_BITS;
					if (sh > 0)
						(void) printf("<< %2d)", sh);
					else if (sh < 0)
						(void) printf(">> %2d)", -sh);
					else
						(void) printf("     )");
					(void) printf((--nb[r][s]) ? ")" : " | ");
				}
			(void) printf((r + 1 < E_ROWS) ? "; \\\n" : "\n");
		}
# endif /* NOTDEF */
	}
#else  /* USE_SHIFT */
	(void) printf("/* Nothing defined. */\n");
#endif  /* USE_SHIFT */

	exit(0);

usage:
	(void) fprintf(stderr, "Usage: %s -c|-h base\n", prog);
	exit(1);
}
