/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdio.h>
#include	<string.h>
#include	"des.h"
#include	"config.h"
#include	"fips_def.h"
#include	"fips_IP.h"
#ifndef DEA_TEST
# include       "dea_conf.h"
#endif  /* DEA_TEST */


/*
 * This program generates a macro for us as initial permutation.
 *
 *		IP(L, R, B)
 *
 * The input is an array of unsigned characters `B[0..7]' with the first
 * bit as the * least significant bit of `B[0]'.
 * The output is two unsigned long's `L' with `R' with the first 32 bits in
 * `L' and the rest in `R'. The least significant bits in `L' and `R' are
 * the first bits in each.
 */

static char	*prog;
static char	*base;
static int	c_file = 0;


main(argc, argv)
int	argc;
char	*argv[];
{
#ifdef USE_SHIFT
	register int		r, c, block_bit, byte, bit, n_bit, shift;
	register unsigned long	b;
	register char		ch;
#else  /* USE_SHIFT */
# ifdef USE_IF
	register int	i, j, block_bit, byte, bit, n;
	unsigned char	r[DES_BLOCK_BYTES][UNSIGNED_CHAR_BITS];
	unsigned char	l[DES_BLOCK_BYTES][UNSIGNED_CHAR_BITS];
# else  /* USE_IF */
	register unsigned long	l, r;
	register int		i, j, byte, bit, n, sb, row, col;
	unsigned long		lv[UNSIGNED_CHAR_MAX + 1];
	unsigned long		rv[UNSIGNED_CHAR_MAX + 1];
# endif /* USE_IF */
#endif /* USE_SHIFT */


	prog = (prog = strrchr(*argv, '/')) ? (prog + 1) : *argv;
	if (argc != 3 || (strcmp(argv[1], "-c") && strcmp(argv[1], "-h")))
		goto usage;
	c_file = strcmp(argv[1], "-h");
	base = argv[2];


        (void) printf("/*\n");
	(void) printf(" * This file is automaticly generated, do not change.\n");
	(void) printf(" */\n\n");

	if (c_file)  {
		(void) printf("#include\t\"local_def.h\"\n#include\t\"version.h\"\n");
		(void) printf("#include\t\"%s.h\"\n\n", base);
	}

#ifdef USE_SHIFT
	if (c_file) {
		(void) printf("/* No global definitions. */\n");
	} else {
		(void) printf("#define IP(L, R, B) \\\n");
		for (block_bit = n_bit = r = 0; r < IP_ROWS; r++)
			for (c = 0; c < IP_COLUMNS; c++) {
				if (++n_bit == 1) {
					ch = (block_bit > 0) ? 'R' : 'L';
					(void) printf("\t%c = ( \\\n", ch);
				}
				byte = ((int) ip[r][c] - 1) / UNSIGNED_CHAR_BITS;
				bit = ip[r][c] - byte * UNSIGNED_CHAR_BITS;
# ifdef DES_LSB_FIRST
				b = 0x1l << (bit - 1);
				shift = n_bit - bit;
# else
				b = 0x1l << (UNSIGNED_CHAR_BITS - bit);
				shift = n_bit - (UNSIGNED_CHAR_BITS + 1 - bit);
# endif
				(void) printf("\t\t((unsigned long) (B[%d] & 0x%02lx)", byte, b);
				if (shift > 0) 
					(void) printf(" << %2d", shift);
				else if (shift < 0)
					(void) printf(" >> %2d", -shift);
				else
					(void) printf("      ");
				if (n_bit == DES_L_BITS) {
					(void) printf(")   /* bit %2d */ \\\n",
						      ++block_bit);
					(void) printf((block_bit == DES_L_BITS) ?
						      "\t); \\\n\\\n" : "\t)\n");
					n_bit = 0;
				} else
					(void) printf(") | /* bit %2d */ \\\n",
						      ++block_bit);
			}
	}
#else  /* USE_SHIFT */
# ifdef USE_IF
	if (c_file) {
		(void) printf("/* No global definitions. */\n");
	} else {
		for (i = 0; i < DES_BLOCK_BYTES; i++)
			for (j = 0; j < UNSIGNED_CHAR_BITS; j++)
				r[i][j] = l[i][j] = 0x0;
		for (block_bit = i = 0; i < IP_ROWS; i++)
			for (j = 0; j < IP_COLUMNS; block_bit++, j++) {
				byte = ((int) ip[i][j] - 1) / UNSIGNED_CHAR_BITS;
				bit = ip[i][j] - (byte * UNSIGNED_CHAR_BITS);
#  ifdef DES_LSB_FIRST
				bit--;
#  else
				bit = UNSIGNED_CHAR_BITS - bit;
#  endif
				if (block_bit < DES_L_BITS)
					l[byte][bit] =
						(unsigned char) block_bit + 1;
				else
					r[byte][bit] =
						(unsigned char) (block_bit - 31);
			}
		(void) printf("#define IP(L, R, B) \\\n");
		(void) printf("\tL = 0x0l; \\\n");
		for (byte = 0x0; byte < DES_BLOCK_BYTES; byte++)
			for (bit = 0x0; bit < UNSIGNED_CHAR_BITS; bit++) {
				if (!l[byte][bit])
					continue;
				(void) printf("\tif (B[%d] & 0x%02x) L |= 0x%08lxl",
					      byte, 0x01 << bit,
					    0x1l << l[byte][bit] - 1);
				(void) printf("; /* %2d */ \\\n", l[byte][bit]);
			}
		(void) printf("\\\n\tR = 0x0l; \\\n");
		for (n = 0, byte = DES_BLOCK_BYTES - 1; byte >= 0; byte--)
			for (bit = 0; bit < UNSIGNED_CHAR_BITS; bit++) {
				if (!r[byte][bit])
					continue;
				(void) printf("\tif (B[%d] & 0x%02x) R |= 0x%08lxl",
					      byte, 0x1 << bit,
					      0x1l << r[byte][bit] - 1);
				if (++n == DES_R_BITS)
					(void) printf("  /* %2d */\n",
						      r[byte][bit] + DES_R_BITS);
				else
					(void) printf("; /* %2d */ \\\n",
						      r[byte][bit] + DES_R_BITS);
			}
	}
# else /* USE_IF */
	if (c_file) {
		(void) printf("#ifdef __SDTC__\nconst\n#endif\n");
		(void) printf("\t%s_t\tip = {\n\t\t{\n", base);
		*lv = 0x0l;
		*rv = 0x0l;
		for (byte = 0x0; byte < DES_BLOCK_BYTES; byte++) {
			for (bit = 0x0; bit < UNSIGNED_CHAR_BITS; bit++) {
#  ifdef DES_LSB_FIRST
				sb = (byte * UNSIGNED_CHAR_BITS) + bit + 1;
#  else
				sb = ((byte * UNSIGNED_CHAR_BITS) +
				      ((UNSIGNED_CHAR_BITS - 1) - bit)) + 1;
#  endif
				/*
				 * row and col can't be used directly as index
				 * variables due to the C-compiler on PS/2.
				 */
				row = col = 0x0;
				for (i = 0; i < IP_ROWS; i++)
					for (j = 0; j < IP_COLUMNS; j++)
						if (sb == ip[i][j]) {
							row = i;
							col = j;
							goto next;
						}
next:
				sb = (row * IP_COLUMNS) + col;
				if (sb >= DES_L_BITS) {
					l = 0x0l;
					r = 0x1l << (sb - DES_L_BITS);
				} else {
					l = 0x1l << sb;
					r = 0x0l;
				}
				n = 0x1 << bit;
				lv[n] = l;
				rv[n] = r;
				if (n > 1)
					for (i = 1, j = n + 1; i < n; i++, j++) {
						lv[j] = l | lv[i];
						rv[j] = r | rv[i];
					}
			}
			for (i = 0; i < UNSIGNED_CHAR_MAX; i++)
				(void) printf("\t\t\t{ 0x%08lxl, 0x%08lxl },\n",
					      lv[i], rv[i]);
			(void) printf("\t\t\t{ 0x%08lxl, 0x%08lxl }\n\t\t}",
				      lv[i], rv[i]);
			if (byte < DES_BLOCK_BYTES - 1)
				(void) printf(", {\n");
		}
		(void) printf(" \n\t};\n");
	} else {
		(void) printf("#define IP(L, R, B) \\\n");
		(void) printf("\tL  = ip[0][B[0]].l; R  = ip[0][B[0]].r; \\\n");
		for (i = 1; i < DES_BLOCK_BYTES - 1; i++)
			(void) printf("\tL |= ip[%d][B[%d]].l; R |= ip[%d][B[%d]].r; \\\n",
				      i, i, i, i);
		(void) printf("\tL |= ip[%d][B[%d]].l; R |= ip[%d][B[%d]].r\n\n",
			      i, i, i, i);
		(void) printf("typedef\tstruct {\n\t\t\tunsigned long\tl, r;\n\t\t} %s_t[%d][%d];\n\n", base, DES_BLOCK_BYTES, UNSIGNED_CHAR_MAX + 1);
		(void) printf("extern\n#ifdef __SDTC__\n\tconst\n#endif\n");
		(void) printf("\t\t%s_t\tip;\n", base);
	}
# endif /* USE_IF */
#endif /* USE_SHIFT */

	exit(0);

usage:
	(void) fprintf(stderr, "Usage: %s -c|-h base\n", prog);
	exit(1);
}
