/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdio.h>
#include	<string.h>
#include	"des.h"
#include	"config.h"
#include	"fips_def.h"
#include	"fips_IPinv.h"
#ifndef DEA_TEST
# include       "dea_conf.h"
#endif  /* DEA_TEST */


/*
 * This program generates a macro for us as inverse initial permutation.
 *
 *		IPinv(B, L, R)
 *
 * The input are two unsigned long's `L' and `R' with `L' as the first
 * 32 bits in the block and `R' as the rest. The first bit of each `L'
 * and `R' are the least significant of each.
 * The ouput is an array of unsigned characters `B[0..7]' with the
 * least significant bit of `B[0]' as the first bit.
 *
 * The macro IPinv_DATA must be placed in the declaration section in the
 * enclosing procedure to IPinv. It contains variables used by IPinv;
 */

static char	*prog;
static char	*base;
static int	c_file = 0;


main(argc, argv)
int	argc;
char	*argv[];
{
#if defined(USE_IF) || defined(USE_SHIFT)
# ifdef USE_SHIFT
	register int		shift;
# else  /* USE_SHIFT */
	register unsigned long	bb;
# endif /* USE_SHIFT */
	register int		n, r, c, block_bit, byte, bit, byte_bit;
	register unsigned long	b;
#else  /* USE_IF || USE_SHIFT */
	register unsigned long	l, r;
	register int		i, j, byte, bit, n, sb, row, col;
	unsigned long		lv[UNSIGNED_CHAR_MAX + 1];
	unsigned long		rv[UNSIGNED_CHAR_MAX + 1];
#endif /* USE_IF || USE_SHIFT */


	prog = (prog = strrchr(*argv, '/')) ? (prog + 1) : *argv;
	if (argc != 3 || (strcmp(argv[1], "-c") && strcmp(argv[1], "-h")))
		goto usage;
	c_file = strcmp(argv[1], "-h");
	base = argv[2];


        (void) printf("/*\n");
	(void) printf(" * This file is automaticly generated, do not change.\n");
	(void) printf(" */\n\n");

	if (c_file) {
		(void) printf("#include\t\"local_def.h\"\n#include\t\"version.h\"\n");
		(void) printf("#include\t\"%s.h\"\n\n", base);
	}

#if defined(USE_IF) || defined(USE_SHIFT)
	if (c_file) {
		(void) printf("/* No global definitions. */\n");
	} else {
		(void) printf("#define IPinv(B, L, R) \\\n");
		for (n = byte = byte_bit = block_bit = r = 0; r < IPinv_ROWS; r++)
			for (c = 0; c < IPinv_COLUMNS; c++) {
				if (++byte_bit == 1) {
# ifdef USE_SHIFT
					(void) printf("\tB[%d] = ( \\\n", byte);
# else  /* USE_SHIFT */
					(void) printf("\tB[%d] = 0x00; \\\n", byte);
# endif /* USE_SHIFT */
				}

				n = ((int) ip_inv[r][c] - 1) / DES_L_BITS;
				bit = ip_inv[r][c] - (n * DES_L_BITS);
				b = 0x1l << (bit - 1);
# ifdef USE_SHIFT
#  ifdef DES_LSB_FIRST
				shift = byte_bit - bit;
#  else  /* DES_LSB_FIRST */
				shift = (UNSIGNED_CHAR_BITS + 1 - byte_bit) - bit;
#  endif /* DES_LSB_FIRST */
				(void) printf("\t\t((%c & 0x%08lxl)", n ? 'R' : 'L', b);
				if (shift > 0) 
					(void) printf(" << %2d", shift);
				else if (shift < 0)
					(void) printf(" >> %2d", -shift);
				else
					(void) printf("      ");
				if (byte_bit == UNSIGNED_CHAR_BITS) {
					(void) printf(")   /* bit %2d */ \\\n",
						      ++block_bit);
					(void) printf((++byte < DES_BLOCK_BYTES) ?
						      "\t); \\\n\\\n" : "\t)\n");
					byte_bit = 0;
				} else
					(void) printf(") | /* bit %2d */ \\\n",
						      ++block_bit);
# else  /* USE_SHIFT */
#  ifdef DES_LSB_FIRST
				bb = 0x1l << (byte_bit - 1);
#  else  /* DES_LSB_FIRST */
				bb = 0x1l << (UNSIGNED_CHAR_BITS - byte_bit);
#  endif /* DES_LSB_FIRST */
				(void) printf("\tif (%c & 0x%08lxl) B[%d] |= 0x%02lx",
					      n ? 'R' : 'L', b, byte, bb);
				if (byte_bit == UNSIGNED_CHAR_BITS) {
					if (++byte < DES_BLOCK_BYTES)
						(void) printf("; /* %2d -> %2d */ \\\n\\\n",
							      ip_inv[r][c], ++block_bit);
					else
						(void) printf("  /* %2d -> %2d */\n",
							      ip_inv[r][c], ++block_bit);
					byte_bit = 0;
				} else
					(void) printf("; /* %2d -> %2d */ \\\n",
						      ip_inv[r][c], ++block_bit);
# endif /* USE_SHIFT */
			}
	}
#else  /* USE_IF || USE_SHIFT */
	if (c_file) {
		(void) printf("#ifdef __SDTC__\nconst\n#endif\n");
		(void) printf("\t%s_t\tip_inv = {\n\t\t{\n", base);
		*lv = 0x0l;
		*rv = 0x0l;
		for (byte = 0; byte < DES_BLOCK_BYTES; byte++) {
			for (bit = 0; bit < UNSIGNED_CHAR_BITS; bit++) {
				sb = (byte * UNSIGNED_CHAR_BITS + bit) + 1;
				/*
				 * row and col can't be used directly as index
				 * variables due to the C-compiler on PS/2.
				 */
				row = col = 0;
				for (i = 0; i < IPinv_ROWS; i++)
					for (j = 0; j < IPinv_COLUMNS; j++)
						if (sb == ip_inv[i][j]) {
							row = i;
							col = j;
							goto next;
						}
next:
					sb = row * IPinv_COLUMNS;
# ifdef DES_LSB_FIRST
				sb += col;
# else
				sb += (UNSIGNED_CHAR_BITS - 1) - col;
# endif
				if (sb >= DES_L_BITS) {
					l = 0x0l;
					r = 0x1l << (sb - DES_L_BITS);
				} else {
					l = 0x1l << sb;
					r = 0x0l;
				}
				n = 0x1 << bit;
				lv[n] = l;
				rv[n] = r;
				if (n > 1)
					for (i = 1, j = n + 1; i < n; i++, j++) {
						lv[j] = l | lv[i];
						rv[j] = r | rv[i];
					}
			}
			for (i = 0; i < UNSIGNED_CHAR_MAX; i++)
				(void) printf("\t\t\t{ 0x%08lxl, 0x%08lxl },\n",
					      lv[i], rv[i]);
			(void) printf("\t\t\t{ 0x%08lxl, 0x%08lxl }\n\t\t}",
				      lv[i], rv[i]);
			if (byte < DES_BLOCK_BYTES - 1)
				(void) printf(", {\n");
		}
		(void) printf("\n\t};\n");
	} else {
		(void) printf("#define IPinv_DATA des_cblock\t\tobp; \\\n");
		(void) printf("\t\tregister unsigned long\tol, or\n\n");
		(void) printf("#define IPinv(B, L, R) \\\n");
		(void) printf("\tLONG_TO_CHAR_8(obp, L, R); \\\n");
		(void) printf("\tol  = ip_inv[0][obp[0]].l; or  = ip_inv[0][obp[0]].r; \\\n");
		for (i = 1; i < DES_BLOCK_BYTES; i++)
			(void) printf("\tol |= ip_inv[%d][obp[%d]].l; or |= ip_inv[%d][obp[%d]].r; \\\n",
				      i, i, i, i);
		(void) printf("\tLONG_TO_CHAR_8(B, ol, or)\n\n");
		(void) printf("typedef\tstruct {\n\t\t\tunsigned long\tl, r;\n\t\t} %s_t[%d][%d];\n\n",
			      base, DES_BLOCK_BYTES, UNSIGNED_CHAR_MAX + 1);
		(void) printf("extern\n#ifdef __SDTC__\n\tconst\n#endif\n");
		(void) printf("\t\t%s_t\tip_inv;\n", base);
	}
#endif /* USE_IF || USE_SHIFT */

	exit(0);

usage:
	(void) fprintf(stderr, "Usage: %s -c|-h base\n", prog);
	exit(1);
}
