/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	"des.h"
#include	"local_def.h"
#include	"version.h"

/*
 * des_cbc_cksum
 *
 *	Cipher Block Chaining Checksum.
 *
 */

unsigned long	des_cbc_cksum(
#ifdef __STDC__
	des_cblock		*input,
	des_cblock		*output,
	int			length,
	des_key_schedule	schedule,
	des_cblock		*ivec)
#else
	input, output, length, schedule, ivec)
des_cblock		*input;
des_cblock		*output;
int			length;
des_key_schedule	schedule;
des_cblock		*ivec;
#endif
{
	register int		i;
	register des_cblock	*ivecp;
	des_cblock		tmp_ivec;
	register unsigned long	res;


	if (des_return_ivec) {
		ivecp = ivec;
	} else {
		COPY_8(tmp_ivec, (*ivec));
		ivecp = (des_cblock *) tmp_ivec;
	}

	for (; length >= DES_BLOCK_BYTES; length -= DES_BLOCK_BYTES, input++) {
		XOR_8((*ivecp), (*input));
		(void) des_dea(ivecp, ivecp, schedule, DES_ENCRYPT);
	}
	if (length > 0) {
		/* This method procuces zero padding ! */
		for (i = 0; i < length; i++)
			(*ivecp)[i] ^= (*input)[i];
		(void) des_dea(ivecp, ivecp, schedule, DES_ENCRYPT);
	}
	COPY_8((*output), (*ivecp));

	res  = (unsigned long) (*output)[7];
	res <<= UNSIGNED_CHAR_BITS;
	res |= (unsigned long) (*output)[6];
	res <<= UNSIGNED_CHAR_BITS;
	res |= (unsigned long) (*output)[5];
	res <<= UNSIGNED_CHAR_BITS;
	res |= (unsigned long) (*output)[4];

	return	res;
}
