/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<errno.h>
#include	"encrypt.h"
#include	"des.h"
#include	"local_def.h"
#include	"version.h"


#define	BLOCK_TO_DES(block,des_block) \
{ \
	register unsigned int	i, bit, byte; \
\
\
	for (i = byte = 0; byte < 8; byte++) { \
		des_block[byte] = 0; \
		for (bit = 0x80; bit; i++, bit >>= 1) \
			if (block[i]) \
				des_block[byte] |= bit; \
	} \
}

#define DES_TO_BLOCK(des_block,block) \
{ \
	register unsigned int	i, bit, byte; \
\
\
	for (i = byte = 0; byte < 8; byte++) \
		for (bit = 0x80; bit; i++, bit >>= 1) \
			block[i] = (des_block[byte] & bit) ? 1 : 0; \
}


/*
extern int		errno;

static int		key_valid = 0;
*/
static des_key_schedule	key_schedule;

/*
 * setkey
 *
 *	setkey - Optional X/Open set encoding key.
 *
 */

#ifdef __STDC__
void
#endif
	setkey(
#ifdef __STDC__
	char	*key)
#else
	key)
char	*key;
#endif
{
	des_cblock	des_block;


	BLOCK_TO_DES(key, des_block);

	(void) des_fixup_key_parity((des_cblock *) des_block);

	(void) des_sched((des_cblock *) des_block, key_schedule);

/*
	key_valid = 1;
*/
}

/*
 * encrypt
 *
 *	encrypt - Optional X/Open encoding function.
 *
 */

#ifdef __STDC__
void
#endif
	encrypt(
#ifdef __STDC__
	char	block[64],
	int	edflag)
#else
	block, edflag)
char	block[64];
int	edflag;
#endif
{
	des_cblock	crypt_block;


/*
	if (!key_valid) {
		errno = EINVAL;
		return;
	}
*/

	BLOCK_TO_DES(block, crypt_block);

	(void) (*des_core)((des_cblock *) crypt_block,
			   (des_cblock *) crypt_block,
			    key_schedule,
			    (edflag) ? DES_DECRYPT : DES_ENCRYPT);

	DES_TO_BLOCK(crypt_block, block);
}
