/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	"des.h"
#include	"local_def.h"
#include	"version.h"



/*
 * des_strkey_mit
 *
 *	Transfomration of a an arbitrary null terminated string to a 64 bit
 *	block.
 *
 *	This algorithm SHOULD be the same as used in the MIT DES package
 *	used in the Kerberos system.
 *
 */

int	des_strkey_mit(
#ifdef __STDC__
	char		*str,
	des_cblock	key)
#else
	str, key)
char		*str;
des_cblock	key;
#endif
{
	register int		i;
	register unsigned char	*cp, c;
	des_cblock		ivec;
	des_key_schedule	schedule;


	DES_ZERO_CBLOCK(ivec);
	cp = (unsigned char *) str;
	while (*cp) {
		for (i = 0; *cp && i < DES_BLOCK_BYTES; i++)
			ivec[i] ^= *cp++;
		while (*cp && --i >= 0) {
			c = *cp++ << 1;
			CHAR_ROTATE(c);	
			ivec[i] ^= c;
		}
	}
	for (i = 0; i < DES_BLOCK_BYTES; i++)
		ivec[i] <<= 1;
	i = (int) (cp - (unsigned char *) str);

	(void) des_fixup_key_parity((des_cblock *) ivec);
	(void) des_sched((des_cblock *) ivec, schedule);
	(void) des_cbc_cksum((des_cblock *) str, (des_cblock *) key, i,
			     schedule, (des_cblock *) ivec);

	return 0;
}
