/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */


#define IVEC_HEX_FLAG	0x01	/* The ivec is a hexadecimal numbers.	    */
#define IVEC_STRING_FLAG 0x02	/* The ivec is in `ivec_spec'.		    */
#define IVEC_FILE_FLAG	0x04	/* The ivec is in the file `ivec_spec[0].   */
#define IVEC_PROMPT_FLAG 0x08	/* Prompt for ivec.			    */
#define IVEC_VERIFY_FLAG 0x10	/* Verify & prompt for ivec.		    */


/*
 * getivec_file
 *
 *	This routine reads a ivec from `file'.
 *
 *	`getivec_file' returns 1 if the call was successful, otherwise 0.
 *	-1 indicates an i/o error.
 *
 */

extern int	getivec_file(
#ifdef __STDC__
	des_cblock	ivec,
	char		*file
#endif
);


/*
 * putivec_file
 *
 *	This routine writes a ivec to `file'.
 *
 *	`putivec_file' returns 1 if the call was successful, otherwise 0.
 *	-1 indicates an i/o error.
 *
 */

extern int	putivec_file(
#ifdef __STDC__
	des_cblock	ivec,
	char		*file
#endif
);


/*
 * getivec_env
 *
 *	This routine fetches a ivec from the environment.
 *
 *	`getivec_env' returns 1 on sucess, otherwise 0. -1 indicates that the
 *	specified number of ivecs could not be obtained.
 *
 */

extern int	getivec_env(
#ifdef __STDC__
	des_cblock	ivec
#endif
);


/*
 * getivec_prompt
 *
 *	This routine prompts for an ivec. The ivec found is returned
 *	through `ivec'.
 *
 *	`getivec_prompt' returns 1 on sucess, otherwise 0. -1 indicates
 *	an internal error.
 *
 */

extern int	getivec_prompt(
#ifdef __STDC__
	des_cblock	ivec,
	int		flags
#endif
);


/*
 * getivec
 *
 *	This routine reads a ivec from a file, argument or prompts for
 *	it. The method to get the ivec is selected through `flags'.
 *	The ivec found is returned through `ivec'.
 *
 *	`getivec' returns 1 on sucess, otherwise 0. -1 indicates an
 *	internal error.
 *
 */

extern int	getivec(
#ifdef __STDC__
	des_cblock	ivec,
	char		*ivec_spec,
	int		flags
#endif
);
