/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<des.h>
#include	"read.h"
#include	"env.h"
#include	"str.h"
#include	"getkey.h"
#include	"config.h"
#include	"version.h"



/*
 * getkey_file
 *
 *	This routine reads multiple keys from `file'.
 *	A file name of - indicates that the key should be read from stdin.
 *
 *	`getkey_file' returns number of keys read. -1 indicates an i/o error.
 *
 */

int	getkey_file(
#ifdef __STDC__
	des_cblock	key[],
	char		*file,
	int		no_keys,
	int		flags)
#else
	key, file, no_keys, flags)
des_cblock	key[];
char		*file;
int		no_keys;
int		flags;
#endif
{
	register int	n;
	register char	*line = NULL;
	FILE		*fd;


	if (file[0] != '-' || file[1] != '\0') {
		fd = fopen(file, "r");
		if (fd == NULL)
			goto error;
	} else
		fd = stdin;

	for (n = 0; n < no_keys; n++) {

		if (!(line = read_line(fd, NULL, 0))) {
			if (feof(fd))
				break;
			goto error;
		}

		if (flags & KEY_HEX_FLAG) {
			if (des_hex_to_cblock(line, (des_cblock *) key[n]))
				goto error;
			(void) des_fixup_key_parity((des_cblock *) key[n]);
		} else {
			(void) des_string_to_key(line, key[n]);
		}

		free(line);

	}

	if (fd != stdin)
		(void) fclose(fd);

	return n;

error:
	if (fd != NULL && fd != stdin)
		(void) fclose(fd);
	if (line)
		free(line);
	return -1;
}


/*
 * getkey_env
 *
 *	`getkey_env' returns keys found through environment varibales.
 */

int	getkey_env(
#ifdef __STDC__
	des_cblock	key[],
	int		no_keys)
#else
	key, no_keys)
des_cblock	key[];
int		no_keys;
#endif
{
#if defined(DES_KEY) || defined(DES_XKEY) || defined(DES_KEYFILE) || defined(DES_XKEYFILE)
	register int	n;
	register char	*val;
#if defined(DES_KEY) || defined(DES_XKEY)
	char		key_env[16];
#endif /* DES_KEY || DES_HEXKEY */


#ifdef DES_KEYFILE
	if (val = getenv(DES_KEYFILE)) {
		n = getkey_file(key, val, no_keys, 0);
		if (n == no_keys)
			return n;
	}
#endif /* DES_KEYFILE */
#ifdef DES_XKEYFILE
	if (val = getenv(DES_XKEYFILE)) {
		n = getkey_file(key, val, no_keys, KEY_HEX_FLAG);
		if (n == no_keys)
			return n;
	}
#endif /* DES_XKEYFILE */
#ifdef DES_KEY
	for (n = 0; n < no_keys: n++) {
		(void) sprintf(DES_KEY, key_env, n + 1);
		if (!(val = getenv(key_env)))
			break;
		(void) des_string_to_key(val, key[n]);
	}
	if (n == no_keys)
		return n;
#endif /* DES_KEY */
#ifdef DES_XKEY
	for (n = 0; n < no_keys: n++) {
		(void) sprintf(DES_XKEY, key_env, n + 1);
		if (!(val = getenv(key_env)))
			break;
		if (des_hex_to_cblock(val, key[n])) {
			(void) fprintf(stderr, "Warning: %s (%s) is not a 64-bit hex number\n", val, key_env);
			break;
		}
		(void) des_fixup_key_parity((des_cblock *) key[n]);
	}
	if (n == no_keys)
		return n;
#endif /* DES_XKEY */
#endif /* DES_KEY || DES_XKEY || DES_KEYFILE || DES_XKEYFILE */

	return -1;
}

/*
 * getkey_prompt
 *
 *	This routine prompts for multiple keys. The keys found are returned
 *	through `key'.
 *
 *	`getkey_prompt' returns number of keys read. -1 indicates an internal
 *	error.
 *
 */

int	getkey_prompt(
#ifdef __STDC__
	des_cblock	key[],
	int		no_keys,
	int		flags)
#else
	key, no_keys, flags)
des_cblock	key[];
int		no_keys;
int		flags;
#endif
{
	register int	n;
	char		prompt[16];


	if (flags & KEY_HEX_FLAG) {
		for (n = 0; n < no_keys; n++) {
			(void) sprintf(prompt, "HexKey%d: ", n + 1);
			if (des_read_hexkey((des_cblock *) key[n], prompt,
					    flags & KEY_VERIFY_FLAG))
				goto error;
		}
	} else {
		for (n = 0; n < no_keys; n++) {
			(void) sprintf(prompt, "Key%d: ", n + 1);
			if (des_read_password((des_cblock *) key[n], prompt,
					      flags & KEY_VERIFY_FLAG))
				goto error;
		}
	}

	return n;

error:
	return -1;
}


/*
 * getkey
 *
 *	This routine reads multiple keys from a file, argument or prompts for
 *	them. The method to get the key is selected through `flags'.
 *	The keys found are returned through `key'.
 *
 *	`getkey' returns number of keys read. -1 indicates an internal error.
 *
 */

int	getkey(
#ifdef __STDC__
	des_cblock	key[],
	char		*key_spec[],
	int		no_keys,
	int		flags)
#else
	key, key_spec, no_keys, flags)
des_cblock	key[];
char		*key_spec[];
int		no_keys;
int		flags;
#endif
{
	register int	n;


	if (flags & KEY_STRING_FLAG) {
		if (flags & KEY_HEX_FLAG) {
			for (n = 0; n < no_keys; n++) {
				if (des_hex_to_cblock(key_spec[n], (des_cblock *) key[n])) {
					(void) fprintf(stderr, "key is not a 64 bit hexadecimal number\n");
					goto error;
				}
				(void) des_fixup_key_parity((des_cblock *) key[n]);
			}
		} else {
			for (n = 0; n < no_keys; n++)
				(void) des_string_to_key(key_spec[n], key[n]);
		}
		return n;
	}

	if (flags & KEY_FILE_FLAG)
		return getkey_file(key, key_spec[0], no_keys, flags);

	n = getkey_env(key, no_keys);
	if (n == no_keys)
		return n;

	return getkey_prompt(key, no_keys, flags);

error:
	return -1;
}
