/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdio.h>
#include	<des.h>
#include	"io.h"
#include	"config.h"
#include	"version.h"


#define BUF_SIZE	8192


/*
 * ASCII input/output functions
 */

int	ascii_read(
#ifdef __STDC__
	char		*ptr,
	unsigned	ptr_size,
	unsigned	items,
	FILE		*fd)
#else
	ptr, ptr_size, items, fd)
char		*ptr;
unsigned	ptr_size;
unsigned	items;
FILE		*fd;
#endif
{
	register int	n, l, r;
	char		buf[BUF_SIZE];

	
	n = ptr_size * items;
	r = 0;
	while (n >= DES_BLOCK_BYTES) {
		if (fgets(buf, BUF_SIZE, fd) == NULL)
			break;
		l = strlen(buf) - 1;
		if (buf[l] != '\n')
			continue;
		buf[l] = '\0';
		if (des_hex_to_cblock(buf, (des_cblock *) ptr))
			continue;
		r += DES_BLOCK_BYTES;
		ptr += DES_BLOCK_BYTES;
		n -= DES_BLOCK_BYTES;
	}
	return r / ptr_size;
}


int	ascii_write(
#ifdef __STDC__
	char		*ptr,
	unsigned	ptr_size,
	unsigned	items,
	FILE		*fd)
#else
	ptr, ptr_size, items, fd)
char		*ptr;
unsigned	ptr_size;
unsigned	items;
FILE		*fd;
#endif
{
	register int	n;
	des_cblock	*b;

	
	b = (des_cblock *) ptr;
	n = ptr_size * items;
	n = des_print_cblock(fd, b, n / DES_BLOCK_BYTES);
	return n * DES_BLOCK_BYTES;
}
