/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include	<stdlib.h>
#include	<des.h>
#include	"str.h"
#include	"getkey.h"
#include	"core.h"
#include	"compat.h"
#include	"config.h"
#include	"version.h"

#define b_FLAG		0x001L
#define f_FLAG		0x002L
#define h_FLAG		0x004L
#define k_FLAG		0x008L
#define n_FLAG		0x010L
#define r_FLAG		0x020L
#define R_FLAG		0x040L
#define s_FLAG		0x080L

#define MAX_RETRY	10

unsigned long	flags = 0L;
char		*prog;


main(argc, argv)
int	argc;
char	*argv[];
{
	register int	i, o, keys, no_keys, key_flags, retry;
	register char	*core_name, *compat_name;
	core_mode	*core;
	crypt_compat	*compat;
	char		*key_spec[DES_MAX_KEYS];
	des_cblock	key[DES_MAX_KEYS];
	extern int	optind;
	extern char	*optarg;


	prog = (prog = strrchr(*argv, '/')) ? (prog + 1) : *argv;

	keys = 0;
	core_name = NULL;
	compat_name = NULL;
	core = (core_mode *) 0;
	compat = (crypt_compat *) 0;
	key_flags = KEY_VERIFY_FLAG;
	no_keys = 1;
	for (i = 0; i < DES_MAX_KEYS; i++)
		key_spec[i] = NULL;

	while ((o = getopt(argc, argv, "3b:f:hk:n:rRs")) != EOF)
		switch (o) {
		case 'b':
			if (flags & b_FLAG)
				goto usage;
			if ((compat_name = new_string(optarg)) == NULL)
				goto memalloc;
			flags |= b_FLAG;
			break;
		case 'f':
			if (flags & (f_FLAG | k_FLAG | r_FLAG | R_FLAG))
				goto usage;
			if ((key_spec[0] = new_string(optarg)) == NULL)
				goto memalloc;
			null_string(optarg);
			flags |= f_FLAG;
			key_flags |= KEY_FILE_FLAG;
			break;
		case 'h':
			if (flags & h_FLAG)
				goto usage;
			flags |= h_FLAG;
			key_flags |= KEY_HEX_FLAG;
			break;
		case 'k':
			if (flags & (f_FLAG | r_FLAG | R_FLAG))
				goto usage;
			if (keys >= DES_MAX_KEYS)
				goto maxkey;
			if ((key_spec[keys++] = new_string(optarg)) == NULL)
				goto memalloc;
			null_string(optarg);
			flags |= k_FLAG;
			key_flags |= KEY_STRING_FLAG;
			break;
		case 'n':
			if (flags & n_FLAG)
				goto usage;
			flags |= n_FLAG;
			if (isdigit(*optarg)) {
				for (i = 1; optarg[i] && isdigit(optarg[i]); i++);
				if (!optarg[i]) {
					no_keys = atoi(optarg);
					if (no_keys > DES_MAX_KEYS)
						goto maxkey;
					break;
				}
			}
			if ((core_name = new_string(optarg)) == NULL)
				goto memalloc;
			break;
		case 'r':
			if (flags & (f_FLAG | k_FLAG | r_FLAG | R_FLAG))
				goto usage;
			flags |= r_FLAG;
			break;
		case 'R':
			if (flags & (f_FLAG | k_FLAG | r_FLAG | R_FLAG))
				goto usage;
			flags |= R_FLAG;
			break;
		case 's':
			if (flags & h_FLAG)
				goto usage;
			flags |= s_FLAG;
			break;
		case '?':
		default:
			goto usage;
		}
	if (flags & k_FLAG && keys != no_keys)
		goto usage;
	if (optind != argc)
		goto usage;

	if (!((flags & n_FLAG) && !core_name)) {
		if (!(core = getcore(core_name)))
			goto nocore;
		if (flags & n_FLAG) {
			free(core_name);
			core_name = NULL;
		}
		no_keys = core->no_keys;
	}

	if (!(compat = getcompat(compat_name)))
		goto nocompat;
	if (flags & b_FLAG) {
		free(compat_name);
		compat_name = NULL;
	}
	des_strkey = compat->strkey;

	if (flags & r_FLAG) {
		for (i = 0; i < no_keys; i++) {
			retry = MAX_RETRY;
			do {
				(void) des_random_key((des_cblock *) key[i]);
				if (retry-- > 0)
					break;
			} while (des_is_weak_key((des_cblock *) key[i]) ||
				 des_is_semiweak_key((des_cblock *) key[i]));
		}
	} else if (flags & R_FLAG) {
		for (i = 0; i < no_keys; i++)
			(void) des_random_cblock((des_cblock *) key[i]);
	} else if (no_keys != getkey(key, key_spec, no_keys, key_flags))
			goto nokey;

	for (i = 0; i < DES_MAX_KEYS; i++)
		if (key_spec[i] != NULL) {
			null_string(key_spec[i]);
			free(key_spec[i]);
		}

	for (i = 0; i < no_keys; i++) {
		if (!(flags & (R_FLAG | s_FLAG))) {
			if (des_is_weak_key((des_cblock *) key[i])) {
				fprintf(stderr, "%s: Warning: key %d is weak\n",
					prog, i + 1);
			} else if (des_is_semiweak_key((des_cblock *) key[i])) {
				fprintf(stderr, "%s: Warning: key %d is semi-weak\n",
					prog, i + 1);
			}
		}
		(void) des_print_cblock(stdout, (des_cblock *) key[i], 1);
		DES_ZERO_CBLOCK(key[i]);
	}

	exit(0);

usage:
	(void) fprintf(stderr, "Usage %s [-s] [-b compat] [-n core|#] [-f file|-r|-R|-k key [-k key ...]]\n", prog);
	exit(1);

memalloc:
	fputs(prog, stderr);
	perror(": Could not allocate memory, ");
	exit(1);

nocore:
	(void) fprintf(stderr,
#ifdef DES_CORE
		       (!core_name) ?
		       		"%s: Unknown core algorithm in environment variable DES_CORE\n" :
#endif /* DES_CORE */
		       		"%s: No core algorithm \"%s\" available.\n",
		       prog, core_name);
	if (flags & n_FLAG)
		free(core_name);
	exit(1);

nocompat:
	(void) fprintf(stderr,
#ifdef DES_COMPATIBLE
		       (!compat_name) ?
		       		"%s: Unknown compatible mode in environment variable DES_COMPATIBLE\n" :
#endif /* DES_COMPATIBLE */
				"%s: No compatibility mode \"%s\" found.\n",
		       prog, compat_name);
	if (flags & b_FLAG)
		free(compat_name);
	exit(1);

nokey:
	(void) fprintf(stderr, "%s: Could not obtain key\n", prog);
	exit(1);

maxkey:
	(void) fprintf(stderr, "%s: Max %d keys allowed\n", prog, DES_MAX_KEYS);
	exit(1);

nofilekey:
	(void) fprintf(stderr, "%s: Could not read key from \"%s\"\n", prog, key_spec);
	for (i = 0; i < no_keys; i++) {
		null_string(key_spec[i]);
		free(key_spec[i]);
	}
	exit(1);
}
