/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<des.h>
#include	<stdio.h>
#include	"compat.h"
#include	"config.h"
#include	"version.h"


crypt_compat	compat_list[] = {
				{
					"MIT",
					des_strkey_mit,
#ifdef CRYPT
					def_pad_data
#else  /* CRYPT */
					(pad_func) 0
#endif /* CRYPT */
				},
				{
					"CTH",
					des_strkey_cth,
#ifdef CRYPT
					def_pad_data
#else  /* CRYPT */
					(pad_func) 0
#endif /* CRYPT */
				},
				{
					"SUN",
					des_strkey_sun,
#ifdef CRYPT
					sun_pad_data
#else  /* CRYPT */
					(pad_func) 0
#endif /* CRYPT */
				},
				{
					(char *) 0,
					(strkey_func) 0,
					(pad_func) 0,
				}
		};
