#! /bin/sh
#
#                         DES SOFTWARE PACKAGE
#                             Version 2.2
#
#                                        _
# Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
# All Rights Reserved
#
#
# The author takes no responsibility of actions caused by the use of this
# software package and does not guarantee the correctness of the functions.
#
# This software package may be freely distributed for non-commercial purpose
# as long as the copyright notice is kept. Any changes made should be
# accompanied by a comment indicating who made the change, when it was made
# and what was changed.
#
# This software package, or any parts of it, may not be used or in any way
# re-distributed for commercial purpose without the authors permission.
# The author keeps the right to decide between of what is commercial and
# what is non-commercial purpose.
#
# Restrictions due to national laws governing the use, import or export of
# cryptographic software is the responsibility of the software user/importer/
# exporter to follow.
#
#
#                                              _
#                                         Stig Ostholm
#                                         Chalmers University of Technology
#                                         Department of Computer Engineering
#                                         S-412 96 Gothenburg
#                                         Sweden
#                                         ----------------------------------
#                                         Email: ostholm@ce.chalmers.se
#                                         Phone: +46 31 772 1703
#                                         Fax:   +46 31 772 3663
# 

#
# This script test different variants of the indicated sources and 
# generates a configuration for the variant with best performance
#

PROG="`IFS=/; set $0; eval echo '$'$#`"
USAGE="Usage: ${PROG} [-s] [VAR=value ...] [-o out] [-d data_file] [-f config] [target]"


TOPDIR=../..
DEFINES=
MAKE=make
MAKE_ARGS=
RM='rm -f'
ECHO=echo
VERBOSE=

OUT=
TARGET=bench
BENCH_FILE=bench.$$
FILE=bench.cr
BENCH_REMOVES=
BENCH_LOOPS=100000
BENCH_OBJS=

while :; do
	case $# in
	0)	break;;
	esac
	case "$1" in
	[A-Z]*=*)
		if VAR="`expr \"$1\" : '^\([^=]*\)=.*$'`"; then
			case "$1" in
			"${VAR}=")
				eval "${VAR}="
				shift
				continue;;
			esac
			if VAL="`expr \"$1\" : \"^${VAR}=\(.*\)\$\"`"; then
				if eval "${VAR}=\"\${VAL}\""; then
					:
				else
					exit 1
				fi
			else
				exit 1
			fi
		else
			exit 1
		fi
		MAKE_ARGS="${MAKE_ARGS} \"${VAR}=\${${VAR}}\"";;
	-*s*)	VERBOSE=:;;
	-f)	shift
		case $# in
		0)	echo "${USAGE}" >&2
			exit 1;;
		esac
		CONFIG="$1";;
	-d)	shift
		case $# in
		0)	echo "${USAGE}" >&2
			exit 1;;
		esac
		BENCH_FILE="$1";;
	-o)	shift
		case $# in
		0)	echo "${USAGE}" >&2
			exit 1;;
		esac
		OUT="$1";;
	--)	shift
		break;;
	-*)	:;;
	*)	break;;
	esac
	shift
done
case "${BENCH_REMOVES}" in
'')	BENCH_REMOVES="${TARGET} ${BENCH_OBJS}";;
esac
case "${MAKE_ARGS}" in
'')	MAKE_ARGS='DEFINES=${DEFINES}';;
esac
case $# in
0)	:;;
1)	TARGET="$1";;
*)	echo "${USAGE}" >&2
	exit 1;;
esac
case "${VERBOSE}" in
'')	VERBOSE="${ECHO}";;
esac


eval $VERBOSE 'TESTING CONFIGURATIONS FOR SPEED'
(
	LOW_TIME=200
	HIGH_TIME=1000
	MIN_LOOPS=1000
	LOOPS=${BENCH_LOOPS}
	LOOPS_SET=0
	DEF_DEFINES="${DEFINES}"

	eval ${VERBOSE} "\"${RM} ${BENCH_REMOVES} ${TARGET}.o ${BENCH_FILE}\""
	eval ${RM} ${BENCH_REMOVES} ${TARGET}.o ${BENCH_FILE}
	while read DEFS; do
		case "${DEFS}" in
		'#'*)	continue;;
		esac

		DEFINES="${DEF_DEFINES}"
		for D in $DEFS; do
			DEFINES="${DEFINES} -D${D}"
		done

		eval ${VERBOSE} "${MAKE} ${MAKE_ARGS} ${TARGET}"
		if eval ${MAKE} ${MAKE_ARGS} ${TARGET}; then
			:
		else
			eval ${RM} ${BENCH_REMOVES}
			exit 1
		fi
		MEAN_TIME=0
		for N in 1 2 3 4 5; do
			if TIME="`./${TARGET} ${LOOPS}`"; then
				case $LOOPS_SET in
				0)	if [ $TIME -gt $HIGH_TIME ]; then
						LOOPS=`expr \( $LOOPS \* $HIGH_TIME \) / $TIME`
					elif [ $TIME -lt $LOW_TIME ]; then
						LOOPS=`expr \( $LOOPS \* $LOW_TIME \) / $TIME`
					fi
					if [ $LOOPS -lt $MIN_LOOPS ]; then
						LOOPS=$MIN_LOOPS
					fi
					case $LOOPS in
					$BENCH_LOOPS)
						:;;
					*)	eval $VERBOSE "'LOOPS adjusted from ${BENCH_LOOPS} to ${LOOPS}'"
						TIME="`./${TARGET} ${LOOPS}`";;
					esac
					LOOPS_SET=1;;
				esac
			else
				eval ${RM} ${BENCH_REMOVES}
				exit 1
			fi
			eval $VERBOSE "'	${TIME} ${DEFS}'"
			MEAN_TIME=`expr $MEAN_TIME + $TIME`
		done
		MEAN_TIME=`expr $MEAN_TIME / $N`
		eval $VERBOSE "'      -----------'"
		eval $VERBOSE "'	${MEAN_TIME} ${DEFS}'"
		if eval $ECHO "'${MEAN_TIME} ${DEFS}'" '>>' ${BENCH_FILE}; then
			eval ${RM} ${BENCH_REMOVES}
		else
			eval ${RM} ${BENCH_REMOVES} ${BENCH_FILE}
			exit 1
		fi
	done

) < "${CONFIG}"

case $? in
[1-9]*)	exit $?;;
esac

(
	if read TIME DEFS; then
		while read TEST_TIME TEST_DEFS; do
			if [ $TIME -gt $TEST_TIME ]; then
				TIME=$TEST_TIME
				DEFS="${TEST_DEFS}"
			fi
		done
	else
		exit 1
	fi
	eval $VERBOSE "'SELECTED CONFIGURATION: ${DEFS} /* $TIME */'"
	case "${OUT}" in
	?*)	exec > "${OUT}";;
	esac
	eval $ECHO "'/*'"
	eval $ECHO "' * This file is automaticly generated, do not change.'"
	eval $ECHO "' * TIME = ${TIME}.'"
	eval $ECHO "' */'"
	eval $ECHO
	for D in $DEFS; do
		eval $ECHO "'#define ${D}'"
	done
	eval $ECHO
) < "${BENCH_FILE}"

exit $?
