#! /bin/sh
#
#                         DES SOFTWARE PACKAGE
#                             Version 2.2
#
#                                        _
# Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
# All Rights Reserved
#
#
# The author takes no responsibility of actions caused by the use of this
# software package and does not guarantee the correctness of the functions.
#
# This software package may be freely distributed for non-commercial purpose
# as long as the copyright notice is kept. Any changes made should be
# accompanied by a comment indicating who made the change, when it was made
# and what was changed.
#
# This software package, or any parts of it, may not be used or in any way
# re-distributed for commercial purpose without the authors permission.
# The author keeps the right to decide between of what is commercial and
# what is non-commercial purpose.
#
# Restrictions due to national laws governing the use, import or export of
# cryptographic software is the responsibility of the software user/importer/
# exporter to follow.
#
#
#                                              _
#                                         Stig Ostholm
#                                         Chalmers University of Technology
#                                         Department of Computer Engineering
#                                         S-412 96 Gothenburg
#                                         Sweden
#                                         ----------------------------------
#                                         Email: ostholm@ce.chalmers.se
#                                         Phone: +46 31 772 1703
#                                         Fax:   +46 31 772 3663
# 

PROG="`IFS=/; set $0; eval echo '$'$#`"
USAGE="Usage: ${PROG} [VAR=value ...] [-f file] srcfile ..."

CC=cc
RM='rm -f'
ECHO=echo
MV='mv'
CFLAGS=
FILE=
VERBOSE=

while :; do
	case $# in
	0)	echo "${USAGE}" >&2
		exit 1;;
	esac
	case "$1" in
	[A-Z]*=*)
		if VAR="`expr \"$1\" : '^\([^=]*\)=.*$'`"; then
			case "$1" in
			"${VAR}=")
				eval "${VAR}="
				shift
				continue;;
			esac
			if VAL="`expr \"$1\" : \"^${VAR}=\(.*\)\$\"`"; then
				if eval "${VAR}=\"\${VAL}\""; then
					:
				else
					exit 1
				fi
			else
				exit 1
			fi
		else
			exit 1
		fi;;
	-f)	shift
		case $# in
		0)	echo "${USAGE}" >&2
			exit 1;;
		esac
		FILE="$1";;
	-*s*)	VERBOSE=:;;
	--)	shift
		break;;
	-*)	:;;
	*)	break;;
	esac
	shift
done
case $# in
0)	echo "${USAGE}" >&2
	exit 1;;
esac
case "${VERBOSE}" in
'')	VERBOSE="${ECHO}";;
esac
case "${FILE}" in
'')	for FILE in makefile Makefile; do
		if [ -f "${FILE}" ]; then
			break;
		fi
	done;;
esac
if [ ! -f "${FILE}" ]; then
	eval $ECHO "'Can not find file'" >&2
	exit 1
fi
NEW_FILE="${FILE}.NEW"
BAK_FILE="${FILE}.BAK"


(
	awk '/^# DEPEND/ {
		print;
		exit;
	}
	{
		print;
	}
	END {
		print "#";
		print "# Don not change the lines below, run make depend";
		print "#";
	}' $FILE

	eval ${CC} -M ${CFLAGS} $@ | \
	awk -F: 'BEGIN {
		target = "";
		depend = "";
	}
	$1 != target {
		if (depend != "") {
			print ptarget depend;
			depend = "";
		}
		target = $1;
		if (length(target) < 8) {
			ptarget = target "		:";
		} else {
			ptarget = target "	:";
		}
	}
	{
		tmp = depend " " $2;
		if (length(tmp) > 66) {
			print ptarget depend;
			depend = $2;
		} else {
			depend = tmp;
		}
	}
	END {
		if (depend != "") {
			print ptarget depend;
		}
	}' - | sed 's/  */ /g'
) > $NEW_FILE

case $? in
0)	if evak $MV $FILE $BAK_FILE; then
		if eval $MV $NEW_FILE $FILE; then
			exit 0
		else
			eval $RM NEW_FILE
			eval $MV $BAK_FILE $FILE
			exit 1
		fi
	else
		exit 1
	fi;;
*)	eval $RM $NEW_FILE
	exit 1;;
esac
