#! /bin/sh
#
#                         DES SOFTWARE PACKAGE
#                             Version 2.2
#
#                                        _
# Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
# All Rights Reserved
#
#
# The author takes no responsibility of actions caused by the use of this
# software package and does not guarantee the correctness of the functions.
#
# This software package may be freely distributed for non-commercial purpose
# as long as the copyright notice is kept. Any changes made should be
# accompanied by a comment indicating who made the change, when it was made
# and what was changed.
#
# This software package, or any parts of it, may not be used or in any way
# re-distributed for commercial purpose without the authors permission.
# The author keeps the right to decide between of what is commercial and
# what is non-commercial purpose.
#
# Restrictions due to national laws governing the use, import or export of
# cryptographic software is the responsibility of the software user/importer/
# exporter to follow.
#
#
#                                              _
#                                         Stig Ostholm
#                                         Chalmers University of Technology
#                                         Department of Computer Engineering
#                                         S-412 96 Gothenburg
#                                         Sweden
#                                         ----------------------------------
#                                         Email: ostholm@ce.chalmers.se
#                                         Phone: +46 31 772 1703
#                                         Fax:   +46 31 772 3663
# 

#
# This program removes all occurences of the text pattern
# "([    ]*void[         ]*)[    ]*" from a file and produces the result
# om `stdout'.
# The progrm can be used together with C-compilers that lacks the "(void)"
# typecast. Put the following lines in all Makefiles if so:
#
#.c.o:
#	${TOPDIR}/util/unvoid.sh $* > tmp.c
#	${CC} ${CFLAGS} -c tmp.c
#	mv tmp.o $@
#

PROG="`IFS=/; set $0; eval echo '$'$#`"
USAGE="Usage: ${PROG} [VAR=value ...] [-*] file"

ECHO=echo

while :; do
	case $# in
	0)	echo "${USAGE}" >&2
		exit 1;;
	esac
	case "$1" in
	[A-Z]*=*)
		if VAR="`expr \"$1\" : '^\([^=]*\)=.*$'`"; then
			case "$1" in
			"${VAR}=")
				eval "${VAR}="
				shift
				continue;;
			esac
			if VAL="`expr \"$1\" : \"^${VAR}=\(.*\)\$\"`"; then
				if eval "${VAR}=\"\${VAL}\""; then
					:
				else
					exit 1
				fi
			else
				exit 1
			fi
		else
			exit 1
		fi;;
	--)	shift
		break;;
	-*)	:;;
	*)	break;;
	esac
	shift
done
case $# in
1)	:;;
*)	echo "${USAGE}" >&2
	exit 1;;
esac

sed -e 's/([ 	]*void[ 	]*)[ 	]*//g' < "$1"
exit $?
