#! /bin/sh
#
#                         DES SOFTWARE PACKAGE
#                             Version 2.2
#
#                                        _
# Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
# All Rights Reserved
#
#
# The author takes no responsibility of actions caused by the use of this
# software package and does not guarantee the correctness of the functions.
#
# This software package may be freely distributed for non-commercial purpose
# as long as the copyright notice is kept. Any changes made should be
# accompanied by a comment indicating who made the change, when it was made
# and what was changed.
#
# This software package, or any parts of it, may not be used or in any way
# re-distributed for commercial purpose without the authors permission.
# The author keeps the right to decide between of what is commercial and
# what is non-commercial purpose.
#
# Restrictions due to national laws governing the use, import or export of
# cryptographic software is the responsibility of the software user/importer/
# exporter to follow.
#
#
#                                              _
#                                         Stig Ostholm
#                                         Chalmers University of Technology
#                                         Department of Computer Engineering
#                                         S-412 96 Gothenburg
#                                         Sweden
#                                         ----------------------------------
#                                         Email: ostholm@ce.chalmers.se
#                                         Phone: +46 31 772 1703
#                                         Fax:   +46 31 772 3663
# 

PROG="`IFS=/; set $0; eval echo '$'$#`"
USAGE="Usage: ${PROG} [VAR=value ...] [-s]"

TOPDIR=..
TMP_DIR='/tmp'

STAT_FILE="${TMP_DIR}/${PROG}.st.$$"

TEXT='/usr/dict/words'
CRYPT="${TMP_DIR}/${PROG}.CR.$$"
CLEAR="${TMP_DIR}/${PROG}.CL.$$"
KEY_FILE="${TMP_DIR}/${PROG}.key.$$"
XKEY_FILE="${TMP_DIR}/${PROG}.xkey.$$"
XIVEC_FILE="${TMP_DIR}/${PROG}.xivec.$$"

CRYPT_PROG=${TOPDIR}/prog/descrypt
KEY_PROG=${TOPDIR}/prog/deskey

FLAGS=
RM='rm -f'
ECHO=echo
VERBOSE=

while :; do
	case $# in
	0)	break;;
	esac
	case "$1" in
	[A-Z]*=*)
		if VAR="`expr \"$1\" : '^\([^=]*\)=.*$'`"; then
			case "$1" in
			"${VAR}=")
				eval "${VAR}="
				shift
				continue;;
			esac
			if VAL="`expr \"$1\" : \"^${VAR}=\(.*\)\$\"`"; then
				if eval "${VAR}=\"\${VAL}\""; then
					:
				else
					exit 1
				fi
			else
				exit 1
			fi
		else
			exit 1
		fi;;
	-*s*)	FLAGS="${FLAGS} -s" VERBOSE=:;;
	--)	shift
		break;;
	-*)	:;;
	*)	break;;
	esac
	shift
done
case $# in
[1-9]*)	echo "${USAGE}" >&2
	exit 1;;
esac
case "${VERBOSE}" in
'')	VERBOSE="${ECHO}";;
esac


trap 'eval $RM $CRYPT $CLEAR $KEY_FILE $XKEY_FILE $XIVEC_FILE $STAT_FILE; exit 1' 1 2 3 15

N=0 ERRORS=0
eval $VERBOSE "'Test the ${CRYPT_PROG} program':"
eval $VERBOSE

AN=0 AE=0
for MODE in CBC ECB CFB8 OFB8 PCBC; do

	eval $VERBOSE "'  Test of mode \"${MODE}\":'"

	KEY="`$KEY_PROG -r`"
	KEY_FLAGS="-h -k ${KEY}"

	eval $VERBOSE -n "'    \"$TEXT\", $KEY: ... '"
	AN=`expr $AN + 1`
	if eval $CRYPT_PROG -e $KEY_FLAGS -m $MODE $TEXT $CRYPT; then
		if cmp -s $TEXT $CRYPT; then
			eval $VERBOSE "'Error, E(M,$KEY) == M.'"
			AE=`expr $AE + 1`
			eval $RM $CRYPT
			continue
		fi
	else
		AE=`expr $AE + 1`
		eval $RM $CRYPT
		continue
	fi
	AN=`expr $AN + 1`
	if eval "DES_MODE=${MODE}" $CRYPT_PROG -d $KEY_FLAGS $CRYPT $CLEAR; then
		if cmp -s $TEXT $CLEAR; then
			eval $VERBOSE Ok.
		else
			eval $VERBOSE "'Error, D(Me,$KEY) != M.'"
			AE=`expr $AE + 1`
		fi
	else
		AE=`expr $AE + 1`
	fi
	eval $RM $CRYPT $CLEAR
done
eval $VERBOSE "'  passed $AN tests with $AE errors.'"
N=`expr $N + $AN`
ERRORS=`expr $ERRORS + $AE`

eval $VERBOSE

CN=0 CE=0
for COMPAT in CTH SUN; do

	eval $VERBOSE "'  Test of compatibility mode \"${COMPAT}\":'"

	KEY="`$KEY_PROG -r`"
	KEY_FLAGS="-h -k ${KEY}"

	eval $VERBOSE -n "'    \"$TEXT\", $KEY: ... '"
	CN=`expr $CN + 1`
	if eval $CRYPT_PROG -e $KEY_FLAGS -b $COMPAT $TEXT $CRYPT; then
		if cmp -s $TEXT $CRYPT; then
			eval $VERBOSE "'Error, E(M,$KEY) == M.'"
			CE=`expr $CE + 1`
			eval $RM $CRYPT
			continue
		fi
	else
		CE=`expr $CE + 1`
		eval $RM $CRYPT
		continue
	fi
	CN=`expr $CN + 1`
	if eval "DES_COMPATIBLE=${COMPAT}" $CRYPT_PROG -d $KEY_FLAGS $CRYPT $CLEAR; then
		if cmp -s $TEXT $CLEAR; then
			eval $VERBOSE Ok.
		else
			eval $VERBOSE "'Error, D(Me,$KEY) != M.'"
			CE=`expr $CE + 1`
		fi
	else
		CE=`expr $CE + 1`
	fi
	eval $RM $CRYPT $CLEAR

done
eval $VERBOSE "'  passed $CN tests with $CE errors.'"
N=`expr $N + $CN`
ERRORS=`expr $ERRORS + $CE`

eval $VERBOSE

CN=0 CE=0
for CORE in DEA DEA3 DEA3B; do

	eval $VERBOSE "'  Test of core passing methods \"${CORE}\":'"

	case "${CORE}" in
	DEA)	N=1;;
	DEA3)	N=2;;
	DEA3B)  N=3;;
	esac
	KEY_FLAGS='-h'
	for KEY in `$KEY_PROG -n $N -r`; do
		KEY_FLAGS="${KEY_FLAGS} -k ${KEY}"
	done

	eval $VERBOSE -n "'    \"$TEXT\": ... '"
	CN=`expr $CN + 1`
	if eval $CRYPT_PROG -e $KEY_FLAGS -n $CORE $TEXT $CRYPT; then
		if cmp -s $TEXT $CRYPT; then
			eval $VERBOSE "'Error, E(M,K) == M.'"
			CE=`expr $CE + 1`
			eval $RM $CRYPT
			continue
		fi
	else
		CE=`expr $CE + 1`
		eval $RM $CRYPT
		continue
	fi
	CN=`expr $CN + 1`
	if eval "DES_CORE=${CORE}" $CRYPT_PROG -d $KEY_FLAGS $CRYPT $CLEAR; then
		if cmp -s $TEXT $CLEAR; then
			eval $VERBOSE Ok.
		else
			eval $VERBOSE "'Error, D(Me,K) != M.'"
			CE=`expr $CE + 1`
		fi
	else
		CE=`expr $CE + 1`
	fi
	eval $RM $CRYPT $CLEAR

done
eval $VERBOSE "'  passed $CN tests with $CE errors.'"
N=`expr $N + $CN`
ERRORS=`expr $ERRORS + $CE`

eval $VERBOSE

eval $VERBOSE "'  Test of key passing methods:'"
(
	KN=0 KE=0
	for CORE in 'DEA' 'DEA3' 'DEA3B'; do

		read KEY1 || break
		case "${CORE}" in
		DEA)	KEY2= KEY3=;;
		DEA3)	KEY3=; read KEY2 || break;;
		DEA3B)	read KEY2 || break; read KEY3 || break;;
		esac
		KEY_FLAGS= XKEY_FLAGS='-h'
		for KEY in $KEY1 $KEY2 $KEY3; do
			XKEY="`$KEY_PROG -k $KEY`"
			KEY_FLAGS="${KEY_FLAGS} -k ${KEY}"
			XKEY_FLAGS="${XKEY_FLAGS} -k ${XKEY}"
			eval $ECHO "${KEY}" '>>' $KEY_FILE
			eval $ECHO "${XKEY}" '>>' $XKEY_FILE
		done

		KN=`expr 1 + $KN`
		if eval $CRYPT_PROG -n $CORE -e $KEY_FLAGS $TEXT $CRYPT; then
			:
		else
			eval $VERBOSE "'  Error encrypting, next loop ...'"
			continue
			KE=`expr 1 + $KE`
		fi
		for METHOD in	"${KEY_FLAGS}" \
				"-f ${KEY_FILE}" \
				"${XKEY_FLAGS}" \
				"-h -f ${XKEY_FILE}" \
				"DES_KEYFILE=${KEY_FILE}" \
				"DES_XKEYFILE=${XKEY_FILE}"; do
				
			case "${METHOD}" in
			DES*=*)	KENV="${METHOD}" KFLAGS=;;
			*)	KENV= KFLAGS="${METHOD}";;
			esac
			eval $VERBOSE -n "'    \"${CORE} ${METHOD}\": ... '"
			KN=`expr 1 + $KN`
			if eval $KENV $CRYPT_PROG -n $CORE -d $KFLAGS $CRYPT $CLEAR; then
				if cmp -s $TEXT $CLEAR; then
					eval $VERBOSE Ok.
				else
					eval $VERBOSE Error.
					KE=`expr $KE + 1`
				fi
			else
				eval $VERBOSE Error.
				KE=`expr 1 + $KE`
			fi
			eval $RM $CLEAR
		done
		eval $RM $KEY_FILE $XKEY_FILE $CRYPT
	done
	eval $VERBOSE "'  passed $KN tests with $KE errors.'"
	eval $ECHO "'KN=$KN KE=$KE'" '>' $STAT_FILE
) < $TEXT
if [ -f $STAT_FILE ]; then
	. $STAT_FILE
	eval $RM $STAT_FILE
	N=`expr $N + $KN`
	ERRORS=`expr $ERRORS + $KE`
else
	ERRORS=`expr $ERRORS + 1`
fi

eval $VERBOSE

IN=0 IE=0
eval $VERBOSE "'  Test of ivec. passing methods:'"

KEY_FLAGS="-h -k `$KEY_PROG -r`"
XIVEC=`$KEY_PROG -R`
eval $ECHO "${XIVEC}" '>' $XIVEC_FILE

IN=`expr 1 + $IN`
if eval $CRYPT_PROG -e $KEY_FLAGS -i $XIVEC $TEXT $CRYPT; then
	:
else
	eval $VERBOSE "'  Error encrypting, next loop ...'"
	IE=`expr 1 + $IE`
fi
for METHOD in	"-i ${XIVEC}" \
		"-v ${XIVEC_FILE}" \
		"DES_XIVECFILE=${XIVEC_FILE}"; do
		
	case "${METHOD}" in
	DES*=*)	IENV="${METHOD}" IFLAGS=;;
	*)	IENV= IFLAGS="${METHOD}";;
	esac
	eval $VERBOSE -n "'    \"${METHOD}\": ... '"
	IN=`expr 1 + $IN`
	if eval $IENV $CRYPT_PROG -d $KEY_FLAGS $IFLAGS $CRYPT $CLEAR; then
		if cmp -s $TEXT $CLEAR; then
			eval $VERBOSE Ok.
		else
			eval $VERBOSE Error.
			IE=`expr $IE + 1`
		fi
	else
		eval $VERBOSE Error.
		IE=`expr 1 + $IE`
	fi
	eval $RM $CLEAR
done
eval $RM $XIVEC_FILE $CRYPT
eval $VERBOSE "'  passed $IN tests with $IE errors.'"
N=`expr $N + $IN`
ERRORS=`expr $ERRORS + $IE`

eval $VERBOSE

IN=0 IE=0
eval $VERBOSE "'  Test of ivec. concatenating:'"
KEY_FLAGS="-h -k `$KEY_PROG -r`"
IN=`expr 1 + $IN`
if eval $CRYPT_PROG -e $KEY_FLAGS -o $XIVEC_FILE -m CFB8 $TEXT '>' $CRYPT; then
	IN=`expr 1 + $IN`
	if eval $CRYPT_PROG -e $KEY_FLAGS -v $XIVEC_FILE -m CFB8 $TEXT '>>' $CRYPT; then
		IN=`expr 1 + $IN`
		if eval $CRYPT_PROG -d $KEY_FLAGS -m CFB8 $CRYPT '>' $CLEAR; then
			if cat $TEXT $TEXT | cmp -s - $CLEAR; then
				eval $VERBOSE "'  Ok.'"
			else
				eval $VERBOSE "'  Error comparing.'"
				IE=`expr 1 + $IE`
			fi
		else
			eval $VERBOSE "'  Error decrypting'"
			IE=`expr 1 + $IE`
		fi
	else
		eval $VERBOSE "'  Error encrypting'"
		IE=`expr 1 + $IE`
	fi
else
	eval $VERBOSE "'  Error encrypting'"
	IE=`expr 1 + $IE`
fi
eval $RM $XIVEC_FILE $CLEAR $CRYPT
eval $VERBOSE "'  passed $IN tests with $IE errors.'"
N=`expr $N + $IN`
ERRORS=`expr $ERRORS + $IE`
eval $VERBOSE

eval $VERBOSE -n "'  Test of ASCII encryption/decryption ... '"
KEY="`$KEY_PROG -r`"
KEY_FLAGS="-h -k ${KEY}"
N=`expr $N + 1`
if eval $CRYPT_PROG -a -e $KEY_FLAGS $TEXT $CRYPT; then
	if cmp -s $TEXT $CRYPT; then
		eval $VERBOSE "'Error, E(M,$KEY(file)) == M.'"
		ERRORS=`expr $ERRORS + 1`
		eval $RM $CRYPT
	elif eval $CRYPT_PROG -a -d $KEY_FLAGS $CRYPT $CLEAR; then
		if cmp -s $TEXT $CLEAR; then
			eval $VERBOSE Ok.
		else
			eval $VERBOSE "'Error, D(Me,$KEY(arg)) != M.'"
			ERRORS=`expr $ERRORS + 1`
		fi
	else
		ERRORS=`expr $ERRORS + 1`
	fi
	N=`expr $N + 1`
else
	ERRORS=`expr $ERRORS + 1`
	eval $RM $CRYPT
fi
eval $RM $CRYPT $CLEAR

eval $VERBOSE
eval $VERBOSE "'$CRYPT_PROG passed $N tests with $ERRORS errors.'"

exit $ERRORS
