/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdio.h>
#include	<string.h>
#include	<des.h>
#include	"config.h"
#include	"data.h"


#define f_FLAG	0x1L
#define l_FLAG	0x2L
#define s_FLAG	0x4L

static char		*prog;
static unsigned long	flags;


typedef int	(*dea_func_t)(
#ifdef __SDTC__
	des_cblock		*input,
	des_cblock		*input,
	des_key_schedule	schedule,
	int			encrypt
#endif
);

typedef struct	dea_entry {
			char		*name;
			dea_func_t	func;
			int		no_keys;
		} dea_entry_t;


dea_entry_t	*dp, dea_list[] = {
			{ "DEA",	des_dea,		1 },
			{ "DEA3",	des_dea3,		2 },
			{ "DEA3B",	des_dea3b,		3 },
			{ (char *) 0,	(dea_func_t) 0, 	0 }
		};


main(argc, argv)
int	argc;
char	*argv[];
{
	register int		o, tests = 0, errors = 0;
	register int		i, j, n, bit, byte;
	register char		*file = (char *) 0;
	FILE			*fd = stdin;
	des_cblock		key, out, out2;
	des_key_schedule        schedule[DES_MAX_KEYS];
	data_t			*data;
	extern int		optind;
	extern char		*optarg;


	prog = (prog = strrchr(*argv, '/')) ? (prog + 1) : *argv;

	while ((o = getopt(argc, argv, "f:ls")) != EOF)
		switch (o) {
		case 'f':
			if (flags & (f_FLAG & l_FLAG))
				goto usage;
			file = optarg;
			flags |= f_FLAG;
			break;
		case 'l':
			if (flags & (f_FLAG & l_FLAG))
				goto usage;
			flags |= l_FLAG;
			break;
		case 's':
			if (flags & s_FLAG)
				goto usage;
			flags |= s_FLAG;
			break;
		case '?':
		default:
			goto usage;
		}
	if (optind != argc)
		goto usage;

	if (flags & l_FLAG) {
		for (dp = dea_list; dp->func; dp++)
			printf("%s\n", dp->name);
		exit(0);
	}

	if (flags & f_FLAG)
		if (!(fd = fopen(file, "r")))
			goto usage;

	if (!(flags & s_FLAG)) {
		printf("Verify ");
		for (dp = dea_list; dp->func; dp++)
			printf("`%s' ", dp->name);
		printf("with data from %s:\n", (file) ? file : "<stdin>");
	}

	while (data = read_data(fd))
		for (dp = dea_list; dp->func; dp++) {

			/* 
			 * The encryption/decryption against known data.
			 * All alogorithms are assumed to be equal to
			 * des_dea if all keys are equal.
			 */

			for (i = 0; i < dp->no_keys; i++)
				(void) des_sched((des_cblock *) data->key,
						 schedule[i]);

			(void) (*dp->func)((des_cblock *) data->in,
					   (des_cblock *) out,
					   schedule[0], data->mode);

			tests++;
			if (!cmp_block(out, data->out)) {
				errors++;
				fprintf(stderr, "  %c%s(",
					(data->mode) ? 'E' : 'D', dp->name);
				print_block(stderr, data->key);
				fprintf(stderr, ", ");
				print_block(stderr, data->in);
				fprintf(stderr, ") = ");
				print_block(stderr, out);
				fprintf(stderr, " != ");
				print_block(stderr, data->out);
				fprintf(stderr, "\n");
			}

			(void) (*dp->func)((des_cblock *) data->out,
					   (des_cblock *) out,
					   schedule[0], !data->mode);
			tests++;
			if (!cmp_block(out, data->in)) {
				errors++;
				fprintf(stderr, "  %c%s(",
					(data->mode) ? 'D' : 'E', dp->name);
				print_block(stderr, data->key);
				fprintf(stderr, ", ");
				print_block(stderr, data->out);
				fprintf(stderr, ") = ");
				print_block(stderr, out);
				fprintf(stderr, " != ");
				print_block(stderr, data->in);
				fprintf(stderr, "\n");
			}

			if (dp->no_keys == 1)
				continue;

			for (i = 0; i < dp->no_keys; i++) {

				/*
				 * Test that a bit change of one bit in any
				 * of the keys yields a different output.
				 */
				
				for (j = 0; j < DES_BLOCK_BYTES; j++)
					key[j] = data->key[j];

				for (n = 0; n < DES_BLOCK_BITS; n++) {
					bit = n % 8;
					/* Ignore key parity bit */
#ifdef DES_LSB_FIRST
					if (bit == 7)
#else  /* DES_LSB_FIRST */
					if (bit == 0)
#endif /* DES_LSB_FIRST */
						continue;
					byte = n / 8;

					key[byte] ^= (unsigned char) (0x01 << bit);
						
					(void) des_sched((des_cblock *) key,
							 schedule[i]);

					(void) (*dp->func)((des_cblock *) data->in,
							   (des_cblock *) out,
							   schedule[0], data->mode);
					tests++;
					if (cmp_block(out, data->out)) {
						errors++;
						fprintf(stderr, "  %c%s(",
							(data->mode) ? 'E' : 'D',
							dp->name);
						fprintf(stderr,
							"key=%d,bit=%02d, ",
							i, n);
						print_block(stderr, data->in);
						fprintf(stderr, ") = ");
						print_block(stderr, out);
						fprintf(stderr, " == ");
						print_block(stderr, data->out);
						fprintf(stderr, "\n");
					}

					/*
					 * .. and that the data can be decrypted
					 */

					(void) (*dp->func)((des_cblock *) out,
							   (des_cblock *) out2,
							   schedule[0], !data->mode);

					tests++;
					if (!cmp_block(out2, data->in)) {
						errors++;
						fprintf(stderr, "  %c%s(",
							(data->mode) ? 'D' : 'E',
							dp->name);
						fprintf(stderr,
							"key=%d,bit=%02d, ",
							i, n);
						print_block(stderr, out);
						fprintf(stderr, ") != ");
						print_block(stderr, out2);
						fprintf(stderr, " == ");
						print_block(stderr, data->in);
						fprintf(stderr, "\n");
					}

					key[byte] ^= (unsigned char) (0x01 << bit);
				}

				(void) des_sched((des_cblock *) data->key,
						 schedule[i]);

			}

		}

	if (flags & f_FLAG)
		(void) fclose(fd);

	if (!(flags & s_FLAG)) {
		for (dp = dea_list; dp->func; dp++)
			printf("`%s' ", dp->name);
		printf("passed %d tests with %d errors.\n", tests, errors);
	}
	exit (errors);

usage:
	fprintf(stderr, "Usage: %s [-s] [-l|-f file]\n", prog);
	exit(1);

nofile:
	fprintf(stderr, "%s: Can not open file \"%s\"\n", prog, file);
	exit(1);
}
