/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdio.h>
#include	<string.h>
#include	<des.h>
#include	"config.h"


char	*prog;

#define _3_FLAG	0x1L
#define h_FLAG	0x2L
#define s_FLAG	0x4L
unsigned long	flags = 0L;


main(argc, argv)
int	argc;
char	*argv[];
{
	register int		o, st, no_keys = 1, errors = 0;
	register unsigned int	byte, bit, i, j;
	des_key_schedule	schedule[DES_MAX_KEYS];
	des_cblock		key[DES_MAX_KEYS], ib, cb, ob;
	extern int		optind;


	prog = (prog = strrchr(*argv, '/')) ? (prog + 1) : *argv;

	while ((o = getopt(argc, argv, "3hs")) != EOF)
		switch (o) {
		case '3':
			flags |= _3_FLAG;
			no_keys = 2;
			des_core = des_dea3;
			break;
		case 'h':
			flags |= h_FLAG;
			break;
		case 's':
			flags |= s_FLAG;
			break;
		case '?':
		default:
			goto usage;
		}
	if (optind + no_keys != argc)
		goto usage;

	if (!(flags & s_FLAG))
		(void) printf((flags & h_FLAG) ? "HEXKEY = {": "STRKEY = ");
	for (i = 0; i < no_keys; i++) {
		if (flags & h_FLAG) {
			if (des_hex_to_cblock(argv[optind], (des_cblock *) key[i]) < 0)
				goto badhex;
			if (!(flags & s_FLAG))
				(void) printf(i ? ", %s" : "%s", argv[optind]);
		} else {
			(void) des_string_to_key(argv[optind], key[i]);
			if (!(flags & s_FLAG))
				(void) printf(i ? ", \"%s\"" : "\"%s\"", argv[optind]);
		}
		optind++;
	}
	if (!(flags & s_FLAG))
		(void) printf((flags & h_FLAG) ? "}\n\n" : "\n\n");

	for (i = 0; i < no_keys; i++) {
		st = des_check_key_parity((des_cblock *) key[i]);
		if (!st || !(flags & s_FLAG)) {
			if (!st)
				errors++;
			(void) fputs("   KEY = ", stdout);
			des_print_cblock(stdout, (des_cblock *) key[i], 1);
			(void) printf("PARITY = %s\n\n",
				      (st) ? "CORRECT (ODD)" : "INCORRECT");
		}

		(void) des_sched((des_cblock *) key, schedule[i]);

		if (!(flags & s_FLAG)) {
			(void) printf("  KEYS = %d\n",
				      des_no_key_schedule((des_cblock *) key));
			for (j = 0; j < 16; j++) {
				(void) printf("KS[%2d] = ", j + 1);
				des_print_cblock(stdout, (des_cblock *) schedule[i][j]._, 1);
			}

			(void) putchar('\n');
		}
	}

	for (byte = 0; byte < DES_BLOCK_BYTES; byte++) {
		for (bit = 0x80; bit >= 0x01; bit >>= 1) {
			DES_ZERO_CBLOCK(ib);
			ib[byte] = bit;
			if (!(flags & s_FLAG)) {
				(void) fputs("   IN = ", stdout);
				des_print_cblock(stdout, (des_cblock *) ib, 1);
			}
			(void) des_dea((des_cblock *) ib, (des_cblock *) cb,
				       schedule[0], DES_ENCRYPT);
			if (!(flags & s_FLAG)) {
				(void) fputs("CRYPT = ", stdout);
				des_print_cblock(stdout, (des_cblock *) cb, 1);
			}
			(void) (*des_core)((des_cblock *) cb, (des_cblock *) ob,
					   schedule[0], DES_DECRYPT);
			if (!(flags & s_FLAG)) {
				(void) fputs("  OUT = ", stdout);
				des_print_cblock(stdout, (des_cblock *) ob, 1);
			}
			if (memcmp(ib, ob, sizeof(des_cblock))) {
				des_print_cblock(stdout, (des_cblock *) ib, 1);
				(void) printf("NOT EQUAL TO");
				des_print_cblock(stdout, (des_cblock *) ob, 1);
				errors++;
			}
		}
	}

	exit(errors);

usage:
	(void) fprintf(stderr, "Usage: %s [-h3s] key ...\n", prog);
	exit(1);

badhex:
	(void) fprintf(stderr, "%s: Key must be a 64 bit hex. number.\n", prog);
	exit(1);
}
