Summary: Apache HTTP daemon with SSL
Name: apache-mod_ssl
#
########################################
# Uncomment "%define" and "Requires"
# for your intended RedHat version
#
##### RedHat 5.2 #####
#%define rhrel 5.2
#Requires: redhat-release < 6.0
#
##### RedHat 6.0 #####
%define rhrel 6.0
Requires: redhat-release >= 6.0
########################################
#
%define rel 0
Release: %{rel}.%{rhrel}
%define apversion 1.3.9
%define modversion 2.4.10
%define mmversion 1.0.12
Version: %{apversion}.%{modversion}
# Serial number taken from APACHE_RELEASE definition in src/include/httpd.h
# Update serial number when the Apache version is changed.
Serial: 10309100
Group: Networking/Daemons
Source0: ftp://ftp.apache.org/apache/dist/apache_%{apversion}.tar.gz
Source1: http://www.modssl.org/source/mod_ssl-%{modversion}-%{apversion}.tar.gz
Source2: http://www.engelschall.com/sw/mm/mm-%{mmversion}.tar.gz
Source3: httpd.init
Source4: httpd.log
Source5: README.RPM
Copyright: BSD-like
Obsoletes: apache-suexec apache-extra apache-doc
Provides: webserver apache apache-mod_ssl
BuildRoot: /var/tmp/apache-root
Requires: initscripts >= 3.25
Requires: openssl >= 0.9.4
Prereq: /sbin/chkconfig
URL: http://www.modssl.org/
Packager: Magnus Stenman <stone@hkust.se>, Henri Gomez <gomez@slib.fr>


%description
apache-mod_ssl is Apache with SSL support
via mod_ssl and OpenSSL

This build is not for use in the U.S., you will have
to build your own apache-mod_ssl with RSAref for that
due to patent problems.

Built with loadable modules (all standard modules enabled).
The configuration files provided with apache
and apache-mod_ssl are unchanged.

NOTE: this RPM is intended for RedHat %{rhrel} systems.


%package devel
Group: Development/Libraries
Summary: Module development tools for apache-mod_ssl.
Obsoletes: secureweb-devel


%description devel
The apache-devel package contains header files and the
apxs script needed to build Dynamic Shared Objects (DSOs) for Apache.

If you are installing apache-mod_ssl, and want to be able
to compile or develop additional modules, you'll have to
install this package.


%prep 
rm -rf apache-mod_ssl_%{version}
mkdir -p apache-mod_ssl_%{version}
%setup -T -D -a 0 -n apache-mod_ssl_%{version}
%setup -T -D -a 1 -n apache-mod_ssl_%{version}
%setup -T -D -a 2 -n apache-mod_ssl_%{version}


%build
cd mm-%{mmversion}

OPTIM="$RPM_OPT_FLAGS" ./configure \
	--disable-shared 
make
cd ../mod_ssl-%{modversion}-%{apversion}

OPTIM="$RPM_OPT_FLAGS" ./configure \
	--with-perl=/usr/bin/perl \
	--with-apache=../apache_%{apversion} \
	--with-ssl=SYSTEM \
	--with-mm=../mm-%{mmversion} \
	--with-layout=RedHat \
	--disable-rule=WANTHSREGEX \
	--enable-module=all \
	--enable-module=define \
	--enable-shared=max \
	--enable-suexec --suexec-caller=nobody \
	--suexec-uidmin=500 --suexec-gidmin=500

cd ../apache_%{apversion}
make
make certificate TYPE=dummy
cd ..


%install
rm -rf $RPM_BUILD_ROOT
cd apache_%{apversion}
make install-quiet root="$RPM_BUILD_ROOT" \
	conf_group="nobody" \
	conf_port="80" \
	conf_port_ssl="443" \
	conf_serveradmin="webmaster@localhost" \
	conf_servername="localhost"

strip $RPM_BUILD_ROOT/usr/sbin/httpd
strip $RPM_BUILD_ROOT/usr/lib/apache/*.so

# rename directory name of contributed code
mv ../mod_ssl-%{modversion}-%{apversion}/pkg.contrib \
   ../mod_ssl-%{modversion}-%{apversion}/contrib

# the search script is not used
rm -r $RPM_BUILD_ROOT/home/httpd/html/manual/search/

# sysv init and logging
mkdir -p $RPM_BUILD_ROOT/etc/{logrotate.d,rc.d/init.d}
install $RPM_SOURCE_DIR/httpd.log $RPM_BUILD_ROOT/etc/logrotate.d/httpd
install $RPM_SOURCE_DIR/httpd.init $RPM_BUILD_ROOT/etc/rc.d/init.d/httpd


%clean
rm -rf "$RPM_BUILD_ROOT"


%post
/sbin/chkconfig --add httpd
echo ""
echo ""
echo "As supplied httpd -DSSL will run with a dummy certificate!!"
echo ""
echo "You need a server.key file in /etc/httpd/conf/ssl.key/"
echo "and you need a server.crt file in /etc/httpd/conf/ssl.crt/"
echo "After that you have to run make in that directory."
echo ""
echo "You better edit (and understand) /etc/httpd/conf/*.conf"
echo "to suit your needs!!!"
echo ""
echo ""
echo "For information about this RPM, please read the README.RPM"
echo "in /usr/doc/apache-mod_ssl-%{version}/"
echo ""


%preun
if [ $1 = 0 ]; then
	if [ -f /var/lock/subsys/httpd ]; then
		/etc/rc.d/init.d/httpd stop
	fi
	if [ -f /etc/rc.d/init.d/httpd ]; then
		/sbin/chkconfig --del httpd
	fi
fi


%files
%defattr(644 root root 755)
%attr(755,root,root)  %dir /etc/httpd
%attr(755,root,root)  %dir /etc/httpd/conf
%attr( - ,root,root)  %config(noreplace) /etc/httpd/conf/ssl.crl
%attr( - ,root,root)  %config(noreplace) /etc/httpd/conf/ssl.crt
%attr( - ,root,root)  %config(noreplace) /etc/httpd/conf/ssl.csr
%attr( - ,root,root)  %config(noreplace) /etc/httpd/conf/ssl.key
%attr( - ,root,root)  %config(noreplace) /etc/httpd/conf/ssl.prm
%attr(644,root,root)  %config(noreplace) /etc/httpd/conf/httpd.conf
%attr(644,root,root)  %config /etc/httpd/conf/magic
%attr(644,root,root)  %config /etc/httpd/conf/mime.types
%attr(644,root,root)  /etc/httpd/conf/httpd.conf.default
%attr(644,root,root)  %config /etc/logrotate.d/*
%attr(755,root,root)  %config /etc/rc.d/init.d/*

%attr( - ,root,root)  %doc apache_%{apversion}/{ABOUT_APACHE,KEYS}
%attr( - ,root,root)  %doc apache_%{apversion}/{LICENSE,LICENSE.SSL,README,README.SSL}
%attr( - ,root,root)  %doc apache_%{apversion}/src/{CHANGES,CHANGES.SSL,README.EAPI}
%attr( - ,root,root)  %doc apache_%{apversion}/src/support/suexec.[ch]
%attr( - ,root,root)  %doc mod_ssl-%{modversion}-%{apversion}/README.*
%attr( - ,root,root)  %doc mod_ssl-%{modversion}-%{apversion}/NEWS
%attr( - ,root,root)  %doc mod_ssl-%{modversion}-%{apversion}/contrib/
%attr(644,root,root)  %doc $RPM_SOURCE_DIR/README.RPM

%attr(755,root,root)  %dir /home/httpd
%attr(755,root,root)  %dir /home/httpd/html
%attr(755,root,root)  %dir /home/httpd/cgi-bin
%attr( - ,root,root)  /home/httpd/icons
%attr(644,root,root)  %config(noreplace) /home/httpd/html/index.html
%attr(644,root,root)  /home/httpd/html/apache_pb.gif
%attr( - ,root,root)  %docdir /home/httpd/html/manual
%attr( - ,root,root)  /home/httpd/html/manual

%attr( - ,root,root)  /usr/lib/apache
%attr( - ,root,root)  /usr/man/man1/*
%attr( - ,root,root)  /usr/man/man8/ab.8
%attr( - ,root,root)  /usr/man/man8/apachectl.8
%attr( - ,root,root)  /usr/man/man8/httpd.8
%attr( - ,root,root)  /usr/man/man8/logresolve.8
%attr( - ,root,root)  /usr/man/man8/rotatelogs.8
%attr( - ,root,root)  /usr/man/man8/suexec.8

%attr( - ,root,root)  /usr/sbin/ab
%attr( - ,root,root)  /usr/sbin/apachectl
%attr( - ,root,root)  /usr/sbin/httpd
%attr( - ,root,root)  /usr/sbin/logresolve
%attr( - ,root,root)  /usr/sbin/rotatelogs
%attr(711,root,root)  /usr/sbin/suexec
%attr( - ,root,root)  /usr/bin

%attr(-,nobody,nobody) %dir /var/cache/httpd
%attr( - ,root,root)  %dir /var/log/httpd


%files devel
%defattr(644 root root 755)
%attr( - ,root,root)  /usr/include/apache
%attr( - ,root,root)  /usr/sbin/apxs
%attr( - ,root,root)  /usr/man/man8/apxs.8


%changelog
* Thu Nov 25 1999 Magnus Stenman <stone@hkust.se>
- mod_ssl 2.4.9

* Tue Nov  2 1999 Henri Gomez <gomez@slib.fr>
- mod_ssl 2.4.7

* Fri Oct 22 1999 Henri Gomez <gomez@slib.fr>
- mod_ssl 2.4.6
- mm 1.0.12

* Tue Oct  1 1999 Magnus Stenman <stone@hkust.se>
- mod_ssl 2.4.5
- removed semctl patch

* Tue Sep 28 1999 Magnus Stenman <stone@hkust.se>
- mod_ssl 2.4.4
- semctl patch

* Mon Sep 27 1999 Magnus Stenman <stone@hkust.se>
- mod_ssl 2.4.3
- mm 1.0.11
- added (noreplace) to some configuration files
- removed patch to cca.sh
- added the ssl.crl and ssl.prm subdirs in conf/

* Mon Sep  6 1999 Magnus Stenman <stone@hkust.se>
- mod_ssl 2.4.2
- removed patch to loadcacert.cgi

* Tue Aug 31 1999 Magnus Stenman <stone@hkust.se>
- mod_ssl 2.4.1

* Thu Aug 26 1999 Magnus Stenman <stone@hkust.se>
- added README.RPM, removed README.suexec
- added redhat-release dependencies because people
  installed 5.2 RPMs on 6.0 machines
- openssl must now be >= 0.9.4

* Fri Aug 20 1999 Magnus Stenman <stone@hkust.se>
- apache 1.3.9
- mod_ssl 2.4.0
- removed various patches to the apache source
- now using the RedHat installation path layout

* Tue Aug  3 1999 Magnus Stenman <stone@hkust.se>
- mod_ssl 2.3.11
- removed some patches to the apache source, which
  now are performed by mod_ssl

* Thu Jul 29 1999 Magnus Stenman <stone@hkust.se>
- mod_ssl 2.3.10

* Sun Jul 25 1999 Magnus Stenman <stone@hkust.se>
- mod_ssl 2.3.8
- removed Thawte Strong Extranet Support due to
  apxs dependency problem
- changed release numbering to allow for
  simultaneous RedHat versions;
  release 0.5.2 means release 0, for RedHat 5.2

* Fri Jul 16 1999 Henri Gomez <gomez@slib.fr>
- mod_ssl 2.3.6
- mm 1.0.9
- removed eapimm (now in mod_ssl)

* Fri Jun 25 1999 Henri Gomez <gomez@slib.fr>
- mm 1.0.8
- added eapimm patch.

* Wed Jun 23 1999 Henri Gomez <gomez@slib.fr>
- mod_ssl 2.3.5 + mm 1.0.7
- now use MM shm instead dbm for SSLSessionCache
- stripped modules to reduce size
- add Thawte Strong Extranet Support

* Tue Jun  8 1999 Magnus Stenman <stone@hkust.se>
- mod_ssl 2.3.2
- added the mm shared memory library

* Tue May 25 1999 Magnus Stenman <stone@hkust.se>
- mod_ssl 2.3.1

* Tue May 25 1999 Magnus Stenman <stone@hkust.se>
- mod_ssl 2.3.0
- Changes in URLs and description
- Included more mod_ssl documentation, and
  the mod_ssl contrib directory.
- Added require for openssl >= 0.9.3

* Mon May 17 1999 Henri Gomez <gomez@slib.fr>
- ndbm localisation patch.
  following RPM 3.x naming conventions.

* Wed Apr 21 1999 Magnus Stenman <stone@hkust.se>
- Moved header files and apxs to -devel package
  Stripped httpd binary
  Removed suid bit from suexec (see README.suexec)
  Thanks to Mike McHenry <mmchen@minn.net>
  and David Harris <dharris@drh.net>

* Mon Apr 12 1999 Magnus Stenman <stone@hkust.se>
- mod_ssl 2.2.8

* Mon Mar 29 1999 Magnus Stenman <stone@hkust.se>
- mod_ssl 2.2.7

* Wed Mar 24 1999 Magnus Stenman <stone@hkust.se>
- New versions of apache and mod_ssl
- Added the new --enable-module=define
- Included more mod_ssl READMEs

* Fri Mar 19 1999 Magnus Stenman <stone@hkust.se>
- New version of mod_ssl

* Sun Feb 21 1999 Magnus Stenman <stone@hkust.se>
- New version of mod_ssl
- Removed SSLeay explicit require,
  libssl.so.0 and libcrypto.so.0 can be provided by any package.
  Thanks to Niels Poppe <niels@netbox.org>

* Mon Feb  5 1999 Magnus Stenman <stone@hkust.se>
- New version of mod_ssl

* Mon Feb  4 1999 Magnus Stenman <stone@hkust.se>
- New version of mod_ssl

* Mon Feb  1 1999 Henri Gomez <gomez@slib.fr>
- ServerRoot is in /home/httpd/html instead of /home/httpd/htdocs
  to follow Redhat way.
- Added provide WebServer for mod_php3.

* Thu Jan 28 1999 Magnus Stenman <stone@hkust.se>
- Fixed include files needed for apxs compiles
  Thanks to Manuel J. Galan <manolow@step.es>

* Wed Jan 27 1999 Magnus Stenman <stone@hkust.se>
- New version of mod_ssl
  Changed directory layout to be more "RedHat style"

* Wed Jan 20 1999 Magnus Stenman <stone@hkust.se>
- Initial build by Magnus, tweaked so it fits me.
  Based on the SRPM by Manuel J. Galan <manolow@step.es>
