/* ====================================================================
 * Copyright (c) 1998 Ralf S. Engelschall. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by 
 *     Ralf S. Engelschall <rse@engelschall.com> for use in the
 *     mod_ssl project (http://www.engelschall.com/sw/mod_ssl/)."
 *
 * 4. The names "mod_ssl" must not be used to endorse or promote
 *    products derived from this software without prior written
 *    permission. For written permission, please contact
 *    rse@engelschall.com.
 *
 * 5. Products derived from this software may not be called "mod_ssl"
 *    nor may "mod_ssl" appear in their names without prior
 *    written permission of Ralf S. Engelschall.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by 
 *     Ralf S. Engelschall <rse@engelschall.com> for use in the
 *     mod_ssl project (http://www.engelschall.com/sw/mod_ssl/)."
 *
 * THIS SOFTWARE IS PROVIDED BY RALF S. ENGELSCHALL ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RALF S. ENGELSCHALL OR
 * HIS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 */

/*
**
**  mod_sslcompat -- Backward Compatibility for old/other SSL modules
**
*/

#define CORE_PRIVATE
#include "httpd.h"
#include "http_config.h"
#include "http_conf_globals.h"
#include "http_log.h"

static const char *cmd_SSLEnable(cmd_parms *cmd, char *config);
static const char *cmd_SSLDisable(cmd_parms *cmd, char *config);
static const char *cmd_SSLCacheServerPath(cmd_parms *cmd, char *config, char *arg);
static const char *cmd_SSLCacheServerPort(cmd_parms *cmd, char *config, char *arg);
static const char *cmd_SSLRequiredCiphers(cmd_parms *cmd, char *config, char *arg);
static const char *cmd_SSL_KeyFileType(cmd_parms *cmd, char *config, char *arg);
static const char *cmd_SSL_CertFileType(cmd_parms *cmd, char *config, char *arg);
static const char *cmd_SSL_FetchKeyPhraseFrom(cmd_parms *cmd, char *config, char *arg);
static const char *cmd_SSL_X509VerifyDir(cmd_parms *cmd, char *config, char *arg);
static const char *cmd_SSL_X509VerifyPolicy(cmd_parms *cmd, char *config, char *arg);
static const char *cmd_SSL_Log(cmd_parms *cmd, char *config, char *arg);
static const char *cmd_SSL_LogX509Attributes(cmd_parms *cmd, char *config, int arg);
static const char *cmd_SSL_SessionDir(cmd_parms *cmd, char *config, char *arg);
static const char *cmd_SSL_Connect(cmd_parms *cmd, char *config, int arg);
static const char *cmd_SSL_KeyFile(cmd_parms *cmd, char *config, char *arg);
static const char *cmd_SSL_CertFile(cmd_parms *cmd, char *config, char *arg);
static const char *cmd_SSL_CipherSuite(cmd_parms *cmd, char *config, char *arg);
static const char *cmd_SSL_ClientAuth(cmd_parms *cmd, char *config, char *arg);
static const char *cmd_SSL_X509VerifyDepth(cmd_parms *cmd, char *config, char *arg);

static command_rec cmds[] = {
    /*
     * Apache-SSL backward compatibility
     */
    { "SSLEnable", cmd_SSLEnable,
      NULL, RSRC_CONF, NO_ARGS,
      "Enable SSL protocol engine [DEPRECATED: use SSLEngine on]" },
    { "SSLDisable", cmd_SSLDisable,
      NULL, RSRC_CONF, NO_ARGS,
      "Disable SSL protocol engine [DEPRECATED: use SSLEngine off]" },
    { "SSLCacheServerPath", cmd_SSLCacheServerPath,
      NULL, RSRC_CONF, TAKE1,
      "SSL Session Cache server program path [OBSOLETE: it's a NOP]" },
    { "SSLCacheServerPort", cmd_SSLCacheServerPort,
      NULL, RSRC_CONF, TAKE1,
      "SSL Session Cache server TCP port number [OBSOLETE: it's a NOP]" },
    { "SSLRequiredCiphers", cmd_SSLRequiredCiphers,
      NULL, RSRC_CONF, TAKE1,
      "Colon-delimited list of required SSL Ciphers [DEPRECATED: use SSLCipherList]" },
    /*
     * Sioux compatibility
     */
    { "SSL_KeyFileType", cmd_SSL_KeyFileType,
      NULL, RSRC_CONF, TAKE1,
      "The type of the private key file [OBSOLETE: it's a NOP]" },
    { "SSL_CertFileType", cmd_SSL_CertFileType,
      NULL, RSRC_CONF, TAKE1,
      "The type of the certificate key file [OBSOLETE: it's a NOP]" },
    { "SSL_FetchKeyPhraseFrom", cmd_SSL_FetchKeyPhraseFrom,
      NULL, RSRC_CONF, TAKE1,
      "Where to fetch the pass phrase [OBSOLETE: it's a NOP]" },
    { "SSL_X509VerifyDir", cmd_SSL_X509VerifyDir,
      NULL, RSRC_CONF, TAKE1,
      "Where to find CA certificates for client auth [DEPRECATED: Use SSLCACertificatePath]" },
    { "SSL_X509VerifyPolicy", cmd_SSL_X509VerifyPolicy,
      NULL, RSRC_CONF, TAKE1,
      "Type of policy to use for client auth [OBSOLETE: it's a NOP]" },
    { "SSL_Log", cmd_SSL_Log,
      NULL, RSRC_CONF, TAKE1,
      "SSL Logfile [DEPRECATED: Use SSLLogFile]" },
    { "SSL_LogX509Attributes", cmd_SSL_LogX509Attributes,
      NULL, RSRC_CONF, FLAG,
      "Switch indicating if X.509 attributes should be logged [OBSOLETE: it's a NOP]" },
    { "SSL_SessionDir", cmd_SSL_SessionDir,
      NULL, RSRC_CONF, TAKE1,
      "Directory where to cache session information [DEPRECATED: Use SSLSessionCacheStorage]" },
    { "SSL_Connect", cmd_SSL_Connect,
      NULL, RSRC_CONF, FLAG,
      "Switch SSL protocol engine [DEPRACTED: Use SSLEngine]" },
    { "SSL_KeyFile", cmd_SSL_KeyFile,
      NULL, RSRC_CONF, TAKE1,
      "Path to Certificate Key File [DEPRACTED: Use SSLCertifcateKeyFile]" },
    { "SSL_CertFile", cmd_SSL_CertFile,
      NULL, RSRC_CONF, TAKE1,
      "Path to Certificate File [DEPRACTED: Use SSLCertifcateFile]" },
    { "SSL_CipherSuite", cmd_SSL_CipherSuite,
      NULL, RSRC_CONF, TAKE1,
      "Colon-separated list of permitted ciphers [DEPRACTED: Use SSLCipherList]" },
    { "SSL_ClientAuth", cmd_SSL_ClientAuth,
      NULL, RSRC_CONF, TAKE1,
      "Type of client authentication [DEPRACTED: Use SSLVerifyClient]" },
    { "SSL_X509VerifyDepth", cmd_SSL_X509VerifyDepth,
      NULL, RSRC_CONF, TAKE1,
      "Depth of client authentication [DEPRACTED: Use SSLVerifyDepth]" },
    { NULL },
};

module MODULE_VAR_EXPORT sslcompat_module = {
    STANDARD_MODULE_STUFF,
    NULL,                     /* module initializer                  */
    NULL,                     /* create per-dir    config structures */
    NULL,                     /* merge  per-dir    config structures */
    NULL,                     /* create per-server config structures */
    NULL,                     /* merge  per-server config structures */
    cmds,                     /* table of config file commands       */
    NULL,                     /* [#8] MIME-typed-dispatched handlers */
    NULL,                     /* [#1] URI to filename translation    */
    NULL,                     /* [#4] validate user id from request  */
    NULL,                     /* [#5] check if the user is ok _here_ */
    NULL,                     /* [#2] check access by host address   */
    NULL,                     /* [#6] determine MIME type            */
    NULL,                     /* [#7] pre-run fixups                 */
    NULL,                     /* [#9] log a transaction              */
    NULL,                     /* [#3] header parser                  */
    NULL,                     /* child_init                          */ 
    NULL,                     /* child_exit                          */ 
    NULL                      /* [#0] post read-request              */ 
};

/* Apache-SSL `SSLEnable' -> mod_ssl `SSLEngine on' */
static const char *cmd_SSLEnable(cmd_parms *cmd, char *config)
{
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Old `SSLEnable' should be replaced with `SSLEngine on'");
    return ap_handle_command(cmd, cmd->server->lookup_defaults, 
                             "SSLEngine on");
}

/* Apache-SSL `SSLDisable' -> mod_ssl `SSLEngine off' */
static const char *cmd_SSLDisable(cmd_parms *cmd, char *config)
{
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Old `SSLDisable' should be replaced with `SSLEngine off'");
    return ap_handle_command(cmd, cmd->server->lookup_defaults, 
                             "SSLEngine off");
}

/* Apache-SSL `SSLCacheServerPath' -> IGNORE */
static const char *cmd_SSLCacheServerPath(cmd_parms *cmd, char *config, char *arg)
{
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Obsolete `SSLCacheServerPath' should be removed");
    return NULL;
}

/* Apache-SSL `SSLCacheServerPath' -> IGNORE */
static const char *cmd_SSLCacheServerPort(cmd_parms *cmd, char *config, char *arg)
{
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Obsolete `SSLCacheServerPort' should be removed");
    return NULL;
}

/* Apache-SSL `SSLRequiredCiphers' -> mod_ssl `SSLCipherList' */
static const char *cmd_SSLRequiredCiphers(cmd_parms *cmd, char *config, char *arg)
{
    char *line;
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Old `SSLRequiredCiphers' should be replaced with `SSLCipherList'");
    line = ap_psprintf(cmd->pool, "SSLCipherList %s", arg);
    return ap_handle_command(cmd, cmd->server->lookup_defaults, line);
}

/* Sioux `SSL_KeyFileType' -> IGNORE */
static const char *cmd_SSL_KeyFileType(cmd_parms *cmd, char *config, char *arg)
{
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Obsolete `SSL_KeyFileType' should be removed");
    return NULL;
}

/* Sioux `SSL_CertFileType' -> IGNORE */
static const char *cmd_SSL_CertFileType(cmd_parms *cmd, char *config, char *arg)
{
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Obsolete `SSL_CertFileType' should be removed");
    return NULL;
}

/* Sioux `SSL_FetchKeyPhraseFrom' -> IGNORE */
static const char *cmd_SSL_FetchKeyPhraseFrom(cmd_parms *cmd, char *config, char *arg)
{
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Obsolete `SSL_FetchKeyPhraseFrom' should be removed");
    return NULL;
}

/* Sioux `SSL_X509VerifyDir' -> mod_ssl `SSLCACertificatePath' */
static const char *cmd_SSL_X509VerifyDir(cmd_parms *cmd, char *config, char *arg)
{
    char *line;
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Old `SSL_X509VerifyDir' should be replaced with `SSLCACertificatePath'");
    line = ap_psprintf(cmd->pool, "SSLCACertificatePath %s", arg);
    return ap_handle_command(cmd, cmd->server->lookup_defaults, line);
}

/* Sioux `SSL_X509VerifyPolicy' -> IGNORED */
static const char *cmd_SSL_X509VerifyPolicy(cmd_parms *cmd, char *config, char *arg)
{
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Obsolete `SSL_X509VerifyPolicy' should be removed");
    return NULL;
}

/* Sioux `SSL_Log' -> mod_ssl `SSLLogFile' */
static const char *cmd_SSL_Log(cmd_parms *cmd, char *config, char *arg)
{
    char *line;
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Old `SSL_Log' should be replaced with `SSLLogFile'");
    line = ap_psprintf(cmd->pool, "SSLLogFile %s", arg);
    return ap_handle_command(cmd, cmd->server->lookup_defaults, line);
}

/* Sioux `SSL_LogX509Attributes' -> IGNORE */
static const char *cmd_SSL_LogX509Attributes(cmd_parms *cmd, char *config, int arg)
{
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Obsolete `SSL_LogX509Attributes' should be removed");
    return NULL;
}

/* Sioux `SSL_SessionDir' -> mod_ssl `SSLSessionCacheDataFile' */
static const char *cmd_SSL_SessionDir(cmd_parms *cmd, char *config, char *arg)
{
    char *line;
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Old `SSL_SessionDir /dir' should be replaced with `SSLSessionCacheStorage /dir/file'");
    line = ap_psprintf(cmd->pool, "SSLSessionCacheStorage %s/ssl_scache", arg);
    return ap_handle_command(cmd, cmd->server->lookup_defaults, line);
}

/* Sioux `SSL_Connect' -> mod_ssl `SSLEngine' */
static const char *cmd_SSL_Connect(cmd_parms *cmd, char *config, int arg)
{
    char *line;
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Old `SSL_Connect' should be replaced with `SSLEngine'");
    line = ap_psprintf(cmd->pool, "SSLEngine %s", arg ? "on" : "off");
    return ap_handle_command(cmd, cmd->server->lookup_defaults, line);
}

/* Sioux `SSL_KeyFile' -> mod_ssl `SSLCertificateKeyFile' */
static const char *cmd_SSL_KeyFile(cmd_parms *cmd, char *config, char *arg)
{
    char *line;
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Old `SSL_KeyFile' should be replaced with `SSLCertificateKeyFile'");
    line = ap_psprintf(cmd->pool, "SSLCertificateKeyFile %s", arg);
    return ap_handle_command(cmd, cmd->server->lookup_defaults, line);
}

/* Sioux `SSL_CertFile' -> mod_ssl `SSLCertificateFile' */
static const char *cmd_SSL_CertFile(cmd_parms *cmd, char *config, char *arg)
{
    char *line;
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Old `SSL_CertFile' should be replaced with `SSLCertificateFile'");
    line = ap_psprintf(cmd->pool, "SSLCertificateFile %s", arg);
    return ap_handle_command(cmd, cmd->server->lookup_defaults, line);
}

/* Sioux `SSL_CipherSuite' -> mod_ssl `SSLCipherList' */
static const char *cmd_SSL_CipherSuite(cmd_parms *cmd, char *config, char *arg)
{
    char *line;
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Old `SSL_CipherSuite' should be replaced with `SSLCipherList'");
    line = ap_psprintf(cmd->pool, "SSLCipherList %s", arg);
    return ap_handle_command(cmd, cmd->server->lookup_defaults, line);
}

/* Sioux `SSL_ClientAuth' -> mod_ssl `SSLVerifyClient' */
static const char *cmd_SSL_ClientAuth(cmd_parms *cmd, char *config, char *arg)
{
    char *line;
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Old `SSL_ClientAuth' should be replaced with `SSLVerifyClient'");
    if (strcasecmp(arg, "off"))
        arg = "none";
    else if (strcasecmp(arg, "requested"))
        arg = "require";
    else if (strcasecmp(arg, "paranoid")) {
        ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_ERR, cmd->server,
                     "`SSL_ClientAuth paranoid' not mappable to similar mod_ssl directive");
        exit(1);
    }
    line = ap_psprintf(cmd->pool, "SSLVerifyClient %s", arg);
    return ap_handle_command(cmd, cmd->server->lookup_defaults, line);
}

/* Sioux `SSL_X509VerifyDepth' -> mod_ssl `SSLVerifyDepth' */
static const char *cmd_SSL_X509VerifyDepth(cmd_parms *cmd, char *config, char *arg)
{
    char *line;
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_INFO, cmd->server,
                 "Old `SSL_X509VerifyDepth' should be replaced with `SSLVerifyDepth'");
    line = ap_psprintf(cmd->pool, "SSLVerifyDepth %s", arg);
    return ap_handle_command(cmd, cmd->server->lookup_defaults, line);
}

