/* ====================================================================
 * Copyright (c) 1998 Ralf S. Engelschall. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by 
 *     Ralf S. Engelschall <rse@engelschall.com> for use in the
 *     mod_ssl project (http://www.engelschall.com/sw/mod_ssl/)."
 *
 * 4. The names "mod_ssl" must not be used to endorse or promote
 *    products derived from this software without prior written
 *    permission. For written permission, please contact
 *    rse@engelschall.com.
 *
 * 5. Products derived from this software may not be called "mod_ssl"
 *    nor may "mod_ssl" appear in their names without prior
 *    written permission of Ralf S. Engelschall.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by 
 *     Ralf S. Engelschall <rse@engelschall.com> for use in the
 *     mod_ssl project (http://www.engelschall.com/sw/mod_ssl/)."
 *
 * THIS SOFTWARE IS PROVIDED BY RALF S. ENGELSCHALL ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RALF S. ENGELSCHALL OR
 * HIS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This product includes software developed by Ben Laurie
 * for use in the Apache-SSL HTTP server project.
 */

/*                      _             _ 
**  _ __ ___   ___   __| |    ___ ___| |  
** | '_ ` _ \ / _ \ / _` |   / __/ __| |  
** | | | | | | (_) | (_| |   \__ \__ \ | mod_ssl - Apache Interface to SSLeay
** |_| |_| |_|\___/ \__,_|___|___/___/_| http://www.engelschall.com/sw/mod_ssl/
**                      |_____|         
*/

#ifndef MOD_SSL_H
#define MOD_SSL_H 1


/*
 * Power up our brain...
 */

/* OS headers */
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <errno.h>

/* SSLeay headers */
#include <ssl.h>
#include <err.h>
#include <x509.h>
#include <pem.h>
#include <crypto.h>
#include <evp.h>

/* Apache headers */
#include "httpd.h"
#include "http_config.h"
#include "http_conf_globals.h"
#include "http_protocol.h"
#include "http_core.h"
#include "http_log.h"

/* mod_ssl headers */
#include "ssl_expr.h"

/*
 * Provide reasonable default for some defines
 */
#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE  !FALSE
#endif
#ifndef UNSET
#define UNSET -1
#endif
#ifndef NUL
#define NUL   '\0'
#endif

/*
 * Provide reasonable defines for some types
 */
#ifndef BOOL
#define BOOL bool
typedef unsigned int bool;
#endif
#ifndef UCHAR
#define UCHAR uchar
typedef unsigned char uchar;
#endif

/*
 * Provide useful shorthands
 */
#define strEQ(s1,s2)     (strcmp(s1,s2)        == 0)
#define strNE(s1,s2)     (strcmp(s1,s2)        != 0)
#define strEQn(s1,s2,n)  (strncmp(s1,s2,n)     == 0)
#define strNEn(s1,s2,n)  (strncmp(s1,s2,n)     != 0)

#define strcEQ(s1,s2)    (strcasecmp(s1,s2)    == 0)
#define strcNE(s1,s2)    (strcasecmp(s1,s2)    != 0)
#define strcEQn(s1,s2,n) (strncasecmp(s1,s2,n) == 0)
#define strcNEn(s1,s2,n) (strncasecmp(s1,s2,n) != 0)

#define strIsEmpty(s)    (s == NULL || s[0] == NUL)

#define cfgMerge(el,unset)  new->el = add->el == unset ? base->el : add->el
#define cfgMergeArray(el)   new->el = ap_append_arrays(p, add->el, base->el)
#define cfgMergeTable(el)   new->el = ap_overlay_tables(p, add->el, base->el)
#define cfgMergeString(el)  cfgMerge(el, NULL)
#define cfgMergeBool(el)    cfgMerge(el, UNSET)
#define cfgMergeInt(el)     cfgMerge(el, 0)

#define myModConfig()    ssl_ModConfig
#define mySrvConfig(srv) (SSLSrvConfigRec *)ap_get_module_config(srv->module_config,  &ssl_module)
#define myDirConfig(req) (SSLDirConfigRec *)ap_get_module_config(req->per_dir_config, &ssl_module)

#define myCtxVarSet(num,val)  ssl_ModConfig->rCtx.pV##num = val
#define myCtxVarGet(num,type) (type)(ssl_ModConfig->rCtx.pV##num)

#define AP_SRV_CMD(name, args, desc) \
        { "SSL"#name, ssl_cmd_SSL##name, NULL, RSRC_CONF, args, desc },
#define AP_DIR_CMD(name, args, desc) \
        { "SSL"#name, ssl_cmd_SSL##name, NULL, OR_FILEINFO, args, desc },
#define AP_END_CMD \
        { NULL }

/*
 * SSL Logging
 */
#define SSL_LOG_NONE    (1<<0)
#define SSL_LOG_ERROR   (1<<1)
#define SSL_LOG_WARN    (1<<2)
#define SSL_LOG_INFO    (1<<3)
#define SSL_LOG_DEBUG   (1<<4)
#define SSL_LOG_MASK    (SSL_LOG_ERROR|SSL_LOG_WARN|SSL_LOG_INFO|SSL_LOG_DEBUG)

#define SSL_ADD_NONE    (1<<8)
#define SSL_ADD_ERRNO   (1<<9)
#define SSL_ADD_SSLEAY  (1<<10)

/*
 * Defaults for the configuration
 */

#define CFGDEF_CERTIFCATE_FILE        "conf/sslcerts/server.pem"
#define CFGDEF_SESSION_CACHE_TIMEOUT  300

/* 
 * Set to TRUE if you want to allow SSL to be disabled on a per-request basis
 * (useful for subrequests) 
 */
#define SSL_IS_OPTIONAL TRUE  
#if SSL_IS_OPTIONAL
#define OPTIONAL_SSL    (r->connection->client->ssl == NULL)
#else
#define OPTIONAL_SSL    FALSE
#endif

/* 
 * Support for file locking: Try to determine whether we should use fcntl() or
 * flock().  Would be better ap_config.h could provide this... :-(
  */
#if defined(USE_FCNTL_SERIALIZED_ACCEPT)
#define SSL_USE_FCNTL 1
#include <fcntl.h>
#endif
#if defined(USE_FLOCK_SERIALIZED_ACCEPT)
#define SSL_USE_FLOCK 1
#include <sys/file.h>
#endif
#if !defined(SSL_USE_FCNTL) && !defined(SSL_USE_FLOCK)
#define SSL_USE_FLOCK 1
#if !defined(MPE) && !defined(WIN32)
#include <sys/file.h>
#endif
#ifndef LOCK_UN
#undef SSL_USE_FLOCK
#define SSL_USE_FCNTL 1
#include <fcntl.h>
#endif
#endif
#ifdef AIX
#undef SSL_USE_FLOCK
#define SSL_USE_FCNTL 1
#include <fcntl.h>
#endif

/*
 * Support for SysV IPC Semaphores
 */
#ifdef USE_SYSVSEM_SERIALIZED_ACCEPT
#define SSL_CAN_USE_IPCSEM 1
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#endif 

/*
 * Support for DBM library
 */
#ifdef SSL_USE_SDBM
#include "ssl_util_sdbm.h"
#define ssl_dbm_open     sdbm_open
#define ssl_dbm_close    sdbm_close
#define ssl_dbm_store    sdbm_store
#define ssl_dbm_fetch    sdbm_fetch
#define ssl_dbm_delete   sdbm_delete
#define ssl_dbm_firstkey sdbm_firstkey
#define ssl_dbm_nextkey  sdbm_nextkey 
#else
#include <ndbm.h>
#define ssl_dbm_open     dbm_open
#define ssl_dbm_close    dbm_close
#define ssl_dbm_store    dbm_store
#define ssl_dbm_fetch    dbm_fetch
#define ssl_dbm_delete   dbm_delete
#define ssl_dbm_firstkey dbm_firstkey
#define ssl_dbm_nextkey  dbm_nextkey 
#endif

/*
 * Give an error if SSLeay below 0.8.0 is used 
 */
#if SSLEAY_VERSION_NUMBER < 0x0800
#error "SSLeay versions below 0.8.0 are not supported"
#endif

/*
 * Correct a typo in SSLeay 
 */
#if SSLEAY_VERSION_NUMBER < 0x900
#define SSL3_TXT_ADH_DES_192_CBC_SHA SSL3_TXT_ADH_DES_196_CBC_SHA
#endif

/*
 * The own data structures
 */
typedef struct {
    pool *pPool;
    pool *pSubPool;
    array_header *aData;
} ssl_ds_array;

typedef struct {
    pool *pPool;
    pool *pSubPool;
    array_header *aKey;
    array_header *aData;
} ssl_ds_table;

/*
 * Define the SSL verify levels
 */
typedef enum {
    VERIFY_UNSET           = UNSET,
    VERIFY_NONE            = 0,
    VERIFY_OPTIONAL        = 1,
    VERIFY_REQUIRE         = 2,
    VERIFY_OPTIONAL_NO_CA  = 3
} VerifyType;

/*
 * Define the SSL pass phrase dialog types
 */
typedef enum {
    SSL_PPTYPE_UNSET   = UNSET,
    SSL_PPTYPE_BUILTIN = 0,
    SSL_PPTYPE_FILTER  = 1
} PassPhraseType;

/*
 * Define the SSL session cache modes and structures
 */
typedef enum {
    SSL_SCMODE_UNSET = UNSET,
    SSL_SCMODE_NONE  = 0,
    SSL_SCMODE_DBM   = 1,
    SSL_SCMODE_SHM   = 2
} SessionCacheMode;

typedef struct {
    uchar *ucaKey;
    int    nKey;
    uchar *ucaData;
    int    nData;
    time_t tExpiresAt;
} SessionCacheInfo;

/*
 * Define the SSL mutex modes
 */
typedef enum {
    SSL_MUTEXMODE_UNSET  = UNSET,
    SSL_MUTEXMODE_NONE   = 0,
    SSL_MUTEXMODE_FILE   = 1,
    SSL_MUTEXMODE_IPCSEM = 2
} MutexMode;

/*
 * Define the SSL requirement structure
 */
typedef struct {
    char     *cpExpr;
    ssl_expr *mpExpr;
} SSLRequirement;

/*
 * Define the mod_ssl per-module configuration structure
 * (i.e. the global configuration for each httpd process)
 */

typedef struct {
    pool         *pPool;
    /*
     * global config data
     */
    int           nInitCount;

    RSA          *pRSATmpKey;
    int           nSessionCacheMode;
    char         *szSessionCacheDataFile;
    int           nMutexMode;
    char         *szMutexFile;
    int           nMutexFD;
    int           nMutexSEMID;

    ssl_ds_table *tPublicCert;
    ssl_ds_table *tPrivateKey;

    /* 
     * context data 
     */
    struct {
        conn_rec   *pConn;
        server_rec *pServ;
        pool       *pPool;
        void       *pV1, *pV2, *pV3, *pV4, *pV5, *pV6, *pV7, *pV8, *pV9;
    } rCtx;           
} SSLModConfigRec;

/*
 * Define the mod_ssl per-server configuration structure 
 * (i.e. the configuration for the main server 
 *  and all <VirtualHost> contexts)
 */
typedef struct {
    BOOL       bEnabled;
    char      *szCertificateFile;
    char      *szKeyFile;
    char      *szCACertificatePath;
    char      *szCACertificateFile;
    char      *szCACertificateReqFile;
    char      *szLogFile;
    char      *szCipherSuite;
    FILE      *fileLogFile;
    int        nLogLevel;
    int        nVerifyDepth;
    VerifyType nVerifyClient;
    X509      *px509Certificate;
    RSA       *prsaKey;
    SSL_CTX   *pSSLCtx;
    BOOL       bFakeBasicAuth;
    int        nSessionCacheTimeout;
    int        nPassPhraseDialogType;
    char      *szPassPhraseDialogPath;
} SSLSrvConfigRec;

/*
 * Define the mod_ssl per-directory configuration structure 
 * (i.e. the local configuration for all <Directory> 
 *  and .htaccess contexts)
 */
typedef struct {
    BOOL   bSSLRequired;
    array_header *aRequirement;
} SSLDirConfigRec;

/*  
 *  function prototypes
 */

/*  API glue structures  */
extern module MODULE_VAR_EXPORT ssl_module;

/*  global configuration  */
extern SSLModConfigRec *ssl_ModConfig;

/*  configuration handling   */
void         ssl_config_global_create(void);
void        *ssl_config_server_create(pool *, server_rec *);
void        *ssl_config_server_merge(pool *, void *, void *);
void        *ssl_config_perdir_create(pool *, char *);
void        *ssl_config_perdir_merge(pool *, void *, void *);
const char  *ssl_cmd_SSLMutex(cmd_parms *, char *, char *);
const char  *ssl_cmd_SSLPassPhraseDialog(cmd_parms *, char *, char *);
const char  *ssl_cmd_SSLEngine(cmd_parms *, char *, int flag);
const char  *ssl_cmd_SSLCipherSuite(cmd_parms *, char *, char *);
const char  *ssl_cmd_SSLCertificateFile(cmd_parms *, char *, char *);
const char  *ssl_cmd_SSLCertificateKeyFile(cmd_parms *, char *, char *);
const char  *ssl_cmd_SSLCACertificatePath(cmd_parms *, char *, char *);
const char  *ssl_cmd_SSLCACertificateFile(cmd_parms *, char *, char *);
const char  *ssl_cmd_SSLCACertificateReqFile(cmd_parms *, char *, char *);
const char  *ssl_cmd_SSLVerifyClient(cmd_parms *, char *, char *level);
const char  *ssl_cmd_SSLVerifyDepth(cmd_parms *, char *, char *);
const char  *ssl_cmd_SSLSessionCache(cmd_parms *, char *, char *);
const char  *ssl_cmd_SSLSessionCacheTimeout(cmd_parms *, char *, char *);
const char  *ssl_cmd_SSLFakeBasicAuth(cmd_parms *, char *);
const char  *ssl_cmd_SSLLog(cmd_parms *, char *, char *);
const char  *ssl_cmd_SSLLogLevel(cmd_parms *, char *, char *);
const char  *ssl_cmd_SSLRequireSSL(cmd_parms *, SSLDirConfigRec *, char *);
const char  *ssl_cmd_SSLRequire(cmd_parms *, SSLDirConfigRec *, char *);

/*  module initialization  */
void         ssl_init_Module(server_rec *, pool *);
void         ssl_init_Child(server_rec *, pool *);
void         ssl_init_GetCertAndKey(server_rec *, pool *, SSLSrvConfigRec *);

/*  Apache API hooks  */
int   SSL_HOOK_SetupConnection(conn_rec *);
void         SSL_HOOK_CloseConnection(void *);
int          ssl_hook_Auth(request_rec *);
int          ssl_hook_Access(request_rec *);
int          ssl_hook_Fixup(request_rec *);
int          ssl_hook_ReadReq(request_rec *);
int          ssl_hook_Handler(request_rec *);

/*  SSLeay callbacks */
int          ssl_callback_PassPhrase(char *, int, int);
RSA         *ssl_callback_TmpRSA(SSL *, int);
int          ssl_callback_SSLVerify(int, X509_STORE_CTX *);
int          ssl_callback_NewSessionCacheEntry(SSL *, SSL_SESSION *);
SSL_SESSION *ssl_callback_GetSessionCacheEntry(SSL *, unsigned char *, int, int *);
void         ssl_callback_DelSessionCacheEntry(SSL_CTX *, SSL_SESSION *);

/*  SSL internals  */
BOOL         ssl_int_SetCertStuff(conn_rec *);

/*  Session Cache Support  */
void         ssl_scache_init(server_rec *, pool *);
void         ssl_scache_store(SSL_SESSION *, int);
SSL_SESSION *ssl_scache_retrieve(uchar *, int);
void         ssl_scache_remove(SSL_SESSION *);
void         ssl_scache_expire(void);
char        *ssl_scache_id2sz(uchar *, int);
void         ssl_scache_dbm_init(server_rec *, pool *);
void         ssl_scache_dbm_store(SessionCacheInfo *);
void         ssl_scache_dbm_retrieve(SessionCacheInfo *);
void         ssl_scache_dbm_remove(SessionCacheInfo *);
void         ssl_scache_dbm_expire(void);

/*  Pass Phrase Support  */
void         ssl_pphrase_Handle(server_rec *, pool *);
int          ssl_pphrase_Handle_CB(char *, int, int);

/*  Data Structures */
ssl_ds_array *ssl_ds_array_make(pool *, int);
BOOL          ssl_ds_array_isempty(ssl_ds_array *);
void         *ssl_ds_array_push(ssl_ds_array *);
void         *ssl_ds_array_get(ssl_ds_array *, int);
void          ssl_ds_array_wipeout(ssl_ds_array *);
void          ssl_ds_array_kill(ssl_ds_array *);
ssl_ds_table *ssl_ds_table_make(pool *, int);
BOOL          ssl_ds_table_isempty(ssl_ds_table *);
void         *ssl_ds_table_push(ssl_ds_table *, char *);
void         *ssl_ds_table_get(ssl_ds_table *, char *);
void          ssl_ds_table_wipeout(ssl_ds_table *);
void          ssl_ds_table_kill(ssl_ds_table *);

/*  Mutex Support  */
void         ssl_mutex_init(server_rec *, pool *);
void         ssl_mutex_open(server_rec *, pool *);
void         ssl_mutex_on(void);
void         ssl_mutex_off(void);
void         ssl_mutex_file_create(server_rec *, pool *);
void         ssl_mutex_file_open(server_rec *, pool *);
void         ssl_mutex_file_remove(void *);
BOOL         ssl_mutex_file_acquire(void);
BOOL         ssl_mutex_file_release(void);
void         ssl_mutex_ipcsem_create(server_rec *, pool *);
void         ssl_mutex_ipcsem_open(server_rec *, pool *);
void         ssl_mutex_ipcsem_remove(void *);
BOOL         ssl_mutex_ipcsem_acquire(void);
BOOL         ssl_mutex_ipcsem_release(void);

/*  Logfile Support  */
void         ssl_log_open(server_rec *, pool *);
void         ssl_log(server_rec *, int, const char *, ...);
void         ssl_die(void);

/*  Variables  */
char        *ssl_var_lookup(pool *, server_rec *, conn_rec *, request_rec *, char *);

/*  Utility Functions  */
void         ssl_util_strupper(char *);
void         ssl_util_uuencode(char *, const char *);
FILE        *ssl_util_ppopen(server_rec *, pool *, char *);
int          ssl_util_ppopen_child(void *, child_info *);
void         ssl_util_ppclose(server_rec *, pool *, FILE *);
char        *ssl_util_readfilter(server_rec *, pool *, char *);

#endif /* MOD_SSL_H */
